/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.derby;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.derby.DerbyDdlParsing;
import com.intellij.sql.dialects.derby.DerbyDialect;
import com.intellij.sql.dialects.derby.DerbyDmlParsing;
import com.intellij.sql.dialects.derby.DerbyExpressionParsing;
import com.intellij.sql.dialects.derby.DerbyGeneratedParser;
import com.intellij.sql.psi.SqlReferenceElementType;
import org.jetbrains.annotations.Nullable;

public class DerbyParser
extends SqlParser {
    public DerbyParser() {
        super(DerbyDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return DerbyGeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return DerbyGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return DerbyDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = DerbyExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result2;
    }

    @Override
    protected boolean parseExtraRoots(IElementType root2, PsiBuilder builder, int level) {
        return DerbyGeneratedParser.parse_root_(root2, builder, level);
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, DerbyExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return DerbyDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        DerbyGeneratedParser.analytic_clause(builder, level);
        return true;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, DerbyExpressionParsing::parenthesized_query_or_values, DerbyDmlParsing::top_query_expression, DerbyParser::parseTopQueryExpressionTail, DerbyExpressionParsing::row_element_list, (b, l) -> DerbyExpressionParsing.root_expr_0(b, l, -1) && DerbyExpressionParsing.row_element_list_separator(b, l) && DerbyExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, DerbyDmlParsing::parenthesized_aliased_join_expression, DerbyDmlParsing::top_query_expression, DerbyParser::parseTopQueryExpressionTail, DerbyDmlParsing::comma_join_expression, (b, l) -> DerbyDmlParsing.join_expression_0(b, l, -1));
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return DerbyGeneratedParser.table_opt_column_list(builder, level);
    }

    private static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        DerbyDmlParsing.query_expression_0(builder, level, -1);
        return DerbyDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

