/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol;

import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.exasol.ExaDialect;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExaTypeSystem
extends SqlTypeSystemBase {
    public static final ExaTypeSystem INSTANCE = new ExaTypeSystem();

    private ExaTypeSystem() {
        super((SqlLanguageDialectEx)ExaDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            ExaTypeSystem.$$$reportNull$$$0(0);
        }
        if ("BIGINT".equals(name2 = super.getNormalizedTypeName(name2))) {
            return "DECIMAL";
        }
        if ("BOOL".equals(name2)) {
            return "BOOLEAN";
        }
        if ("CHAR VARYING".equals(name2)) {
            return "VARCHAR";
        }
        if ("CHARACTER".equals(name2)) {
            return "CHAR";
        }
        if ("CHARACTER LARGE OBJECT".equals(name2)) {
            return "VARCHAR";
        }
        if ("CHARACTER VARYING".equals(name2)) {
            return "VARCHAR";
        }
        if ("CLOB".equals(name2)) {
            return "VARCHAR";
        }
        if ("DEC".equals(name2)) {
            return "DECIMAL";
        }
        if ("DOUBLE".equals(name2)) {
            return "DOUBLE PRECISION";
        }
        if ("FLOAT".equals(name2)) {
            return "DOUBLE PRECISION";
        }
        if ("INT".equals(name2)) {
            return "DECIMAL";
        }
        if ("INTEGER".equals(name2)) {
            return "DECIMAL";
        }
        if ("LONG VARCHAR".equals(name2)) {
            return "VARCHAR";
        }
        if ("NCHAR".equals(name2)) {
            return "CHAR";
        }
        if ("NUMBER".equals(name2)) {
            return "DECIMAL";
        }
        if ("NUMERIC".equals(name2)) {
            return "DECIMAL";
        }
        if ("NVARCHAR".equals(name2)) {
            return "VARCHAR";
        }
        if ("NVARCHAR2".equals(name2)) {
            return "VARCHAR";
        }
        if ("REAL".equals(name2)) {
            return "DOUBLE PRECISION";
        }
        if ("SHORTINT".equals(name2)) {
            return "DECIMAL";
        }
        if ("SMALLINT".equals(name2)) {
            return "DECIMAL";
        }
        if ("TINYINT".equals(name2)) {
            return "DECIMAL";
        }
        if ("VARCHAR2".equals(name2)) {
            return "VARCHAR";
        }
        String string = name2;
        if (string == null) {
            ExaTypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            ExaTypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "DECIMAL";
            }
            case REAL: {
                return "DECIMAL";
            }
            case STRING: {
                return "VARCHAR";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case DATE_TIME: {
                return "TIMESTAMP";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIMESTAMP";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case INTERVAL: {
                return "INTERVAL";
            }
        }
        return null;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            ExaTypeSystem.$$$reportNull$$$0(3);
        }
        if ("DECIMAL".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                ExaTypeSystem.$$$reportNull$$$0(4);
            }
            return category;
        }
        if ("NUMERIC".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                ExaTypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            ExaTypeSystem.$$$reportNull$$$0(6);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/exasol/ExaTypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/exasol/ExaTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

