/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.h2;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.h2.H2DdlParsing;
import com.intellij.sql.dialects.h2.H2Dialect;
import com.intellij.sql.dialects.h2.H2DmlParsing;
import com.intellij.sql.dialects.h2.H2ExpressionParsing;
import com.intellij.sql.dialects.h2.H2GeneratedParser;
import com.intellij.sql.psi.SqlReferenceElementType;
import org.jetbrains.annotations.Nullable;

public class H2Parser
extends SqlParser {
    public H2Parser() {
        super(H2Dialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return H2GeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return H2GeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return H2DmlParsing.top_query_expression(builder, level);
    }

    @Override
    protected boolean parseExtraRoots(IElementType root2, PsiBuilder builder, int level) {
        return H2GeneratedParser.parse_root_(root2, builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = H2ExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result2;
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, H2ExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return H2DdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        H2GeneratedParser.analytic_clause(builder, level);
        return true;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, H2ExpressionParsing::parenthesized_query_or_values, H2DmlParsing::top_query_expression, H2Parser::parseTopQueryExpressionTail, H2ExpressionParsing::row_element_list, (b, l) -> H2ExpressionParsing.root_expr_0(b, l, -1) && H2ExpressionParsing.row_element_list_separator(b, l) && H2ExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, H2DmlParsing::parenthesized_aliased_join_expression, H2DmlParsing::top_query_expression, H2Parser::parseTopQueryExpressionTail, H2DmlParsing::comma_join_expression, (b, l) -> H2DmlParsing.join_expression_0(b, l, -1));
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return H2GeneratedParser.table_opt_column_opt_list(builder, level);
    }

    private static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        H2DmlParsing.query_expression_0(builder, level, -1);
        return H2DmlParsing.left_inner_table_op_tail(builder, level);
    }
}

