/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.util.SystemProperties;

public final class JSParsingContextUtil {
    public static final Key<Boolean> ASYNC_METHOD_KEY = Key.create((String)"js.asyncMethod");
    private static final Key<Boolean> IS_GENERATOR_FUNCTION_KEY = Key.create((String)"js.generator.Function");
    static final boolean IS_TOP_LEVEL_ASYNC = SystemProperties.getBooleanProperty((String)"idea.js.top.level.async", (boolean)true);

    static boolean isAsyncContext(PsiBuilder builder) {
        Boolean asyncValue = (Boolean)builder.getUserData(ASYNC_METHOD_KEY);
        if (asyncValue == null) {
            return IS_TOP_LEVEL_ASYNC;
        }
        return asyncValue;
    }

    static boolean isGeneratorContext(PsiBuilder builder) {
        return Boolean.TRUE.equals(builder.getUserData(IS_GENERATOR_FUNCTION_KEY));
    }

    public static void setIsGenerator(boolean isGenerator, PsiBuilder builder) {
        builder.putUserData(IS_GENERATOR_FUNCTION_KEY, (Object)isGenerator);
    }
}

