/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.database.script.MongoJSLanguage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.MongoJSPsiUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpressionStatement;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSParenthesizedExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSProperty;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReference;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReferenceExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSUseStatement;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.ResolveUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.types.MongoJSType;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0013\u001a\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0013\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u0013*\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0006\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u0013*\u00020\u0013\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u001d\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0016\u0010\u0005\u001a\u00020\u0006*\u00020\t8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u001e"}, d2={"databaseName", "", "Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSUseStatement;", "getDatabaseName", "(Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSUseStatement;)Ljava/lang/String;", "isDbReference", "", "Lcom/intellij/psi/PsiQualifiedReference;", "(Lcom/intellij/psi/PsiQualifiedReference;)Z", "Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSReferenceExpression;", "(Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSReferenceExpression;)Z", "createJSFileFromText", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "text", "createRefFromText", "hasChild", "literal", "Lcom/intellij/psi/PsiElement;", "type", "Lcom/intellij/psi/tree/IElementType;", "isPropertyKey", "element", "isRegExpLiteral", "extractParentPropertyKey", "isFieldQualifier", "extractStatementCollectionExpr", "skipParentheses", "Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSExpression;", "intellij.database.dialects.mongo"})
public final class MongoJSPsiUtilKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPropertyKey(@NotNull PsiElement element) {
        MongoJSReferenceExpression refExpression;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        if (!(psiElement instanceof MongoJSReferenceExpression)) {
            psiElement = null;
        }
        MongoJSReferenceExpression mongoJSReferenceExpression = refExpression = (MongoJSReferenceExpression)psiElement;
        if (!((mongoJSReferenceExpression != null ? mongoJSReferenceExpression.getParent() : null) instanceof MongoJSProperty)) return false;
        PsiElement psiElement2 = refExpression.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"refExpression.parent");
        if (!Intrinsics.areEqual((Object)psiElement2.getFirstChild(), (Object)refExpression)) return false;
        return true;
    }

    public static final boolean isDbReference(@NotNull PsiQualifiedReference $this$isDbReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isDbReference, (String)"$this$isDbReference");
        return $this$isDbReference.getQualifier() == null && Intrinsics.areEqual((Object)$this$isDbReference.getReferenceName(), (Object)"db");
    }

    public static final boolean isDbReference(@NotNull MongoJSReferenceExpression $this$isDbReference) {
        int $i$f$isDbReference = 0;
        Intrinsics.checkNotNullParameter((Object)$this$isDbReference, (String)"$this$isDbReference");
        MongoJSReference mongoJSReference = $this$isDbReference.getReference();
        Intrinsics.checkNotNullExpressionValue((Object)mongoJSReference, (String)"reference");
        return MongoJSPsiUtilKt.isDbReference(mongoJSReference);
    }

    public static final boolean isRegExpLiteral(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getFirstChild();
        return Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)JSElementTypes.REGEXP_LITERAL);
    }

    public static final boolean hasChild(@NotNull PsiElement literal, @NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ASTNode aSTNode = literal.getNode();
        return (aSTNode != null ? aSTNode.findChildByType(type) : null) != null;
    }

    @Nullable
    public static final String getDatabaseName(@NotNull MongoJSUseStatement $this$databaseName) {
        Intrinsics.checkNotNullParameter((Object)$this$databaseName, (String)"$this$databaseName");
        MongoJSReferenceExpression mongoJSReferenceExpression = $this$databaseName.getDatabaseReference();
        return mongoJSReferenceExpression != null ? mongoJSReferenceExpression.getName() : null;
    }

    @NotNull
    public static final MongoJSExpression skipParentheses(@NotNull MongoJSExpression $this$skipParentheses) {
        MongoJSExpression mongoJSExpression;
        Intrinsics.checkNotNullParameter((Object)$this$skipParentheses, (String)"$this$skipParentheses");
        PsiElement psiElement = $this$skipParentheses.getParent();
        if (!(psiElement instanceof MongoJSParenthesizedExpression)) {
            psiElement = null;
        }
        if ((mongoJSExpression = (MongoJSParenthesizedExpression)psiElement) == null || (mongoJSExpression = MongoJSPsiUtilKt.skipParentheses(mongoJSExpression)) == null) {
            mongoJSExpression = $this$skipParentheses;
        }
        return mongoJSExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiElement extractParentPropertyKey(@NotNull PsiElement $this$extractParentPropertyKey, boolean isFieldQualifier) {
        Object v3;
        block6: {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)$this$extractParentPropertyKey, (String)"$this$extractParentPropertyKey");
            MongoJSResolveHelper mongoJSResolveHelper = ResolveUtilKt.getMongoHelper($this$extractParentPropertyKey);
            if (mongoJSResolveHelper == null) {
                return null;
            }
            MongoJSResolveHelper helper = mongoJSResolveHelper;
            if (isFieldQualifier && !helper.isPropertyKey($this$extractParentPropertyKey)) {
                return null;
            }
            JBIterable jBIterable = JBIterable.generate((Object)$this$extractParentPropertyKey, (Function)new Function(helper){
                final /* synthetic */ MongoJSResolveHelper $helper;

                @Nullable
                public final PsiElement fun(PsiElement e2) {
                    return PsiTreeUtil.getParentOfType((PsiElement)e2, this.$helper.getPropertyClass());
                }
                {
                    this.$helper = mongoJSResolveHelper;
                }
            }).skipWhile(new Condition($this$extractParentPropertyKey){
                final /* synthetic */ PsiElement $this_extractParentPropertyKey;

                public final boolean value(@Nullable PsiElement e2) {
                    return Intrinsics.areEqual((Object)e2, (Object)this.$this_extractParentPropertyKey);
                }
                {
                    this.$this_extractParentPropertyKey = psiElement;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.generate(this\u2026pWhile { e -> e == this }");
            Iterable iterable = (Iterable)jBIterable;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiElement psiElement;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PsiElement e2 = (PsiElement)element$iv$iv;
                boolean bl2 = false;
                if (e2 != null) {
                    PsiElement psiElement2;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    PsiElement it = psiElement2;
                    boolean bl5 = false;
                    psiElement = helper.getPropertyKey(e2);
                } else {
                    psiElement = null;
                }
                if (psiElement == null) continue;
                PsiElement psiElement3 = psiElement;
                boolean bl6 = false;
                boolean bl7 = false;
                PsiElement it$iv$iv = psiElement3;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            iterable = (List)destination$iv$iv;
            boolean bl = false;
            iterable2 = iterable;
            boolean bl9 = false;
            for (Object t : iterable2) {
                PsiElement key2 = (PsiElement)t;
                boolean bl10 = false;
                if (!(Intrinsics.areEqual((Object)key2, (Object)$this$extractParentPropertyKey) ^ true && (!isFieldQualifier || helper.getMongoType(key2) == MongoJSType.FIELD))) continue;
                v3 = t;
                break block6;
            }
            v3 = null;
        }
        PsiElement parentPropertyKey2 = v3;
        return parentPropertyKey2;
    }

    @Nullable
    public static final PsiElement extractStatementCollectionExpr(@NotNull PsiElement $this$extractStatementCollectionExpr) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$extractStatementCollectionExpr, (String)"$this$extractStatementCollectionExpr");
        extractStatementCollectionExpr.1 $fun$extractStatementCollectionReferenceExpr$1 = extractStatementCollectionExpr.1.INSTANCE;
        extractStatementCollectionExpr.2 $fun$extractStatementCollectionLiteralExpr$2 = extractStatementCollectionExpr.2.INSTANCE;
        MongoJSResolveHelper mongoJSResolveHelper = ResolveUtilKt.getMongoHelper($this$extractStatementCollectionExpr);
        if (mongoJSResolveHelper == null) {
            return null;
        }
        MongoJSResolveHelper helper = mongoJSResolveHelper;
        if (helper.getExpressionStatementClass().isInstance($this$extractStatementCollectionExpr)) {
            psiElement = $this$extractStatementCollectionExpr;
        } else {
            psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$extractStatementCollectionExpr, helper.getExpressionStatementClass(), (boolean)false);
            if (psiElement == null) {
                return null;
            }
        }
        PsiElement exprStatement = psiElement;
        PsiElement psiElement2 = PsiTreeUtil.getDeepestFirst((PsiElement)exprStatement);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiTreeUtil.getDeepestFirst(exprStatement)");
        PsiElement dbIdent = psiElement2;
        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)dbIdent, helper.getReferenceExpressionClass());
        if (psiElement3 == null) {
            return null;
        }
        PsiElement dbRefExpr = psiElement3;
        PsiReference psiReference = dbRefExpr.getReference();
        if (!(psiReference instanceof PsiQualifiedReference)) {
            psiReference = null;
        }
        PsiQualifiedReference psiQualifiedReference = (PsiQualifiedReference)psiReference;
        if (psiQualifiedReference == null) {
            return null;
        }
        PsiQualifiedReference dbRef = psiQualifiedReference;
        if (!MongoJSPsiUtilKt.isDbReference(dbRef)) {
            return null;
        }
        PsiElement psiElement4 = $fun$extractStatementCollectionReferenceExpr$1.invoke(dbRefExpr, helper);
        if (psiElement4 == null) {
            psiElement4 = $fun$extractStatementCollectionLiteralExpr$2.invoke(dbRefExpr, helper);
        }
        if (psiElement4 == null) {
            return null;
        }
        PsiElement collectionExpr2 = psiElement4;
        return collectionExpr2;
    }

    @NotNull
    public static final MongoJSReferenceExpression createRefFromText(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PsiElement psiElement = MongoJSPsiUtilKt.createJSFileFromText(project, text).getFirstChild();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.dialects.mongo.js.psi.MongoJSExpressionStatement");
        }
        PsiElement psiElement2 = ((MongoJSExpressionStatement)psiElement).getChildren()[0];
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.dialects.mongo.js.psi.MongoJSReferenceExpression");
        }
        return (MongoJSReferenceExpression)psiElement2;
    }

    @NotNull
    public static final PsiFile createJSFileFromText(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a.js", (Language)MongoJSLanguage.INSTANCE, (CharSequence)text, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiFileFactory.getInstan\u2026uage, text, false, false)");
        return psiFile;
    }
}

