/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.editing;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.MongoJSFile;
import com.intellij.sql.dialects.mongo.js.MongoJSPsiUtilKt;
import com.intellij.sql.dialects.mongo.js.MongoJSStringUtil;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSBinaryExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpressionStatement;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSLiteralExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSStringTemplateExpression;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoJSStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!this.isSupportedFile(file) || startOffsets.length > 1 || endOffsets.length > 1) {
            return null;
        }
        int selectionStart = startOffsets[0];
        int selectionEnd = endOffsets[0];
        Pair<@NotNull MongoJSLiteralExpression, Boolean> pair = MongoJSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd);
        return pair == null ? null : ((Boolean)pair.second != false ? MongoJSStringUtil.unescapeSimpleStringChars(text) : text);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int selectionEnd;
        if (!this.isSupportedFile(file)) {
            String string = text;
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        Pair<@NotNull MongoJSLiteralExpression, Boolean> pair = MongoJSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd = selectionModel.getSelectionEnd());
        if (pair == null) {
            String string = text;
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        MongoJSLiteralExpression literalExpression = (MongoJSLiteralExpression)pair.first;
        if (literalExpression.getTextOffset() == selectionStart) {
            String string = text;
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        return this.getPastedText(text, literalExpression, rawText);
    }

    public boolean isSupportedFile(@NotNull PsiFile file) {
        if (file == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return file instanceof MongoJSFile && file.isPhysical();
    }

    @NotNull
    private String getPastedText(String text, @NotNull MongoJSLiteralExpression literalExpression, RawText rawText) {
        if (literalExpression == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        String literalText = literalExpression.getText();
        boolean isStringTemplate = literalExpression instanceof MongoJSStringTemplateExpression;
        boolean isSlashQuotedDestination = !isStringTemplate && literalText.contains("\\\n");
        boolean destinationAcceptsNewLines = this.isDestinationAcceptsNewLines(rawText, isStringTemplate, isSlashQuotedDestination);
        char quote = literalText.charAt(0);
        if (StringUtil.containsChar((String)text, (char)quote) && !isStringTemplate && MongoJSStringLiteralCopyPasteProcessor.isValidStringConcatenation(literalExpression, quote + (isSlashQuotedDestination ? StringUtil.trimEnd((String)text, (String)"\\") : text) + quote)) {
            String string = text;
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (rawText != null && rawText.rawText != null) {
            if (isStringTemplate) {
                String string = MongoJSStringUtil.escapeTemplateStringChars(rawText.rawText, false, false, literalExpression);
                if (string == null) {
                    MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(6);
                }
                return string;
            }
            String string = MongoJSStringLiteralCopyPasteProcessor.escapeQuote(rawText.rawText, quote, !destinationAcceptsNewLines);
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (isStringTemplate) {
            String string = MongoJSStringUtil.escapeTemplateStringChars(text, true, true, literalExpression);
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = this.escapeSimpleText(text, literalExpression, isSlashQuotedDestination, destinationAcceptsNewLines, quote);
        if (string == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    protected boolean isDestinationAcceptsNewLines(RawText rawText, boolean isStringTemplate, boolean isSlashQuotedDestination) {
        return isStringTemplate || isSlashQuotedDestination || rawText != null && StringUtil.contains((CharSequence)rawText.rawText, (CharSequence)"\\\n");
    }

    @NotNull
    protected String escapeSimpleText(String text, @NotNull MongoJSLiteralExpression literalExpression, boolean isSlashQuotedDestination, boolean destinationAcceptsNewlines, char quote) {
        if (literalExpression == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        StringBuilder buffer = new StringBuilder(text.length());
        String lineTail = isSlashQuotedDestination ? "\\\n" : MongoJSStringLiteralCopyPasteProcessor.getTail(quote, literalExpression);
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            MongoJSStringUtil.escapeSimpleStringChars(line, quote, !destinationAcceptsNewlines, true, false, buffer);
            if (i2 == lines.length - 1) continue;
            buffer.append(lineTail);
        }
        if (text.endsWith("\n")) {
            buffer.append("\\n");
        }
        String string = buffer.toString();
        if (string == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static @Nullable Pair<@NotNull MongoJSLiteralExpression, Boolean> getSingleElementFromSelectionOrNull(@NotNull PsiFile file, int start2, int end) {
        if (file == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        MongoJSLiteralExpression atStart = (MongoJSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(start2), MongoJSLiteralExpression.class);
        MongoJSLiteralExpression atEnd = (MongoJSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(end), MongoJSLiteralExpression.class);
        if (atStart == null || atStart != atEnd || !atStart.isQuotedLiteral() || !atStart.getTextRange().containsRange(start2, end)) {
            return null;
        }
        boolean canEscape = !(atStart instanceof MongoJSStringTemplateExpression) || MongoJSStringLiteralCopyPasteProcessor.isInStringRange((MongoJSStringTemplateExpression)atStart, new TextRange(start2, end));
        return Pair.create((Object)atStart, (Object)canEscape);
    }

    private static boolean isValidStringConcatenation(@NotNull PsiElement context, @NotNull String text) {
        TextRange range;
        MongoJSExpression expression;
        PsiFile file;
        if (context == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        if (text == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        try {
            file = MongoJSPsiUtilKt.createJSFileFromText(context.getProject(), text);
        }
        catch (Exception e2) {
            return false;
        }
        PsiElement firstStatement = (PsiElement)ArrayUtil.getFirstElement((Object[])file.getChildren());
        return firstStatement instanceof MongoJSExpressionStatement && (expression = ((MongoJSExpressionStatement)firstStatement).getExpression()) instanceof MongoJSBinaryExpression && JSElementTypes.PLUS == ((MongoJSBinaryExpression)expression).getOperationSign() && (range = expression.getTextRange()).getStartOffset() == 0 && range.getEndOffset() == file.getTextLength() && PsiTreeUtil.getDeepestFirst((PsiElement)expression).getParent() instanceof MongoJSLiteralExpression && PsiTreeUtil.getDeepestLast((PsiElement)expression).getParent() instanceof MongoJSLiteralExpression;
    }

    @NotNull
    private static String getTail(char quote, @NotNull PsiElement context) {
        if (context == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(15);
        }
        CommonCodeStyleSettings commonSettings = CodeStyle.getLanguageSettings((PsiFile)context.getContainingFile(), (Language)context.getLanguage());
        String string = "\\n" + quote + (commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\n+" : "+\n") + quote;
        if (string == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static boolean isInStringRange(@NotNull MongoJSStringTemplateExpression templateExpression, int offset) {
        if (templateExpression == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(17);
        }
        return MongoJSStringLiteralCopyPasteProcessor.isInStringRange(templateExpression, TextRange.from((int)offset, (int)0));
    }

    public static boolean isInStringRange(@NotNull MongoJSStringTemplateExpression templateExpression, @NotNull TextRange range) {
        if (templateExpression == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(18);
        }
        if (range == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(19);
        }
        TextRange relativeRange = range.shiftLeft(templateExpression.getTextRange().getStartOffset());
        for (TextRange textRange : templateExpression.getStringRangesWithEmpty()) {
            if (!textRange.contains(relativeRange)) continue;
            return true;
        }
        return false;
    }

    private static String escapeQuote(String text, char quote, boolean escapeNewlines) {
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c = text.charAt(i2);
            if (escapeNewlines && c == '\n') {
                result2.append('\\').append('n');
                continue;
            }
            if (c == quote && (i2 == 0 || text.charAt(i2 - 1) != '\\')) {
                result2.append('\\').append(quote);
                continue;
            }
            result2.append(c);
        }
        return result2.toString();
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(20);
        }
        if (project == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(21);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mongo/js/editing/MongoJSStringLiteralCopyPasteProcessor";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExpression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mongo/js/editing/MongoJSStringLiteralCopyPasteProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPastedText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSimpleText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTail";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPastedText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "escapeSimpleText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSingleElementFromSelectionOrNull";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isValidStringConcatenation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTail";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInStringRange";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

