/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.oracle.OraDmlParsing;
import com.intellij.sql.dialects.oracle.OraParser;
import com.intellij.sql.dialects.oracle.OraReservedKeywords;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.ObjectUtils;

public class OraGeneratedParserUtil
extends SqlGeneratedParserUtil {
    public static final GeneratedParserUtilBase.Hook<?> PL_OFF = (builder, marker, param) -> {
        OraGeneratedParserUtil.updateRemapper(builder, 0, false);
        return marker;
    };

    public static boolean parseSimpleRefOrFunction(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser extra) {
        if (OraGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType[])new IElementType[]{OraReservedKeywords.ORA_ROWNUM, OraReservedKeywords.ORA_ROWID, OraReservedKeywords.ORA_LEVEL})) {
            return SqlParserUtil.advanceAsRefExpression(builder, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE);
        }
        if (OraGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType[])new IElementType[]{OraTypes.ORA_FINAL, OraTypes.ORA_RUNNING}) && OraGeneratedParserUtil.isOn(builder, level, "ROW_PATTERN")) {
            PsiBuilder.Marker mark2 = builder.mark();
            if (OraDmlParsing.row_pattern_function_modifier(builder, level) && OraDmlParsing.procedure_call_expression(builder, level)) {
                mark2.drop();
                return true;
            }
            mark2.rollbackTo();
        }
        return SqlGeneratedParserUtil.parseSimpleRefOrFunction(builder, level, extra);
    }

    public static boolean divOperatorCondition(PsiBuilder b, int l) {
        int start2;
        IElementType type;
        if (b.getTokenType() != OraTypes.ORA_OP_DIV) {
            return false;
        }
        int idx = -1;
        int end = b.getCurrentOffset();
        while (true) {
            if ((type = b.rawLookup(idx)) == null) {
                return false;
            }
            start2 = b.rawTokenTypeStart(idx);
            if (!SqlTokens.WS_TOKENS.contains(type)) {
                return true;
            }
            if (StringUtil.containsLineBreak((CharSequence)b.getOriginalText().subSequence(start2, end))) break;
            --idx;
            end = start2;
        }
        idx = 1;
        start2 = b.getCurrentOffset();
        while ((type = b.rawLookup(idx)) != null) {
            end = b.rawTokenTypeStart(idx + 1);
            if (!SqlTokens.COMMENT_TOKENS.contains(type)) {
                if (!SqlTokens.WS_TOKENS.contains(type)) {
                    return true;
                }
                if (StringUtil.containsLineBreak((CharSequence)b.getOriginalText().subSequence(start2, end))) break;
            }
            ++idx;
            start2 = end;
        }
        return false;
    }

    public static boolean remapReference(PsiBuilder b, int l, SqlReferenceElementType ref2) {
        IElementType elem;
        PsiBuilderImpl.ProductionMarker node = (PsiBuilderImpl.ProductionMarker)ObjectUtils.tryCast((Object)b.getLatestDoneMarker(), PsiBuilderImpl.ProductionMarker.class);
        IElementType iElementType = elem = node == null ? null : node.getTokenType();
        if (elem instanceof SqlReferenceElementType) {
            node.remapTokenType((IElementType)ref2);
        }
        return true;
    }

    public static boolean updateRemapper(PsiBuilder b, int l, boolean ignored) {
        ((OraParser)OraGeneratedParserUtil.getParser(b)).updatePlContext(b);
        return true;
    }
}

