/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import a.d.la;
import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageTableModel;
import com.intellij.coverage.view.CoverageViewBuilder;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CoverageView
extends BorderLayoutPanel
implements DataProvider,
Disposable {
    @NonNls
    private static final String ACTION_DRILL_DOWN = "DrillDown";
    @NonNls
    private static final String ACTION_GO_UP = "GoUp";
    @NonNls
    public static final String HELP_ID = "reference.toolWindows.Coverage";
    private final CoverageTableModel myModel;
    private final JBTable myTable;
    private final CoverageViewBuilder myBuilder;
    private final Project myProject;
    private final CoverageViewManager.StateBean myStateBean;
    private static final long a = la.a(3094555630603595285L, 6599004923905503440L, MethodHandles.lookup().lookupClass()).a(75744320931859L);

    public CoverageView(final Project project, CoverageDataManager dataManager, CoverageViewManager.StateBean stateBean) {
        long l2 = a ^ 0x4267B66674BCL;
        this.myProject = project;
        this.myStateBean = stateBean;
        JLabel jLabel = new JLabel();
        jLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        CoverageSuitesBundle coverageSuitesBundle = dataManager.getCurrentSuitesBundle();
        this.myModel = new CoverageTableModel(coverageSuitesBundle, stateBean, project);
        this.myTable = new JBTable((TableModel)this.myModel);
        StatusText statusText = this.myTable.getEmptyText();
        statusText.setText(CoverageBundle.message("coverage.view.no.coverage.results", new Object[0]));
        final RunConfigurationBase runConfigurationBase = coverageSuitesBundle.getRunConfiguration();
        if (runConfigurationBase != null) {
            statusText.appendText(" " + CoverageBundle.message("coverage.view.edit.run.configuration.0", new Object[0]) + " ");
            statusText.appendText(CoverageBundle.message("coverage.view.edit.run.configuration.1", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){
                private static final long a = la.a(-5496609200725634116L, 6090839798252951849L, MethodHandles.lookup().lookupClass()).a(199363435672364L);

                @Override
                public void actionPerformed(ActionEvent e10) {
                    long l2 = a ^ 0x74B51F750F70L;
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)project).findSettings((RunConfiguration)runConfigurationBase);
                    if (runnerAndConfigurationSettings != null) {
                        RunDialog.editConfiguration((Project)project, (RunnerAndConfigurationSettings)runnerAndConfigurationSettings, (String)ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])new Object[]{runConfigurationBase.getName()}));
                    } else {
                        Messages.showErrorDialog((Project)project, (String)CoverageBundle.message("coverage.view.configuration.was.not.found", runConfigurationBase.getName()), (String)CommonBundle.getErrorTitle());
                    }
                }
            });
            statusText.appendText(" " + CoverageBundle.message("coverage.view.edit.run.configuration.2", new Object[0]));
        }
        TableColumnModel tableColumnModel = this.myTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new NodeDescriptorTableCellRenderer());
        tableColumn.setPreferredWidth(this.myStateBean.myElementSize);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel().addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)this.myTable)).addToTop((Component)jLabel);
        this.addToCenter((Component)borderLayoutPanel);
        final CoverageViewTreeStructure coverageViewTreeStructure = new CoverageViewTreeStructure(project, coverageSuitesBundle, stateBean);
        this.myBuilder = new CoverageViewBuilder(project, (JList)new JBList(), this.myModel, coverageViewTreeStructure, this.myTable);
        this.myBuilder.setParentTitle(jLabel);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        new DoubleClickListener(){
            private static final long a = la.a(604753628670868044L, -2949608744930122158L, MethodHandles.lookup().lookupClass()).a(87536583022881L);

            protected boolean onDoubleClick(@NotNull MouseEvent e10) {
                if (e10 == null) {
                    2.a(0);
                }
                CoverageView.this.a(coverageViewTreeStructure);
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x12960CF69BE4L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/view/CoverageView$2", "onDoubleClick"));
            }
        }.installOn((Component)this.myTable);
        TableSpeedSearch tableSpeedSearch = new TableSpeedSearch((JTable)this.myTable);
        tableSpeedSearch.setClearSearchOnNavigateNoMatch(true);
        PopupHandler.installPopupMenu((JComponent)this.myTable, (ActionGroup)CoverageView.a(), (String)"CoverageViewPopup");
        ScrollingUtil.installActions((JTable)this.myTable);
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                CoverageView.this.myBuilder.buildRoot();
            }
        }, KeyStroke.getKeyStroke(92, SystemInfo.isMac ? 4 : 2), 0);
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_DRILL_DOWN);
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(34, SystemInfo.isMac ? 4 : 2), ACTION_DRILL_DOWN);
        this.myTable.getActionMap().put(ACTION_DRILL_DOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                CoverageView.this.a(coverageViewTreeStructure);
            }
        });
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(33, SystemInfo.isMac ? 4 : 2), ACTION_GO_UP);
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(8, 0), ACTION_GO_UP);
        this.myTable.getActionMap().put(ACTION_GO_UP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                CoverageView.this.goUp();
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("CoverageView", this.a(coverageViewTreeStructure, coverageSuitesBundle), false);
        actionToolbar.setTargetComponent((JComponent)this.myTable);
        this.addToLeft(actionToolbar.getComponent());
    }

    public void dispose() {
        if (!this.myProject.isDisposed()) {
            CoverageDataManager.getInstance(this.myProject).chooseSuitesBundle(null);
        }
    }

    public void saveSize() {
        this.myStateBean.myElementSize = this.myTable.getColumnModel().getColumn(0).getWidth();
    }

    private static ActionGroup a() {
        long l2 = a ^ 0x7D11DC6846A5L;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        return defaultActionGroup;
    }

    private ActionGroup a(CoverageViewTreeStructure coverageViewTreeStructure, CoverageSuitesBundle coverageSuitesBundle) {
        long l2 = a ^ 0x45AE9F421924L;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)new GoUpAction(this, coverageViewTreeStructure));
        if (coverageViewTreeStructure.supportFlattenPackages()) {
            defaultActionGroup.add((AnAction)new FlattenPackagesAction(this));
        }
        this.b(defaultActionGroup);
        this.a(defaultActionGroup);
        defaultActionGroup.add(ActionManager.getInstance().getAction("GenerateCoverageReport"));
        CoverageViewExtension coverageViewExtension = coverageSuitesBundle.getCoverageEngine().createCoverageViewExtension(this.myProject, coverageSuitesBundle, this.myStateBean);
        List<AnAction> list2 = coverageViewExtension.createExtraToolbarActions();
        list2.forEach(arg_0 -> ((DefaultActionGroup)defaultActionGroup).add(arg_0));
        return defaultActionGroup;
    }

    private void a(DefaultActionGroup defaultActionGroup) {
        MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        myAutoScrollFromSourceHandler.install();
        defaultActionGroup.add((AnAction)myAutoScrollFromSourceHandler.createToggleAction());
    }

    private void b(DefaultActionGroup defaultActionGroup) {
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return CoverageView.this.myStateBean.myAutoScrollToSource;
            }

            protected void setAutoScrollMode(boolean state) {
                CoverageView.this.myStateBean.myAutoScrollToSource = state;
            }
        };
        autoScrollToSourceHandler.install((JTable)this.myTable);
        defaultActionGroup.add((AnAction)autoScrollToSourceHandler.createToggleAction());
    }

    public void goUp() {
        if (this.myBuilder == null) {
            return;
        }
        this.myBuilder.goUp();
    }

    private void a(CoverageViewTreeStructure coverageViewTreeStructure) {
        AbstractTreeNode abstractTreeNode = this.a();
        if (abstractTreeNode == null) {
            return;
        }
        if (coverageViewTreeStructure.getChildElements(abstractTreeNode).length == 0) {
            if (abstractTreeNode.canNavigate()) {
                abstractTreeNode.navigate(true);
            }
            return;
        }
        this.myBuilder.drillDown();
    }

    public void updateParentTitle() {
        this.myBuilder.updateParentTitle();
    }

    private AbstractTreeNode a() {
        return (AbstractTreeNode)this.myBuilder.getSelectedValue();
    }

    private boolean a(CoverageViewTreeStructure coverageViewTreeStructure) {
        if (this.myTable == null) {
            return false;
        }
        if (this.myModel.getSize() >= 1) {
            AbstractTreeNode abstractTreeNode = (AbstractTreeNode)coverageViewTreeStructure.getRootElement();
            AbstractTreeNode abstractTreeNode2 = (AbstractTreeNode)this.myModel.getElementAt(0);
            if (abstractTreeNode2.getParent() == abstractTreeNode) {
                return true;
            }
        }
        return false;
    }

    public boolean canSelect(VirtualFile file) {
        return this.myBuilder.canSelect(file);
    }

    public void select(VirtualFile file) {
        this.myBuilder.select(file);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        long l2 = a ^ 0xC31E3FDD446L;
        if (dataId == null) {
            CoverageView.a(0);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.a();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = a ^ 0x3598DEC7E815L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/coverage/view/CoverageView", "getData"));
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private static final long a = la.a(6289600452659302533L, 1043254625341444201L, MethodHandles.lookup().lookupClass()).a(36722054242036L);

        MyAutoScrollFromSourceHandler() {
            super(CoverageView.this.myProject, (JComponent)((Object)CoverageView.this), (Disposable)CoverageView.this);
        }

        protected boolean isAutoScrollEnabled() {
            return CoverageView.this.myStateBean.myAutoScrollFromSource;
        }

        protected void setAutoScrollEnabled(boolean state) {
            CoverageView.this.myStateBean.myAutoScrollFromSource = state;
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            VirtualFile virtualFile;
            if (editor == null) {
                MyAutoScrollFromSourceHandler.a(0);
            }
            if (this.myProject.isDisposed() || !CoverageView.this.isShowing()) {
                return;
            }
            if (CoverageView.this.myStateBean.myAutoScrollFromSource && (virtualFile = editor.getFile()) != null && CoverageView.this.canSelect(virtualFile)) {
                VirtualFile virtualFile2 = null;
                if (editor instanceof TextEditor) {
                    int n2 = ((TextEditor)editor).getEditor().getCaretModel().getOffset();
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
                    if (psiFile != null) {
                        virtualFile2 = psiFile.findElementAt(n2);
                    }
                }
                CoverageView.this.myBuilder.select(virtualFile2 != null ? virtualFile2 : virtualFile);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x6627102E84F9L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/coverage/view/CoverageView$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
        }
    }

    private class GoUpAction
    extends DumbAwareAction {
        private final CoverageViewTreeStructure myTreeStructure;
        final /* synthetic */ CoverageView this$0;
        private static final long a = la.a(-7950470015242797154L, -5335318785725591844L, MethodHandles.lookup().lookupClass()).a(77674062794059L);

        GoUpAction(CoverageView coverageView, CoverageViewTreeStructure treeStructure) {
            long l2 = a ^ 0x4AE1F4F66672L;
            this.this$0 = coverageView;
            super(CoverageBundle.message("coverage.view.action.go.up", new Object[0]), CoverageBundle.message("coverage.view.action.go.up.description", new Object[0]), AllIcons.Nodes.UpLevel);
            this.myTreeStructure = treeStructure;
            this.registerCustomShortcutSet(8, 0, (JComponent)coverageView.myTable);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                GoUpAction.a(0);
            }
            this.this$0.goUp();
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                GoUpAction.a(1);
            }
            e10.getPresentation().setEnabled(!this.this$0.a(this.myTreeStructure));
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x29DE05D666FFL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/view/CoverageView$GoUpAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class FlattenPackagesAction
    extends ToggleAction {
        final /* synthetic */ CoverageView this$0;
        private static final long a = la.a(6742899422978475087L, -3757897433978597017L, MethodHandles.lookup().lookupClass()).a(62671177965662L);

        private FlattenPackagesAction(CoverageView coverageView) {
            long l2 = a ^ 0x3139F0C3F684L;
            this.this$0 = coverageView;
            super(IdeBundle.messagePointer((String)"action.flatten.packages", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.flatten.packages", (Object[])new Object[0]), AllIcons.ObjectBrowser.FlattenPackages);
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                FlattenPackagesAction.a(0);
            }
            return this.this$0.myStateBean.myFlattenPackages;
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean state) {
            if (e10 == null) {
                FlattenPackagesAction.a(1);
            }
            this.this$0.myStateBean.myFlattenPackages = state;
            Object object = this.this$0.myBuilder.getSelectedValue();
            this.this$0.myBuilder.buildRoot();
            if (object != null) {
                this.this$0.myBuilder.select(((CoverageListNode)((Object)object)).getValue());
            }
            this.this$0.myBuilder.ensureSelectionExist();
            this.this$0.myBuilder.updateParentTitle();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x32C0B8010D27L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/view/CoverageView$FlattenPackagesAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NodeDescriptorTableCellRenderer
    extends DefaultTableCellRenderer {
        private NodeDescriptorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof NodeDescriptor) {
                NodeDescriptor nodeDescriptor = (NodeDescriptor)value;
                this.setIcon(nodeDescriptor.getIcon());
                this.setText(nodeDescriptor.toString());
                if (!isSelected) {
                    this.setForeground(((CoverageListNode)nodeDescriptor).getFileStatus().getColor());
                }
            }
            return component;
        }
    }
}

