/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.process;

import a.d.la;
import com.google.common.net.HostAndPort;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSshProcess;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.SshChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SshProcess<C extends SshChannel>
extends RemoteSshProcess {
    private static final Logger LOG;
    private static final long WAITFOR_TIMEOUT = 5000L;
    private boolean myCtrlCSent;
    private long myCtrlCSentMillis;
    @NotNull
    private final C myChannel;
    private static final long b;

    public SshProcess(@NotNull C channel2) {
        if (channel2 == null) {
            SshProcess.a(0);
        }
        this.myCtrlCSent = false;
        this.myChannel = channel2;
    }

    @NotNull
    public C getChannel() {
        C c10 = this.myChannel;
        if (c10 == null) {
            SshProcess.a(1);
        }
        return c10;
    }

    public InputStream getInputStream() {
        return this.getChannel().getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.getChannel().getOutputStream();
    }

    public boolean isDisconnected() {
        return this.getChannel().isClosed();
    }

    public int exitValue() {
        if (this.a()) {
            throw new IllegalThreadStateException();
        }
        return this.getChannel().getExitStatus();
    }

    private boolean a() {
        return this.getChannel().getExitStatus() < 0 && this.getChannel().isConnected();
    }

    public void destroy() {
        if (this.getChannel().isConnected()) {
            this.getChannel().disconnect();
        }
    }

    public int waitFor() throws InterruptedException {
        long l2 = b ^ 0x684EA05133C4L;
        while (this.a()) {
            Thread.sleep(100L);
            if (!this.myCtrlCSent || System.currentTimeMillis() - this.myCtrlCSentMillis <= 5000L) continue;
            LOG.warn("Remote process wasn't closed within timeout after Ctrl+C. Disconnecting.");
            this.destroy();
        }
        return this.exitValue();
    }

    public void addRemoteTunnel(int remotePort, String host, int localPort) throws RemoteSdkException {
        try {
            this.myChannel.getSshSession().addRemoteTunnel(remotePort, host, localPort);
        }
        catch (SshTransportException sshTransportException) {
            throw new RemoteSdkException(sshTransportException.getMessage(), (Throwable)((Object)sshTransportException));
        }
    }

    public void addLocalTunnel(int localPort, int remotePort) throws RemoteSdkException {
        try {
            this.myChannel.getSshSession().addLocalTunnel(localPort, this.myChannel.getSshSession().getHost(), remotePort);
        }
        catch (SshTransportException sshTransportException) {
            throw new RemoteSdkException(sshTransportException.getMessage(), (Throwable)((Object)sshTransportException));
        }
    }

    public void addLocalTunnel(int localPort, @NotNull String host, int remotePort) throws RemoteSdkException {
        if (host == null) {
            SshProcess.a(2);
        }
        try {
            this.myChannel.getSshSession().addLocalTunnel(localPort, host, remotePort);
        }
        catch (SshTransportException sshTransportException) {
            throw new RemoteSdkException(sshTransportException.getMessage(), (Throwable)((Object)sshTransportException));
        }
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return this.myChannel.getLocalTunnel(remotePort);
    }

    public void removeLocalTunnel(int localPort) throws RemoteSdkException {
        try {
            this.myChannel.getSshSession().removeLocalTunnel(localPort);
        }
        catch (SshTransportException sshTransportException) {
            throw new RemoteSdkException(sshTransportException.getMessage(), (Throwable)((Object)sshTransportException));
        }
    }

    public boolean sendCtrlC() {
        try {
            this.getOutputStream().write(3);
            this.getOutputStream().flush();
            this.myCtrlCSent = true;
            this.myCtrlCSentMillis = System.currentTimeMillis();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @NotNull
    public SshSession getSession() {
        SshSession sshSession = this.myChannel.getSshSession();
        if (sshSession == null) {
            SshProcess.a(3);
        }
        return sshSession;
    }

    static {
        b = la.a(-8843183731556878741L, 4142434173987627403L, MethodHandles.lookup().lookupClass()).a(278473431841257L);
        LOG = Logger.getInstance(SshProcess.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x5EB59EE35869L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/process/SshProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/process/SshProcess";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChannel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addLocalTunnel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

