/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import a.d.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.CidrUtilsBundle;
import com.jetbrains.cidr.system.HostMachine;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrToolsUtil {
    public static final int READ_VERSION_TIMEOUT = 10000;
    public static final int PATH_CACHE_SIZE = 10000;
    private static final String envCommand = "env";
    private static final String envNullFlag = "--null";
    private static final long a = la.a(-2939523153985869230L, -7927773884305203721L, MethodHandles.lookup().lookupClass()).a(64884539882773L);

    @Nullable
    public static ProgressIndicator getProgressIndicator() {
        return ProgressIndicatorProvider.getGlobalProgressIndicator();
    }

    @NotNull
    public static ProcessOutput runWithProgress(CapturingProcessHandler handler) {
        return CidrToolsUtil.runWithProgress(handler, 0);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull BaseProcessHandler<?> handler, int timeout) {
        if (handler == null) {
            CidrToolsUtil.a(0);
        }
        return CidrToolsUtil.runWithProgress(handler, timeout);
    }

    @NotNull
    public static ProcessOutput runProcess(@NotNull BaseProcessHandler<?> handler, @Nullable ProgressIndicator indicator, int timeout) {
        if (handler == null) {
            CidrToolsUtil.a(1);
        }
        return CidrToolsUtil.runProcess(handler, indicator, timeout);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull ProcessHandler handler, int timeout) {
        ProgressIndicator progressIndicator2;
        ProcessOutput processOutput;
        if (handler == null) {
            CidrToolsUtil.a(2);
        }
        if ((processOutput = CidrToolsUtil.runProcess(handler, progressIndicator2 = CidrToolsUtil.getProgressIndicator(), timeout)).isCancelled()) {
            throw new ProcessCanceledException();
        }
        ProcessOutput processOutput2 = processOutput;
        if (processOutput2 == null) {
            CidrToolsUtil.a(3);
        }
        return processOutput2;
    }

    @NotNull
    public static ProcessOutput runProcess(@NotNull ProcessHandler handler, @Nullable ProgressIndicator indicator, int timeout) {
        if (handler == null) {
            CidrToolsUtil.a(4);
        }
        ProcessOutput processOutput = CidrToolsUtil.a(new CapturingProcessRunner(handler), indicator, timeout);
        if (processOutput == null) {
            CidrToolsUtil.a(5);
        }
        return processOutput;
    }

    private static ProcessOutput a(@NotNull CapturingProcessRunner capturingProcessRunner, @Nullable ProgressIndicator progressIndicator2, int n2) {
        if (capturingProcessRunner == null) {
            CidrToolsUtil.a(6);
        }
        return progressIndicator2 == null ? capturingProcessRunner.runProcess(n2) : capturingProcessRunner.runProcess(progressIndicator2, n2);
    }

    public static boolean checkSuccess(@NotNull GeneralCommandLine cl2, @NotNull ProcessOutput output, @NotNull Logger logger) {
        if (cl2 == null) {
            CidrToolsUtil.a(7);
        }
        if (output == null) {
            CidrToolsUtil.a(8);
        }
        if (logger == null) {
            CidrToolsUtil.a(9);
        }
        if (output.getExitCode() == 0 && !output.isTimeout()) {
            return true;
        }
        logger.info(CidrToolsUtil.logInfo(cl2, output));
        return false;
    }

    @NotNull
    public static String logInfo(@NotNull GeneralCommandLine cl2, @NotNull ProcessOutput output) {
        if (cl2 == null) {
            CidrToolsUtil.a(10);
        }
        if (output == null) {
            CidrToolsUtil.a(11);
        }
        String string = "[" + cl2.getCommandLineString() + "]: " + CidrToolsUtil.extractError(output);
        if (string == null) {
            CidrToolsUtil.a(12);
        }
        return string;
    }

    @NotNull
    public static String extractError(@NotNull ProcessOutput output) {
        long l2 = a ^ 0x6DCA71F7B68FL;
        if (output == null) {
            CidrToolsUtil.a(13);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (output.isTimeout()) {
            stringBuilder.append("(timed out)");
        } else {
            stringBuilder.append("(exit code ").append(output.getExitCode()).append(") ");
            if (!output.getStderr().isEmpty()) {
                stringBuilder.append(output.getStderr());
            } else {
                stringBuilder.append(output.getStdout());
            }
        }
        String string = stringBuilder.toString();
        if (string == null) {
            CidrToolsUtil.a(14);
        }
        return string;
    }

    @Nullable
    public static String readOneLineWithProgress(@NotNull GeneralCommandLine commandLine, int timeout) {
        if (commandLine == null) {
            CidrToolsUtil.a(15);
        }
        try {
            ProcessOutput processOutput = CidrToolsUtil.runWithProgress(new CapturingProcessHandler(commandLine), timeout);
            return (String)ContainerUtil.getFirstItem((List)StringsKt.lines((CharSequence)processOutput.getStdout()));
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    public static void setHasPty(@NotNull OSProcessHandler processHandler, boolean usePty) {
        if (processHandler == null) {
            CidrToolsUtil.a(16);
        }
        if (usePty) {
            processHandler.setHasPty(true);
            processHandler.setShouldDestroyProcessRecursively(false);
        }
    }

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull String file, @NotNull HostMachine host) throws IOException, ExecutionException {
        if (file == null) {
            CidrToolsUtil.a(17);
        }
        if (host == null) {
            CidrToolsUtil.a(18);
        }
        return CidrToolsUtil.readLinuxEnvironmentFromFile(file, host, null, null);
    }

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull Path file, @NotNull HostMachine host) throws IOException, ExecutionException {
        if (file == null) {
            CidrToolsUtil.a(19);
        }
        if (host == null) {
            CidrToolsUtil.a(20);
        }
        return CidrToolsUtil.readLinuxEnvironmentFromFile(file.toString(), host, null, null);
    }

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull String file, @NotNull HostMachine host, @Nullable String interpreterPath, @Nullable String envPath) throws IOException, ExecutionException {
        long l2 = a ^ 0x885049D43F7L;
        if (file == null) {
            CidrToolsUtil.a(21);
        }
        if (host == null) {
            CidrToolsUtil.a(22);
        }
        String string = envPath == null ? envCommand : envPath;
        boolean bl2 = CidrToolsUtil.a(host, string);
        if (interpreterPath == null && (interpreterPath = CidrToolsUtil.a(host, string, bl2)) == null) {
            throw new ExecutionException(CidrUtilsBundle.message("error.no.shell.interpreter.to.read.file", new Object[0]));
        }
        StringBuilder stringBuilder = new StringBuilder(envCommand);
        if (bl2) {
            stringBuilder.append(" ").append(envNullFlag);
        }
        String string2 = "source \"$0\" && " + stringBuilder;
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{interpreterPath, "-l", "-c", stringBuilder.toString()});
        GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(new String[]{interpreterPath, "-l", "-c", string2, file});
        Map<String, String> map = CidrToolsUtil.a(generalCommandLine, host, bl2);
        Map<String, String> map2 = CidrToolsUtil.a(generalCommandLine2, host, bl2);
        return CidrToolsUtil.subtractEnvironments(map2, map);
    }

    @Nullable
    private static String a(@NotNull HostMachine hostMachine, String string, boolean bl2) throws ExecutionException, IOException {
        long l2 = a ^ 0x4FB2FBA3B0D0L;
        if (hostMachine == null) {
            CidrToolsUtil.a(23);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(string);
        if (bl2) {
            generalCommandLine.addParameter(envNullFlag);
        }
        Map<String, String> map = CidrToolsUtil.a(generalCommandLine, hostMachine, bl2);
        return map.getOrDefault("SHELL", null);
    }

    private static boolean a(@NotNull HostMachine hostMachine, @NotNull String string) {
        long l2 = a ^ 0x23198E23C6BL;
        if (hostMachine == null) {
            CidrToolsUtil.a(24);
        }
        if (string == null) {
            CidrToolsUtil.a(25);
        }
        int n2 = 1000;
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{string, envNullFlag});
        CidrLogService.LOG.debug("Going to execute command {}", new Object[]{generalCommandLine});
        try {
            ProcessOutput processOutput = hostMachine.runProcess(generalCommandLine, 1000);
            return processOutput.checkSuccess(CidrLogService.LOG);
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }

    @NotNull
    private static Map<String, String> a(@NotNull GeneralCommandLine generalCommandLine, @NotNull HostMachine hostMachine, final boolean bl2) throws ExecutionException, IOException {
        long l2 = a ^ 0x3B7E84845CECL;
        if (generalCommandLine == null) {
            CidrToolsUtil.a(26);
        }
        if (hostMachine == null) {
            CidrToolsUtil.a(27);
        }
        int n2 = 5000;
        CidrLogService.LOG.debug("Going to execute command {}", new Object[]{generalCommandLine});
        final ProcessOutput processOutput = hostMachine.runProcess(generalCommandLine.withEnvironment("LC_ALL", "C.UTF-8"), 5000);
        if (!processOutput.checkSuccess(CidrLogService.LOG)) {
            throw new IOException(processOutput.getStderr());
        }
        return new HashMap<String, String>(){
            {
                Arrays.stream(processOutput.getStdout().split(bl2 ? "\u0000" : "\n")).forEach((? super T string) -> {
                    int n2 = string.indexOf("=");
                    if (n2 > 0) {
                        this.put(string.substring(0, n2), string.substring(n2 + 1));
                    }
                });
            }
        };
    }

    @NotNull
    public static Map<String, String> subtractEnvironments(@NotNull Map<String, String> sourcedEnv, @NotNull Map<String, String> originalEnv) {
        if (sourcedEnv == null) {
            CidrToolsUtil.a(28);
        }
        if (originalEnv == null) {
            CidrToolsUtil.a(29);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(sourcedEnv);
        originalEnv.forEach((string, string2) -> {
            if (hashMap.containsKey(string) && Objects.equals(string2, hashMap.get(string))) {
                hashMap.remove(string);
            }
        });
        HashMap<String, String> hashMap2 = hashMap;
        if (hashMap2 == null) {
            CidrToolsUtil.a(30);
        }
        return hashMap2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x43D14B550536L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 30: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/CidrToolsUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envPath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellSourceCmd";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcedEnv";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalEnv";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/CidrToolsUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithProgress";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "logInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractError";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "subtractEnvironments";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runWithProgress";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 30: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkSuccess";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractError";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readOneLineWithProgress";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setHasPty";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readLinuxEnvironmentFromFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getShellPath";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "testEnvForNullFlag";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "runCommandAndParseEnv";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "subtractEnvironments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 14: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Status {
        @NotNull
        public final StatusCode code;
        @NotNull
        @Nls
        public final String message;
        private static final long a = la.a(2292580394386978430L, 4273291292362182695L, MethodHandles.lookup().lookupClass()).a(235303740370168L);

        public Status(@NotNull StatusCode code, @NotNull @Nls String message) {
            if (code == null) {
                Status.a(0);
            }
            if (message == null) {
                Status.a(1);
            }
            this.code = code;
            this.message = message;
        }

        public static Status error(@NotNull @Nls String message) {
            if (message == null) {
                Status.a(2);
            }
            return new Status(StatusCode.ERROR, message);
        }

        public static Status of(@NotNull Pair<Boolean, @Nls String> status) {
            if (status == null) {
                Status.a(3);
            }
            return new Status((Boolean)status.first != false ? StatusCode.OK : StatusCode.ERROR, (String)status.second);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Status status = (Status)o2;
            return this.code == status.code && this.message.equals(status.message);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.code, this.message});
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = a ^ 0x23554C83B6D9L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/toolchains/CidrToolsUtil$Status";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "of";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class StatusCode
    extends Enum<StatusCode> {
        public static final /* enum */ StatusCode OK;
        public static final /* enum */ StatusCode WARNING;
        public static final /* enum */ StatusCode ERROR;
        private static final /* synthetic */ StatusCode[] $VALUES;

        public static StatusCode[] values() {
            return (StatusCode[])$VALUES.clone();
        }

        public static StatusCode valueOf(String name) {
            return Enum.valueOf(StatusCode.class, name);
        }

        static {
            long l2 = la.a(7617628686577745629L, 1424038597035721816L, MethodHandles.lookup().lookupClass()).a(140843665718227L) ^ 0x1B164BF1CA45L;
            OK = new StatusCode();
            WARNING = new StatusCode();
            ERROR = new StatusCode();
            $VALUES = new StatusCode[]{OK, WARNING, ERROR};
        }
    }
}

