/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataView;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.Utils;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.uml.utils.DiagramBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@ThreadSafe
public abstract class DiagramDataModel<T>
extends UserDataHolderBase
implements ModificationTracker,
Disposable,
DiagramDataView<T> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final DiagramProvider<T> myProvider;
    @NotNull
    private final DiagramVisibilityManager myVisibilityManager;
    @Nullable
    private final DiagramScopeManager<T> myScopeManager;
    @NotNull
    private final DiagramNodeContentManager myNodeContentManager;
    @Nullable
    private volatile T myOriginalElement;
    @GuardedBy(value="myNotesLock")
    @NotNull
    private final Map<DiagramNode<?>, DiagramNoteNode> myNotes;
    @GuardedBy(value="myNotesLock")
    @NotNull
    private final Map<DiagramNoteNode, DiagramNoteEdge> myNoteEdges;
    @NotNull
    private final Object myNotesLock;
    private volatile boolean isShowDependencies;
    private volatile boolean isInitState;
    @NotNull
    protected final SimpleModificationTracker myModificationTracker;

    public DiagramDataModel(@NotNull Project project, @NotNull DiagramProvider<T> provider) {
        if (project == null) {
            DiagramDataModel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            DiagramDataModel.$$$reportNull$$$0(1);
        }
        this.myNotes = new HashMap();
        this.myNoteEdges = new HashMap<DiagramNoteNode, DiagramNoteEdge>();
        this.myNotesLock = new Object();
        this.isShowDependencies = false;
        this.isInitState = true;
        this.myProject = project;
        this.myProvider = provider;
        this.myVisibilityManager = provider.createVisibilityManager();
        this.myScopeManager = provider.createScopeManager(project);
        this.myNodeContentManager = this.initNodeContentManager(provider);
        this.myModificationTracker = this.createModificationTracker();
    }

    @NotNull
    protected DiagramNodeContentManager initNodeContentManager(@NotNull DiagramProvider<T> provider) {
        if (provider == null) {
            DiagramDataModel.$$$reportNull$$$0(2);
        }
        DiagramNodeContentManager nodeContentManager = provider.createNodeContentManager();
        DiagramConfiguration configuration = DiagramConfiguration.getInstance();
        for (DiagramCategory category : nodeContentManager.getContentCategories()) {
            if (!configuration.isEnabledByDefault(provider, category.getName())) continue;
            nodeContentManager.setCategoryEnabled(category, true);
        }
        DiagramNodeContentManager diagramNodeContentManager = nodeContentManager;
        if (diagramNodeContentManager == null) {
            DiagramDataModel.$$$reportNull$$$0(3);
        }
        return diagramNodeContentManager;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DiagramDataModel.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public DiagramProvider<T> getProvider() {
        DiagramProvider<T> diagramProvider = this.myProvider;
        if (diagramProvider == null) {
            DiagramDataModel.$$$reportNull$$$0(5);
        }
        return diagramProvider;
    }

    @NotNull
    public DiagramVisibilityManager getVisibilityManager() {
        DiagramVisibilityManager diagramVisibilityManager = this.myVisibilityManager;
        if (diagramVisibilityManager == null) {
            DiagramDataModel.$$$reportNull$$$0(6);
        }
        return diagramVisibilityManager;
    }

    @Nullable
    public DiagramScopeManager<T> getScopeManager() {
        return this.myScopeManager;
    }

    @NotNull
    public DiagramNodeContentManager getNodeContentManager() {
        DiagramNodeContentManager diagramNodeContentManager = this.myNodeContentManager;
        if (diagramNodeContentManager == null) {
            DiagramDataModel.$$$reportNull$$$0(7);
        }
        return diagramNodeContentManager;
    }

    @Nullable
    public T getOriginalElement() {
        return this.myOriginalElement;
    }

    public void setOriginalElement(@Nullable T originalElement) {
        this.myOriginalElement = originalElement;
    }

    public final boolean isModelInitializationFinished() {
        return !this.isInitState;
    }

    public final void setModelInitializationFinished() {
        this.isInitState = false;
    }

    public final void setShowDependencies(boolean show) {
        this.isShowDependencies = show;
    }

    public final boolean isShowDependencies() {
        return this.isShowDependencies;
    }

    public boolean isDependencyDiagramSupported() {
        return false;
    }

    public boolean isPsiListener() {
        return false;
    }

    @NotNull
    public DiagramBuilder getBuilder() {
        DiagramBuilder builder = (DiagramBuilder)this.getUserData(Utils.GRAPH_BUILDER);
        Logger.getInstance(DiagramDataModel.class).assertTrue(builder != null, (Object)"Forget to set GraphBuilder");
        DiagramBuilder diagramBuilder = builder;
        if (diagramBuilder == null) {
            DiagramDataModel.$$$reportNull$$$0(8);
        }
        return diagramBuilder;
    }

    @NotNull
    public abstract ModificationTracker getModificationTracker();

    @NotNull
    protected SimpleModificationTracker createModificationTracker() {
        return new SimpleModificationTracker();
    }

    public long getModificationCount() {
        return this.myModificationTracker.getModificationCount();
    }

    protected void incModificationCount() {
        this.myModificationTracker.incModificationCount();
    }

    @Override
    @NotNull
    public abstract Collection<? extends DiagramNode<T>> getNodes();

    @NotNull
    public abstract String getNodeName(@NotNull DiagramNode<T> var1);

    @NotNull
    public String getEdgeName(@NotNull DiagramEdge<T> e) {
        if (e == null) {
            DiagramDataModel.$$$reportNull$$$0(9);
        }
        String string = e.getName();
        if (string == null) {
            DiagramDataModel.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public abstract DiagramNode<T> addElement(@Nullable T var1);

    public void removeNode(@NotNull DiagramNode<T> node) {
        if (node == null) {
            DiagramDataModel.$$$reportNull$$$0(11);
        }
    }

    public boolean hasElement(@Nullable T element) {
        return false;
    }

    public void collapseNode(@NotNull DiagramNode<T> node) {
        if (node == null) {
            DiagramDataModel.$$$reportNull$$$0(12);
        }
    }

    public void expandNode(@NotNull DiagramNode<T> node) {
        if (node == null) {
            DiagramDataModel.$$$reportNull$$$0(13);
        }
    }

    @Nullable
    public NodesGroup getGroup(@NotNull DiagramNode<T> n) {
        if (n == null) {
            DiagramDataModel.$$$reportNull$$$0(14);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Map<DiagramNode<?>, DiagramNoteNode> getNotes() {
        Object object = this.myNotesLock;
        // MONITORENTER : object
        HashMap hashMap = new HashMap(this.myNotes);
        // MONITOREXIT : object
        if (hashMap != null) return hashMap;
        DiagramDataModel.$$$reportNull$$$0(15);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Collection<DiagramNoteEdge> getNoteEdges() {
        Object object = this.myNotesLock;
        // MONITORENTER : object
        ArrayList<DiagramNoteEdge> arrayList = new ArrayList<DiagramNoteEdge>(this.myNoteEdges.values());
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        DiagramDataModel.$$$reportNull$$$0(16);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DiagramNoteNode addNote(@NotNull DiagramNode<T> node, @Nullable @Nls String note) {
        if (node == null) {
            DiagramDataModel.$$$reportNull$$$0(17);
        }
        if (note != null && !note.isEmpty()) {
            Object object = this.myNotesLock;
            synchronized (object) {
                if (!this.myNotes.containsKey(node)) {
                    DiagramNoteNode noteNode = new DiagramNoteNode(node, note);
                    this.myNotes.put(node, noteNode);
                    this.myNoteEdges.put(noteNode, new DiagramNoteEdge(node, noteNode));
                    return noteNode;
                }
                DiagramNoteNode noteNode = this.myNotes.get(node);
                noteNode.setNote(note);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNote(@NotNull DiagramNoteNode note) {
        if (note == null) {
            DiagramDataModel.$$$reportNull$$$0(18);
        }
        Object object = this.myNotesLock;
        synchronized (object) {
            if (this.myNotes.containsValue(note)) {
                this.myNotes.remove(note.getIdentifyingElement());
                this.myNoteEdges.remove(note);
            }
        }
    }

    @Override
    @NotNull
    public abstract Collection<? extends DiagramEdge<T>> getEdges();

    @Nullable
    public DiagramEdge<T> createEdge(@NotNull DiagramNode<T> from, @NotNull DiagramNode<T> to) {
        if (from == null) {
            DiagramDataModel.$$$reportNull$$$0(19);
        }
        if (to == null) {
            DiagramDataModel.$$$reportNull$$$0(20);
        }
        return null;
    }

    public void removeEdge(@NotNull DiagramEdge<T> edge) {
        if (edge == null) {
            DiagramDataModel.$$$reportNull$$$0(21);
        }
    }

    @NotNull
    public DiagramNode<T> getSourceNode(@NotNull DiagramEdge<T> e) {
        if (e == null) {
            DiagramDataModel.$$$reportNull$$$0(22);
        }
        DiagramNode<T> diagramNode = e.getSource();
        if (diagramNode == null) {
            DiagramDataModel.$$$reportNull$$$0(23);
        }
        return diagramNode;
    }

    @NotNull
    public DiagramNode<T> getTargetNode(@NotNull DiagramEdge<T> e) {
        if (e == null) {
            DiagramDataModel.$$$reportNull$$$0(24);
        }
        DiagramNode<T> diagramNode = e.getTarget();
        if (diagramNode == null) {
            DiagramDataModel.$$$reportNull$$$0(25);
        }
        return diagramNode;
    }

    public abstract void refreshDataModel();

    public void rebuild(T element) {
        this.removeAll();
    }

    public final void removeAll() {
        for (DiagramNoteNode diagramNoteNode : new ArrayList<DiagramNoteNode>(this.getNotes().values())) {
            this.removeNote(diagramNoteNode);
        }
        for (DiagramNode<DiagramNode> diagramNode : new ArrayList<DiagramNode<T>>(this.getNodes())) {
            this.removeNode(diagramNode);
        }
    }

    public boolean hasFile(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        return this.getNodes().stream().map(it -> it.getIdentifyingElement()).anyMatch(it -> it instanceof PsiElement && ((PsiElement)it).isValid() && DiagramDataModel.containsRegardlessInjection(this.getProject(), file, (PsiElement)it));
    }

    private static boolean containsRegardlessInjection(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement element) {
        if (project == null) {
            DiagramDataModel.$$$reportNull$$$0(26);
        }
        if (file == null) {
            DiagramDataModel.$$$reportNull$$$0(27);
        }
        if (element == null) {
            DiagramDataModel.$$$reportNull$$$0(28);
        }
        if (element.getContainingFile() == file) {
            return true;
        }
        PsiLanguageInjectionHost host1 = InjectedLanguageManager.getInstance((Project)project).getInjectionHost(element);
        PsiLanguageInjectionHost host2 = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)file);
        if (host1 == null && host2 == null) {
            return false;
        }
        if (host1 != null && host2 != null) {
            return host1.getContainingFile() == host2.getContainingFile();
        }
        return host1 == null ? element.getContainingFile() == host2.getContainingFile() : host1.getContainingFile() == file;
    }

    public final void setupScopeManager(@Nullable Object element, boolean showNotification) {
        DiagramScopeManager<T> scopeManager = this.getScopeManager();
        if (scopeManager != null && element instanceof PsiElement) {
            PackageSet value;
            PsiFile psiFile = ((PsiElement)element).getContainingFile();
            NamedScope currentScope = scopeManager.getCurrentScope();
            if (!(currentScope == null || (value = currentScope.getValue()) == null || psiFile != null && value.contains(psiFile, (NamedScopesHolder)NamedScopeManager.getInstance((Project)this.getProject())))) {
                scopeManager.setCurrentScope(CustomScopesProviderEx.getAllScope());
                if (showNotification) {
                    SwingUtilities.invokeLater(() -> DiagramAction.showNotification(DiagramBundle.message("notification.message.scope.has.been.changed.to.b.all.b", new Object[0]), this.getBuilder()));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramDataModel";
                break;
            }
            case 9: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramDataModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initNodeContentManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeContentManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoteEdges";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initNodeContentManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 23: 
            case 25: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collapseNode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "expandNode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addNote";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeNote";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeEdge";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSourceNode";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTargetNode";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "containsRegardlessInjection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AsyncDataLoader {
        @NotNull
        public Promise<?> refreshDataModelAsync();
    }
}

