/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScalableIconWrapper
implements ScalableIcon {
    @NotNull
    private final ScalableIcon myIcon;
    @NotNull
    private static final Map<String, ScalableIcon> OUR_SCALED_ICONS_CACHE = CollectionFactory.createWeakMap();

    ScalableIconWrapper(@NotNull ScalableIcon icon) {
        if (icon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(0);
        }
        this.myIcon = (ScalableIcon)icon.scale(1.0f);
    }

    public float getScale() {
        return this.myIcon.getScale();
    }

    @NotNull
    public Icon scale(float scaleFactor) {
        return new ScalableIconWrapper((ScalableIcon)this.myIcon.scale(scaleFactor));
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform currTransform = g2.getTransform();
        double zoom = currTransform.getScaleX();
        double rZoom = 1.0 / zoom;
        g2.scale(rZoom, rZoom);
        ScalableIconWrapper.getOrScaleImage(this.myIcon, (float)zoom).paintIcon(c, g2, (int)((double)x * zoom), (int)((double)y * zoom));
        g2.setTransform(currTransform);
    }

    @NotNull
    private static String getKeyForCacheMap(@NotNull Icon icon) {
        if (icon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(1);
        }
        String string = icon.toString();
        if (string == null) {
            ScalableIconWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static Icon getOrScaleImage(@NotNull ScalableIcon icon, float scale) {
        String key;
        ScalableIcon cached;
        if (icon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(3);
        }
        if ((cached = OUR_SCALED_ICONS_CACHE.get(key = ScalableIconWrapper.getKeyForCacheMap((Icon)icon))) != null && (double)Math.abs(cached.getScale() - scale) < 0.01) {
            ScalableIcon scalableIcon = cached;
            if (scalableIcon == null) {
                ScalableIconWrapper.$$$reportNull$$$0(4);
            }
            return scalableIcon;
        }
        Icon scaled = icon.scale(scale);
        if (scaled instanceof ScalableIcon) {
            OUR_SCALED_ICONS_CACHE.put(key, (ScalableIcon)scaled);
        }
        Icon icon2 = scaled;
        if (icon2 == null) {
            ScalableIconWrapper.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    public int getIconWidth() {
        return this.myIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this.myIcon.getIconHeight();
    }

    @Nullable
    public static ScalableIcon evaluateDeferredAndWrap(@NotNull Icon deferredIcon) {
        Icon evaluated;
        Icon scaled;
        if (deferredIcon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(6);
        }
        return (scaled = ScalableIconWrapper.deepScaleTo(evaluated = ScalableIconWrapper.evaluateDeferred(deferredIcon), 1.0f)) instanceof ScalableIcon ? new ScalableIconWrapper((ScalableIcon)scaled) : null;
    }

    @NotNull
    public static Icon evaluateDeferred(@NotNull Icon icon) {
        if (icon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(7);
        }
        if (icon instanceof DeferredIcon) {
            return ScalableIconWrapper.evaluateDeferred(((DeferredIcon)icon).evaluate());
        }
        if (icon instanceof CompositeIcon) {
            return ScalableIconWrapper.mapCompositeIcon((CompositeIcon)icon, it -> ScalableIconWrapper.evaluateDeferred(it));
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            ScalableIconWrapper.$$$reportNull$$$0(8);
        }
        return icon2;
    }

    @NotNull
    public static Icon deepScaleTo(@NotNull Icon icon, float scale) {
        if (icon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(9);
        }
        if (icon instanceof ScalableIcon) {
            Icon icon2 = ((ScalableIcon)icon).scale(scale);
            if (icon2 == null) {
                ScalableIconWrapper.$$$reportNull$$$0(10);
            }
            return icon2;
        }
        if (icon instanceof CompositeIcon) {
            return ScalableIconWrapper.mapCompositeIcon((CompositeIcon)icon, it -> ScalableIconWrapper.deepScaleTo(it, scale));
        }
        Icon icon3 = icon;
        if (icon3 == null) {
            ScalableIconWrapper.$$$reportNull$$$0(11);
        }
        return icon3;
    }

    @NotNull
    private static Icon mapCompositeIcon(@NotNull CompositeIcon icon, @NotNull Function<Icon, Icon> mapper) {
        if (icon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(12);
        }
        if (mapper == null) {
            ScalableIconWrapper.$$$reportNull$$$0(13);
        }
        if (icon instanceof RowIcon) {
            return new com.intellij.ui.RowIcon((Icon[])ContainerUtil.map2Array((Object[])((RowIcon)icon).getAllIcons(), Icon.class, it -> (Icon)mapper.apply((Icon)it)));
        }
        if (icon instanceof LayeredIcon) {
            LayeredIcon layeredIcon = (LayeredIcon)icon;
            Icon[] normalized = (Icon[])IntStream.range(0, layeredIcon.getIconCount()).mapToObj(it -> layeredIcon.getIcon(it)).filter(it -> it != null).map(mapper).toArray(Icon[]::new);
            return new LayeredIcon(normalized);
        }
        CompositeIcon compositeIcon = icon;
        if (compositeIcon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(14);
        }
        return compositeIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/ScalableIconWrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deferredIcon";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/ScalableIconWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyForCacheMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScaleImage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateDeferred";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deepScaleTo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "mapCompositeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForCacheMap";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrScaleImage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDeferredAndWrap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDeferred";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deepScaleTo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mapCompositeIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

