/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import com.intellij.uml.utils.DiagramBundle;
import org.jetbrains.annotations.NotNull;

public class UmlCategorySwitcher
extends DiagramAction
implements Toggleable {
    @NotNull
    private final DiagramCategory myCategory;
    @NotNull
    private final DiagramBuilder myBuilder;

    public UmlCategorySwitcher(@NotNull DiagramCategory category, @NotNull DiagramBuilder builder) {
        if (category == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(1);
        }
        super(category.getName(), "", category.getIcon());
        this.myCategory = category;
        this.myBuilder = builder;
    }

    @Override
    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(2);
        }
        DiagramNodeEditorManager.getInstance().stopEditing(this.myBuilder);
        boolean enabled = !this.isSelected();
        DiagramNodeContentManager nodeContentManager = this.myBuilder.getDataModel().getNodeContentManager();
        nodeContentManager.setCategoryEnabled(this.myCategory, enabled);
        nodeContentManager.onCategoryEnabled(this.myCategory, enabled);
        if (this.myCategory.isRefreshDataModel()) {
            this.myBuilder.getDataModel().refreshDataModel();
        }
        this.myBuilder.update(true, Registry.is((String)"diagrams.relayout.on.category.change") && (this.myBuilder.isPopupMode() || this.myCategory.isRefreshLayout()));
        if (this.myCategory.isFitContent()) {
            this.myBuilder.getGraph().fitGraph2DView();
        }
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = this.isSelected() ? DiagramBundle.message("action.name.disable.category", this.myCategory.getName()) : DiagramBundle.message("action.name.enable.category", this.myCategory.getName());
        if (string == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(3);
        }
        return string;
    }

    private boolean isSelected() {
        return this.myBuilder.getDataModel().getNodeContentManager().isCategoryEnabled(this.myCategory);
    }

    @Override
    public boolean isSelected(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(4);
        }
        return this.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/UmlCategorySwitcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/UmlCategorySwitcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

