/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.utils;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.uml.java.utils.UmlKotlinUtils;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlJavaUtils {
    @Nullable
    public static String getPackageName(PsiElement element) {
        if (element instanceof PsiClass) {
            return (String)ReadAction.compute(() -> ((PsiClassOwner)element.getContainingFile()).getPackageName());
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static String getRealPackageName(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            PsiClass aClass = (PsiClass)psiElement;
            while (aClass.getContainingClass() != null) {
                PsiClass c = aClass.getContainingClass();
                if (c == null) {
                    return UmlJavaUtils.getPackageName((PsiElement)c);
                }
                aClass = c;
            }
            return UmlJavaUtils.getPackageName((PsiElement)aClass);
        }
        return UmlJavaUtils.getPackageName(psiElement);
    }

    @Nullable
    public static PsiPackage getPackage(PsiElement element) {
        String fqn = UmlJavaUtils.getRealPackageName(element);
        return fqn == null ? null : JavaPsiFacade.getInstance((Project)element.getProject()).findPackage(fqn);
    }

    public static PackageInfo getInfo(PsiPackage p) {
        return new PackageInfo(p);
    }

    public static boolean prepareClassForWrite(PsiClass psiClass) {
        boolean prepared = CodeInsightUtil.preparePsiElementsForWrite((PsiElement[])new PsiElement[]{psiClass});
        if (!prepared) {
            Messages.showErrorDialog((Project)psiClass.getProject(), (String)DiagramBundle.message("class.is.readonly", psiClass.getName()), (String)DiagramBundle.message("error", new Object[0]));
        }
        return prepared;
    }

    @Nullable
    public static String getFQN(@NotNull PsiElement element) {
        if (element == null) {
            UmlJavaUtils.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/uml/java/utils/UmlJavaUtils", "getFQN"));
    }

    public static final class PackageInfo {
        private int myTotalClassesCount;
        private int myTotalSubpackagesCount;
        private final int myClassesCount;
        private final int mySubpackagesCount;
        @NotNull
        private final String myFqn;

        private PackageInfo(@NotNull PsiPackage p) {
            if (p == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            this.myTotalClassesCount = 0;
            this.myTotalSubpackagesCount = 0;
            this.myFqn = p.getQualifiedName();
            this.myClassesCount = PackageInfo.distinct(PackageInfo.filterKotlinTopLevelClasses(p.getClasses())).length;
            this.mySubpackagesCount = PackageInfo.distinct(p.getSubPackages()).length;
            this.traverse(p);
        }

        private static PsiClass @NotNull [] filterKotlinTopLevelClasses(PsiClass @NotNull [] classes) {
            if (classes == null) {
                PackageInfo.$$$reportNull$$$0(1);
            }
            PsiClass[] psiClassArray = (PsiClass[])Arrays.stream(classes).filter(it -> !UmlKotlinUtils.TopLevel.isImplicitClassForTopLevelDeclarations(it) || !PackageInfo.isEmpty(it)).toArray(PsiClass[]::new);
            if (psiClassArray == null) {
                PackageInfo.$$$reportNull$$$0(2);
            }
            return psiClassArray;
        }

        private static boolean isEmpty(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                PackageInfo.$$$reportNull$$$0(3);
            }
            return ArrayUtil.isEmpty((Object[])psiClass.getFields()) && ArrayUtil.isEmpty((Object[])psiClass.getMethods());
        }

        private static <T> T @NotNull [] distinct(T @NotNull [] elements) {
            if (elements == null) {
                PackageInfo.$$$reportNull$$$0(4);
            }
            Set set = ConcurrentCollectionFactory.createConcurrentIdentitySet();
            ContainerUtil.addAll((Collection)set, (Object[])elements);
            T[] TArray = set.toArray(Arrays.copyOf(elements, 0));
            if (TArray == null) {
                PackageInfo.$$$reportNull$$$0(5);
            }
            return TArray;
        }

        private void traverse(@NotNull PsiPackage p) {
            if (p == null) {
                PackageInfo.$$$reportNull$$$0(6);
            }
            this.myTotalClassesCount += PackageInfo.distinct(PackageInfo.filterKotlinTopLevelClasses(p.getClasses())).length;
            this.myTotalSubpackagesCount += PackageInfo.distinct(p.getSubPackages()).length;
            for (PsiPackage aPackage : PackageInfo.distinct(p.getSubPackages())) {
                this.traverse(aPackage);
            }
        }

        @NotNull
        @Nls
        public String toString() {
            String string = DiagramJavaBundle.message("package.info.message", this.myFqn, this.myClassesCount, this.myClassesCount, this.mySubpackagesCount, this.mySubpackagesCount, this.myTotalClassesCount, this.myTotalClassesCount, this.myTotalSubpackagesCount, this.myTotalSubpackagesCount);
            if (string == null) {
                PackageInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classes";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/utils/UmlJavaUtils$PackageInfo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/utils/UmlJavaUtils$PackageInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterKotlinTopLevelClasses";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "distinct";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filterKotlinTopLevelClasses";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEmpty";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "distinct";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "traverse";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

