/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GraphBuilder<N, E>
extends UserDataHolderBase
implements UserDataHolder,
Disposable {
    public static final double MIN_ZOOM = 0.1;
    public static final double MAX_ZOOM = 20.0;

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract Graph2D getGraph();

    @NotNull
    public abstract Graph2DView getView();

    @Nullable
    public Overview getOverview() {
        return null;
    }

    @NotNull
    public abstract GraphDataModel<N, E> getGraphDataModel();

    @NotNull
    public abstract GraphPresentationModel<N, E> getGraphPresentationModel();

    @NotNull
    public HierarchyManager getHierarchyManager() {
        HierarchyManager hierarchyManager = this.getGraph().getHierarchyManager();
        if (hierarchyManager == null) {
            GraphBuilder.$$$reportNull$$$0(0);
        }
        return hierarchyManager;
    }

    public abstract double getZoom();

    public abstract void setZoom(double var1);

    public abstract void setZoom(double var1, boolean var3);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public void fitContent() {
        this.fitContent(false);
    }

    public abstract void fitContent(boolean var1);

    public abstract void updateGraph(boolean var1);

    public void updateGraph() {
        this.updateGraph(true);
    }

    public abstract void updateDataModel();

    public abstract void updateView(boolean var1);

    public void updateView() {
        this.updateView(false);
    }

    public abstract void updateRealizers(boolean var1);

    public abstract void queueUpdate();

    public abstract void initialize();

    @Nullable
    public abstract String getNodeName(@Nullable N var1);

    @Nullable
    public abstract String getEdgeName(@Nullable E var1);

    @Nullable
    public abstract Node getNode(@Nullable N var1);

    @Nullable
    public abstract Edge getEdge(@Nullable E var1);

    @Nullable
    public abstract N getNodeObject(@Nullable Node var1);

    @Nullable
    public abstract E getEdgeObject(@Nullable Edge var1);

    public abstract void addCustomUpdater(@NotNull CustomGraphUpdater var1);

    @NotNull
    public abstract EditMode getEditMode();

    @NotNull
    public ViewMode getActiveMode() {
        EditMode editMode = this.getEditMode();
        if (editMode == null) {
            GraphBuilder.$$$reportNull$$$0(1);
        }
        return editMode;
    }

    public void setActiveMode(@NotNull ViewMode activeMode) {
        if (activeMode == null) {
            GraphBuilder.$$$reportNull$$$0(2);
        }
        throw new IllegalStateException("Not Implemented");
    }

    public abstract boolean isCellEditing();

    @NotNull
    public abstract Collection<N> getNodeObjects();

    @NotNull
    public abstract Collection<E> getEdgeObjects();

    public abstract boolean removeNode(@Nullable N var1);

    public abstract boolean removeEdge(@Nullable E var1);

    public abstract void addGraphBuilderListener(@NotNull GraphBuilderListener var1, @NotNull Disposable var2);

    public abstract void removeGraphBuilderListener(@NotNull GraphBuilderListener var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/GraphBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveMode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/GraphBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setActiveMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

