/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.builder.components.BaseGraphStructureViewBuilder;
import com.intellij.openapi.graph.builder.renderer.BasicNodeCellRenderer;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractColoredNodeCellRenderer
extends BasicNodeCellRenderer {
    public static final String GRAPH_NODE_SELECTED = "GRAPH_NODE_SELECTED";

    protected AbstractColoredNodeCellRenderer(ModificationTracker modificationTracker) {
        super(modificationTracker);
    }

    @Override
    protected JComponent getRendererComponent(Graph2DView view, NodeRealizer realizer, Object object, boolean isSelected) {
        CellRendererPanel panel = new CellRendererPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.setBorder(this.getBorder(realizer, object, isSelected));
        panel.setFocusable(false);
        panel.setOpaque(true);
        GraphViewUtil.copyClientProperty(view.getCanvasComponent(), (JComponent)panel, BaseGraphStructureViewBuilder.LOCAL_VIEW_KEY);
        panel.putClientProperty((Object)GRAPH_NODE_SELECTED, (Object)isSelected);
        this.tuneNode(realizer, (JPanel)panel);
        return panel;
    }

    public abstract void tuneNode(NodeRealizer var1, JPanel var2);

    protected int getSelectionBorderWidth() {
        return 1;
    }

    @NotNull
    protected Border getBorder(NodeRealizer realizer, Object object, boolean isSelected) {
        Color borderColor = this.getBorderColor(realizer, object, isSelected);
        if (GraphExportService.getInstance().isPrintMode()) {
            return new LineBorder(borderColor, 2);
        }
        return isSelected ? new LineBorder(borderColor, this.getSelectionBorderWidth(), true) : new LineBorder(borderColor);
    }

    @NotNull
    protected Color getBorderColor(NodeRealizer realizer, Object object, boolean isSelected) {
        if (isSelected) {
            return new JBColor((Color)JBColor.ORANGE, (Color)JBColor.blue);
        }
        if (GraphExportService.getInstance().isPrintMode()) {
            Gray gray = Gray._168;
            if (gray == null) {
                AbstractColoredNodeCellRenderer.$$$reportNull$$$0(0);
            }
            return gray;
        }
        if (StartupUiUtil.isUnderDarcula()) {
            Gray gray = Gray._120;
            if (gray == null) {
                AbstractColoredNodeCellRenderer.$$$reportNull$$$0(1);
            }
            return gray;
        }
        JBColor jBColor = JBColor.LIGHT_GRAY;
        if (jBColor == null) {
            AbstractColoredNodeCellRenderer.$$$reportNull$$$0(2);
        }
        return jBColor;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @NotNull
    protected Color getSelectionColor() {
        return new JBColor((Color)JBColor.ORANGE, (Color)JBColor.blue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/renderer/AbstractColoredNodeCellRenderer", "getBorderColor"));
    }
}

