/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.Graph2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphSelectionService {
    @NotNull
    private static final GraphSelectionService INSTANCE = new GraphSelectionService();
    @GuardedBy(value="this")
    @NotNull
    private final Map<GraphBuilder<?, ?>, List<Consumer<Rectangle>>> myOneTimeSelectionCallbacks = new HashMap();
    @NotNull
    private final Set<GraphBuilder<?, ?>> myGraphBuilderWithSuppressedSelection = Collections.synchronizedSet(new HashSet());

    @NotNull
    public static GraphSelectionService getInstance() {
        GraphSelectionService graphSelectionService = INSTANCE;
        if (graphSelectionService == null) {
            GraphSelectionService.$$$reportNull$$$0(0);
        }
        return graphSelectionService;
    }

    public void forEachSelectedNode(@NotNull Graph2D graph, @NotNull Consumer<Node> consumer) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            GraphSelectionService.$$$reportNull$$$0(2);
        }
        NodeCursor cursor = graph.selectedNodes();
        while (cursor.ok()) {
            consumer.accept(cursor.node());
            cursor.next();
        }
    }

    @NotNull
    public List<Node> getSelectedNodes(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(3);
        }
        ArrayList<Node> result = new ArrayList<Node>();
        NodeCursor cursor = graph.selectedNodes();
        while (cursor.ok()) {
            result.add(cursor.node());
            cursor.next();
        }
        ArrayList<Node> arrayList = result;
        if (arrayList == null) {
            GraphSelectionService.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public <N> List<N> getSelectedModelNodes(@NotNull GraphBuilder<N, ?> builder) {
        if (builder == null) {
            GraphSelectionService.$$$reportNull$$$0(5);
        }
        ArrayList<N> result = new ArrayList<N>();
        NodeCursor cursor = builder.getGraph().selectedNodes();
        while (cursor.ok()) {
            N modelNode = builder.getNodeObject(cursor.node());
            if (modelNode != null) {
                result.add(modelNode);
            }
            cursor.next();
        }
        ArrayList<N> arrayList = result;
        if (arrayList == null) {
            GraphSelectionService.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public Node getSingleSelectedNode(@NotNull Graph2D graph) {
        NodeCursor cursor;
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(7);
        }
        if ((cursor = graph.selectedNodes()).ok()) {
            Node node = cursor.node();
            cursor.next();
            if (!cursor.ok()) {
                return node;
            }
        }
        return null;
    }

    @Nullable
    public <N> N getSingleSelectedModelNode(@NotNull GraphBuilder<N, ?> builder) {
        if (builder == null) {
            GraphSelectionService.$$$reportNull$$$0(8);
        }
        return builder.getNodeObject(this.getSingleSelectedNode(builder.getGraph()));
    }

    public void selectAllNodes(@NotNull Graph2D graph, @NotNull Collection<Node> nodes, boolean state) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(9);
        }
        if (nodes == null) {
            GraphSelectionService.$$$reportNull$$$0(10);
        }
        for (Node node : nodes) {
            graph.setSelected(node, state);
        }
    }

    public <N> void selectAllModelNodes(@NotNull GraphBuilder<N, ?> builder, @NotNull Collection<N> nodes, boolean state) {
        if (builder == null) {
            GraphSelectionService.$$$reportNull$$$0(11);
        }
        if (nodes == null) {
            GraphSelectionService.$$$reportNull$$$0(12);
        }
        Graph2D graph = builder.getGraph();
        for (N modelNode : nodes) {
            Node node = builder.getNode(modelNode);
            if (node == null) continue;
            graph.setSelected(node, state);
        }
    }

    public void forEachSelectedEdge(@NotNull Graph2D graph, @NotNull Consumer<Edge> consumer) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            GraphSelectionService.$$$reportNull$$$0(14);
        }
        EdgeCursor cursor = graph.selectedEdges();
        while (cursor.ok()) {
            consumer.accept(cursor.edge());
            cursor.next();
        }
    }

    @NotNull
    public List<Edge> getSelectedEdges(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(15);
        }
        ArrayList<Edge> result = new ArrayList<Edge>();
        EdgeCursor cursor = graph.selectedEdges();
        while (cursor.ok()) {
            result.add(cursor.edge());
            cursor.next();
        }
        ArrayList<Edge> arrayList = result;
        if (arrayList == null) {
            GraphSelectionService.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOneTimeSelectionCallback(@NotNull GraphBuilder<?, ?> builder, @NotNull Consumer<Rectangle> callback) {
        if (builder == null) {
            GraphSelectionService.$$$reportNull$$$0(17);
        }
        if (callback == null) {
            GraphSelectionService.$$$reportNull$$$0(18);
        }
        Map<GraphBuilder<?, ?>, List<Consumer<Rectangle>>> map = this.myOneTimeSelectionCallbacks;
        synchronized (map) {
            if (this.myOneTimeSelectionCallbacks.containsKey(builder)) {
                this.myOneTimeSelectionCallbacks.get(builder).add(callback);
            } else {
                ArrayList<Consumer<Rectangle>> bean = new ArrayList<Consumer<Rectangle>>();
                bean.add(callback);
                this.myOneTimeSelectionCallbacks.put(builder, bean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllOneTimeSelectionCallbacks(@NotNull GraphBuilder<?, ?> builder, @NotNull Consumer<Consumer<Rectangle>> processor) {
        if (builder == null) {
            GraphSelectionService.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            GraphSelectionService.$$$reportNull$$$0(20);
        }
        Map<GraphBuilder<?, ?>, List<Consumer<Rectangle>>> map = this.myOneTimeSelectionCallbacks;
        synchronized (map) {
            List<Consumer<Rectangle>> bean = this.myOneTimeSelectionCallbacks.get(builder);
            if (bean != null) {
                for (Consumer<Rectangle> callback : bean) {
                    processor.accept(callback);
                }
                bean.clear();
            }
        }
    }

    public void suppressSelection(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphSelectionService.$$$reportNull$$$0(21);
        }
        this.myGraphBuilderWithSuppressedSelection.add(builder);
    }

    public void enableSelection(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphSelectionService.$$$reportNull$$$0(22);
        }
        this.myGraphBuilderWithSuppressedSelection.remove(builder);
    }

    public boolean isSelectionSuppressedFor(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphSelectionService.$$$reportNull$$$0(23);
        }
        return this.myGraphBuilderWithSuppressedSelection.contains(builder);
    }

    public void onGraphBuilderDispose(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphSelectionService.$$$reportNull$$$0(24);
        }
        this.myGraphBuilderWithSuppressedSelection.remove(builder);
        this.myOneTimeSelectionCallbacks.remove(builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphSelectionService";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphSelectionService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModelNodes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEdges";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forEachSelectedNode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedModelNodes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedModelNode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectAllNodes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectAllModelNodes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "forEachSelectedEdge";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEdges";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerOneTimeSelectionCallback";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processAllOneTimeSelectionCallbacks";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "suppressSelection";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "enableSelection";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionSuppressedFor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onGraphBuilderDispose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

