/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.numeric;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.numeric.NumberConverter;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNumberConversionIntention
implements IntentionAction {
    @IntentionName
    private String myText;

    @Override
    @IntentionName
    @NotNull
    public String getText() {
        String string = this.myText == null ? LangBundle.message("intention.name.convert.number.to", new Object[0]) : this.myText;
        if (string == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message("intention.family.convert.number", new Object[0]);
        if (string == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        List<NumberConverter> converters;
        if (project == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(2);
        }
        if ((converters = this.getConverters(file)).isEmpty()) {
            return false;
        }
        NumberConversionContext context = this.getContext(file, editor);
        if (context == null) {
            return false;
        }
        Number number = context.myNumber;
        String text2 = context.myText;
        NumberConverter singleConverter = null;
        for (NumberConverter converter : converters) {
            String convertedText = converter.getConvertedText(text2, number);
            if (convertedText == null) continue;
            if (singleConverter != null) {
                this.myText = null;
                return true;
            }
            singleConverter = converter;
        }
        if (singleConverter == null) {
            return false;
        }
        String convertedText = singleConverter.getConvertedText(text2, number);
        this.myText = this.getActionName(singleConverter, convertedText);
        return true;
    }

    @Nullable
    private NumberConversionContext getContext(@NotNull PsiFile file, @NotNull Editor editor) {
        int offset;
        PsiElement element;
        NumberConversionContext context;
        if (file == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(4);
        }
        NumberConversionContext numberConversionContext = context = (element = file.findElementAt(offset = editor.getCaretModel().getOffset())) == null ? null : this.extract(element);
        if (context == null && offset > 0) {
            element = file.findElementAt(offset - 1);
            context = element == null ? null : this.extract(element);
        }
        return context;
    }

    @IntentionName
    public String getActionName(NumberConverter converter, String convertedText) {
        return LangBundle.message("intention.name.convert.number.to.with.text", converter, convertedText);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        class Conversion {
            final NumberConverter myConverter;
            final String myResult;

            Conversion(NumberConverter converter, String result) {
                this.myConverter = converter;
                this.myResult = result;
            }

            void convert(NumberConversionContext context) {
                WriteCommandAction.runWriteCommandAction(context.getProject(), this.getName(), null, () -> {
                    PsiElement element = context.getElement();
                    if (element != null) {
                        AbstractNumberConversionIntention.this.replace(element, this.myResult);
                    }
                }, file);
            }

            @NlsContexts.Command
            private String getName() {
                return AbstractNumberConversionIntention.this.getActionName(this.myConverter, this.myResult);
            }

            public String toString() {
                return StringUtil.capitalize((String)this.myConverter.toString()) + " (" + this.myResult + ")";
            }
        }
        List<NumberConverter> converters;
        if (project == null) {
            AbstractNumberConversionIntention.$$$reportNull$$$0(5);
        }
        if ((converters = this.getConverters(file)).isEmpty()) {
            return;
        }
        NumberConversionContext context = this.getContext(file, editor);
        if (context == null) {
            return;
        }
        Number number = context.myNumber;
        String text2 = context.myText;
        List list = this.getConverters(file).stream().map(converter -> new Conversion((NumberConverter)converter, converter.getConvertedText(text2, number))).filter(conversion -> conversion.myResult != null).collect(Collectors.toList());
        if (this.myText != null) {
            list.stream().filter(c -> c.getName().equals(this.myText)).findFirst().ifPresent(conversion -> conversion.convert(context));
            return;
        }
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(list).setSelectionMode(0).setAccessibleName(LangBundle.message("intention.name.convert.number.to", new Object[0])).setTitle(StringUtil.wordsToBeginFromUpperCase((String)LangBundle.message("intention.name.convert.number.to", new Object[0]))).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(conversion -> conversion.convert(context)).createPopup();
        popup.showInBestPositionFor(editor);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    @Contract(pure=true)
    protected abstract NumberConversionContext extract(@NotNull PsiElement var1);

    @NotNull
    @Contract(pure=true)
    protected abstract List<NumberConverter> getConverters(@NotNull PsiFile var1);

    protected abstract void replace(PsiElement var1, String var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/numeric/AbstractNumberConversionIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/numeric/AbstractNumberConversionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class NumberConversionContext {
        @NotNull
        final SmartPsiElementPointer<PsiElement> myElement;
        @NotNull
        final Number myNumber;
        @NotNull
        final String myText;
        final boolean myNegated;

        public NumberConversionContext(@NotNull PsiElement element, @NotNull Number number, @NotNull String text2, boolean negated) {
            if (element == null) {
                NumberConversionContext.$$$reportNull$$$0(0);
            }
            if (number == null) {
                NumberConversionContext.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                NumberConversionContext.$$$reportNull$$$0(2);
            }
            this.myElement = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
            this.myNumber = number;
            this.myText = text2;
            this.myNegated = negated;
        }

        @Nullable
        PsiElement getElement() {
            return this.myElement.getElement();
        }

        @NotNull
        public Project getProject() {
            Project project = this.myElement.getProject();
            if (project == null) {
                NumberConversionContext.$$$reportNull$$$0(3);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "number";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/numeric/AbstractNumberConversionIntention$NumberConversionContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/numeric/AbstractNumberConversionIntention$NumberConversionContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

