/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/configurations/ConfigurationTypeUtil;", "", "()V", "findConfigurationType", "T", "Lcom/intellij/execution/configurations/ConfigurationType;", "configurationTypeClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lcom/intellij/execution/configurations/ConfigurationType;", "configurationId", "", "isEditableInDumbMode", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runConfigurationType", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.platform.lang"})
public final class ConfigurationTypeUtil {
    @NotNull
    public static final ConfigurationTypeUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final <T extends ConfigurationType> T findConfigurationType(@NotNull Class<T> configurationTypeClass) {
        Intrinsics.checkNotNullParameter(configurationTypeClass, (String)"configurationTypeClass");
        ExtensionPointName<ConfigurationType> extensionPointName = ConfigurationType.CONFIGURATION_TYPE_EP;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"ConfigurationType.CONFIGURATION_TYPE_EP");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ConfigurationType.CONFIG\u2026ION_TYPE_EP.extensionList");
        List types = list;
        for (ConfigurationType type : types) {
            if (!configurationTypeClass.isInstance(type)) continue;
            ConfigurationType configurationType = type;
            if (configurationType == null) {
                throw new NullPointerException("null cannot be cast to non-null type T");
            }
            return (T)configurationType;
        }
        throw (Throwable)((Object)new AssertionError((Object)(types + " loader: " + configurationTypeClass.getClassLoader() + ", " + configurationTypeClass)));
    }

    @JvmStatic
    @Nullable
    public static final ConfigurationType findConfigurationType(@NotNull String configurationId) {
        Object v3;
        block1: {
            Intrinsics.checkNotNullParameter((Object)configurationId, (String)"configurationId");
            ExtensionPointName<ConfigurationType> extensionPointName = ConfigurationType.CONFIGURATION_TYPE_EP;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"ConfigurationType.CONFIGURATION_TYPE_EP");
            List list = extensionPointName.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ConfigurationType.CONFIG\u2026ION_TYPE_EP.extensionList");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ConfigurationType it = (ConfigurationType)element$iv;
                boolean bl = false;
                ConfigurationType configurationType = it;
                Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"it");
                if (!Intrinsics.areEqual((Object)configurationType.getId(), (Object)configurationId)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        return v3;
    }

    @JvmStatic
    public static final boolean isEditableInDumbMode(@NotNull ConfigurationType runConfigurationType) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)runConfigurationType, (String)"runConfigurationType");
            ConfigurationFactory[] configurationFactoryArray = runConfigurationType.getConfigurationFactories();
            Intrinsics.checkNotNullExpressionValue((Object)configurationFactoryArray, (String)"runConfigurationType.configurationFactories");
            ConfigurationFactory[] $this$any$iv = configurationFactoryArray;
            boolean $i$f$any = false;
            ConfigurationFactory[] configurationFactoryArray2 = $this$any$iv;
            int n = configurationFactoryArray2.length;
            for (int i = 0; i < n; ++i) {
                ConfigurationFactory element$iv;
                ConfigurationFactory it = element$iv = configurationFactoryArray2[i];
                boolean bl2 = false;
                ConfigurationFactory configurationFactory = it;
                Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"it");
                if (!configurationFactory.isEditableInDumbMode()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isEditableInDumbMode(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        ConfigurationFactory configurationFactory = runConfiguration.getFactory();
        return configurationFactory != null ? configurationFactory.isEditableInDumbMode() : false;
    }

    @JvmStatic
    public static final boolean isEditableInDumbMode(@NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        ConfigurationFactory configurationFactory = settings.getFactory();
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"settings.factory");
        return configurationFactory.isEditableInDumbMode();
    }

    private ConfigurationTypeUtil() {
    }

    static {
        ConfigurationTypeUtil configurationTypeUtil;
        INSTANCE = configurationTypeUtil = new ConfigurationTypeUtil();
    }
}

