/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.ContributedConfigurationBase;
import com.intellij.execution.target.ContributedConfigurationsList;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RemoteTargetsManager", storages={@Storage(value="remote-targets.xml")})
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/execution/target/TargetEnvironmentsManager$TargetsListState;", "()V", "targets", "Lcom/intellij/execution/target/ContributedConfigurationsList;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "Lcom/intellij/execution/target/TargetEnvironmentType;", "getTargets", "()Lcom/intellij/execution/target/ContributedConfigurationsList;", "addTarget", "", "target", "ensureUniqueName", "getState", "loadState", "state", "removeTarget", "Companion", "OneTargetState", "TargetsList", "TargetsListState", "intellij.platform.lang"})
public final class TargetEnvironmentsManager
implements PersistentStateComponent<TargetsListState> {
    @NotNull
    private final ContributedConfigurationsList<TargetEnvironmentConfiguration, TargetEnvironmentType<?>> targets = new TargetsList();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ContributedConfigurationsList<TargetEnvironmentConfiguration, TargetEnvironmentType<?>> getTargets() {
        return this.targets;
    }

    @Override
    @NotNull
    public TargetsListState getState() {
        TargetsListState result = new TargetsListState();
        Iterator<ContributedConfigurationsList.ContributedStateBase> iterator = this.targets.getState().getConfigs().iterator();
        while (iterator.hasNext()) {
            ContributedConfigurationsList.ContributedStateBase next;
            ContributedConfigurationsList.ContributedStateBase contributedStateBase = next = iterator.next();
            if (contributedStateBase == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.target.TargetEnvironmentsManager.OneTargetState");
            }
            result.getTargets().add((OneTargetState)contributedStateBase);
        }
        return result;
    }

    @Override
    public void loadState(@NotNull TargetsListState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.targets.loadState(state.getTargets());
    }

    public final void addTarget(@NotNull TargetEnvironmentConfiguration target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.targets.resolvedConfigs().contains(target)) {
            this.ensureUniqueName(target);
            this.targets.addConfig((TargetEnvironmentConfiguration)((ContributedConfigurationBase)target));
        }
    }

    public final void removeTarget(@NotNull TargetEnvironmentConfiguration target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.targets.removeConfig((TargetEnvironmentConfiguration)((ContributedConfigurationBase)target));
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureUniqueName(@NotNull TargetEnvironmentConfiguration target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.targets.resolvedConfigs().contains(target)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.targets.resolvedConfigs();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getDisplayName();
                collection.add(string);
            }
            Set existingNames = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (Iterable)this.targets.unresolvedNames());
            String string = UniqueNameGenerator.generateUniqueName((String)target.getDisplayName(), (Collection)existingNames);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UniqueNameGenerator.gene\u2026splayName, existingNames)");
            String uniqueName = string;
            target.setDisplayName(uniqueName);
        }
    }

    @JvmStatic
    @NotNull
    public static final TargetEnvironmentsManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsManager$TargetsList;", "Lcom/intellij/execution/target/ContributedConfigurationsList;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "Lcom/intellij/execution/target/TargetEnvironmentType;", "()V", "fromOneState", "state", "Lcom/intellij/execution/target/ContributedConfigurationsList$ContributedStateBase;", "toBaseState", "Lcom/intellij/execution/target/TargetEnvironmentsManager$OneTargetState;", "config", "intellij.platform.lang"})
    public static final class TargetsList
    extends ContributedConfigurationsList<TargetEnvironmentConfiguration, TargetEnvironmentType<?>> {
        @NotNull
        protected OneTargetState toBaseState(@NotNull TargetEnvironmentConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            OneTargetState oneTargetState = new OneTargetState();
            boolean bl = false;
            boolean bl2 = false;
            OneTargetState it = oneTargetState;
            boolean bl3 = false;
            it.loadFromConfiguration(config);
            it.setRuntimes(config.getRuntimes().getState().getConfigs());
            return oneTargetState;
        }

        @Override
        @Nullable
        protected TargetEnvironmentConfiguration fromOneState(@NotNull ContributedConfigurationsList.ContributedStateBase state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            TargetEnvironmentConfiguration result = (TargetEnvironmentConfiguration)super.fromOneState(state);
            if (result != null && state instanceof OneTargetState) {
                result.getRuntimes().loadState(((OneTargetState)state).getRuntimes());
            }
            return result;
        }

        public TargetsList() {
            super(TargetEnvironmentType.EXTENSION_NAME);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R7\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsManager$TargetsListState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "Lcom/intellij/execution/target/TargetEnvironmentsManager$OneTargetState;", "targets", "getTargets", "()Ljava/util/List;", "setTargets", "(Ljava/util/List;)V", "targets$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.platform.lang"})
    public static final class TargetsListState
    extends BaseState {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty targets$delegate = this.list().provideDelegate((Object)this, $$delegatedProperties[0]);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(TargetsListState.class, "targets", "getTargets()Ljava/util/List;", 0))};
        }

        @XCollection(style=XCollection.Style.v2)
        @NotNull
        public final List<OneTargetState> getTargets() {
            return (List)this.targets$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setTargets(@NotNull List<OneTargetState> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.targets$delegate.setValue((Object)this, $$delegatedProperties[0], list);
        }
    }

    @Tag(value="target")
    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R7\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsManager$OneTargetState;", "Lcom/intellij/execution/target/ContributedConfigurationsList$ContributedStateBase;", "()V", "<set-?>", "", "runtimes", "getRuntimes", "()Ljava/util/List;", "setRuntimes", "(Ljava/util/List;)V", "runtimes$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.platform.lang"})
    public static final class OneTargetState
    extends ContributedConfigurationsList.ContributedStateBase {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty runtimes$delegate = this.list().provideDelegate((Object)this, $$delegatedProperties[0]);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(OneTargetState.class, "runtimes", "getRuntimes()Ljava/util/List;", 0))};
        }

        @XCollection(style=XCollection.Style.v2)
        @Property(surroundWithTag=false)
        @NotNull
        public final List<ContributedConfigurationsList.ContributedStateBase> getRuntimes() {
            return (List)this.runtimes$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setRuntimes(@NotNull List<ContributedConfigurationsList.ContributedStateBase> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.runtimes$delegate.setValue((Object)this, $$delegatedProperties[0], list);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/execution/target/TargetEnvironmentsManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final TargetEnvironmentsManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(TargetEnvironmentsManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Targe\u2026mentsManager::class.java)");
            return (TargetEnvironmentsManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

