/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface LogEventDetector {
    @NotNull
    public String featureId();

    @NotNull
    public String groupId();

    @NotNull
    public String eventId();

    public boolean succeed(@NotNull Map<String, Object> var1);

    public static LogEventDetector create(Type type, @NotNull String featureId, @NotNull String eventDataId) {
        if (featureId == null) {
            LogEventDetector.$$$reportNull$$$0(0);
        }
        if (eventDataId == null) {
            LogEventDetector.$$$reportNull$$$0(1);
        }
        switch (type) {
            case ACTION: {
                return new Actions(featureId, eventDataId);
            }
            case INTENTION: {
                return new Intentions(featureId, eventDataId);
            }
        }
        throw new IllegalArgumentException("Unknown Log event type: " + type.name());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "featureId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "eventDataId";
                break;
            }
        }
        objectArray[1] = "com/intellij/featureStatistics/LogEventDetector";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Type {
        ACTION,
        INTENTION;

    }

    public static class Intentions
    implements LogEventDetector {
        private static final String ID_KEY = "id";
        private final String myFeatureId;
        private final String myIntentionId;

        public Intentions(@NotNull String featureId, @NotNull String intentionId) {
            if (featureId == null) {
                Intentions.$$$reportNull$$$0(0);
            }
            if (intentionId == null) {
                Intentions.$$$reportNull$$$0(1);
            }
            this.myFeatureId = featureId;
            this.myIntentionId = intentionId;
        }

        @Override
        @NotNull
        public final String featureId() {
            String string = this.myFeatureId;
            if (string == null) {
                Intentions.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public final String groupId() {
            return "intentions";
        }

        @Override
        @NotNull
        public final String eventId() {
            return "called";
        }

        @Override
        public boolean succeed(@NotNull Map<String, Object> eventData) {
            if (eventData == null) {
                Intentions.$$$reportNull$$$0(3);
            }
            return eventData.get(ID_KEY).equals(this.myIntentionId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "featureId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intentionId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/featureStatistics/LogEventDetector$Intentions";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/featureStatistics/LogEventDetector$Intentions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "featureId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "succeed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Actions
    implements LogEventDetector {
        private static final String ID_KEY = "action_id";
        private final String myFeatureId;
        private final String myActionId;

        public Actions(@NotNull String featureId, @NotNull String actionId) {
            if (featureId == null) {
                Actions.$$$reportNull$$$0(0);
            }
            if (actionId == null) {
                Actions.$$$reportNull$$$0(1);
            }
            this.myFeatureId = featureId;
            this.myActionId = actionId;
        }

        @Override
        @NotNull
        public final String featureId() {
            String string = this.myFeatureId;
            if (string == null) {
                Actions.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public final String groupId() {
            return "actions";
        }

        @Override
        @NotNull
        public final String eventId() {
            return "action.finished";
        }

        @Override
        public boolean succeed(@NotNull Map<String, Object> eventData) {
            if (eventData == null) {
                Actions.$$$reportNull$$$0(3);
            }
            return eventData.get(ID_KEY).equals(this.myActionId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "featureId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/featureStatistics/LogEventDetector$Actions";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/featureStatistics/LogEventDetector$Actions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "featureId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "succeed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

