/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.List;

public class FileTypeDescriptor
extends FileChooserDescriptor {
    private final ImmutableList<String> myExtensions;

    public FileTypeDescriptor(@NlsContexts.DialogTitle String title, String ... extensions2) {
        if (extensions2 == null) {
            FileTypeDescriptor.$$$reportNull$$$0(0);
        }
        super(true, false, false, true, false, false);
        assert (extensions2.length > 0) : "There should be at least one extension";
        this.myExtensions = ContainerUtil.immutableList((List)ContainerUtil.map((Object[])extensions2, ext -> {
            if (ext.startsWith(".")) {
                return ext;
            }
            return "." + ext;
        }));
        this.setTitle(title);
    }

    @Override
    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        if (!showHiddenFiles && FileElement.isFileHidden(file)) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName();
        for (String extension : this.myExtensions) {
            if (!name.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFileSelectable(VirtualFile file) {
        return !file.isDirectory() && this.isFileVisible(file, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/openapi/fileChooser/FileTypeDescriptor", "<init>"));
    }
}

