/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.MockFileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public abstract class FileTypeManager
extends FileTypeRegistry {
    private static FileTypeManager ourInstance;
    @NotNull
    public static final Topic<FileTypeListener> TOPIC;

    public static FileTypeManager getInstance() {
        FileTypeManager instance = ourInstance;
        if (instance == null) {
            Application app = ApplicationManager.getApplication();
            instance = app != null ? (FileTypeManager)app.getService(FileTypeManager.class) : new MockFileTypeManager();
            ourInstance = instance;
        }
        return instance;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void registerFileType(@NotNull FileType var1, @NotNull List<? extends FileNameMatcher> var2);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public final void registerFileType(@NotNull FileType type, String ... defaultAssociatedExtensions) {
        if (type == null) {
            FileTypeManager.$$$reportNull$$$0(0);
        }
        ArrayList<ExtensionFileNameMatcher> matchers = new ArrayList<ExtensionFileNameMatcher>();
        if (defaultAssociatedExtensions != null) {
            for (String extension : defaultAssociatedExtensions) {
                matchers.add(new ExtensionFileNameMatcher(extension));
            }
        }
        this.registerFileType(type, matchers);
    }

    public abstract boolean isFileIgnored(@NonNls @NotNull String var1);

    @Deprecated
    public abstract String @NotNull [] getAssociatedExtensions(@NotNull FileType var1);

    @NotNull
    public abstract List<FileNameMatcher> getAssociations(@NotNull FileType var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void addFileTypeListener(@NotNull FileTypeListener var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void removeFileTypeListener(@NotNull FileTypeListener var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file) {
        if (file == null) {
            FileTypeManager.$$$reportNull$$$0(1);
        }
        return file.getFileType();
    }

    @Nullable
    public abstract FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile var1, @NotNull Project var2);

    @NotNull
    public abstract String getIgnoredFilesList();

    public abstract void setIgnoredFilesList(@NotNull String var1);

    public final void associateExtension(@NotNull FileType type, @NotNull @NonNls String extension) {
        if (type == null) {
            FileTypeManager.$$$reportNull$$$0(2);
        }
        if (extension == null) {
            FileTypeManager.$$$reportNull$$$0(3);
        }
        this.associate(type, new ExtensionFileNameMatcher(extension));
    }

    public final void associatePattern(@NotNull FileType type, @NotNull @NonNls String pattern) {
        if (type == null) {
            FileTypeManager.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            FileTypeManager.$$$reportNull$$$0(5);
        }
        this.associate(type, FileTypeManager.parseFromString(pattern));
    }

    public abstract void associate(@NotNull FileType var1, @NotNull FileNameMatcher var2);

    public final void removeAssociatedExtension(@NotNull FileType type, @NotNull @NonNls String extension) {
        if (type == null) {
            FileTypeManager.$$$reportNull$$$0(6);
        }
        if (extension == null) {
            FileTypeManager.$$$reportNull$$$0(7);
        }
        this.removeAssociation(type, new ExtensionFileNameMatcher(extension));
    }

    public abstract void removeAssociation(@NotNull FileType var1, @NotNull FileNameMatcher var2);

    @NotNull
    public static FileNameMatcher parseFromString(@NotNull String pattern) {
        if (pattern == null) {
            FileTypeManager.$$$reportNull$$$0(8);
        }
        FileNameMatcher fileNameMatcher = FileNameMatcherFactory.getInstance().createMatcher(pattern);
        if (fileNameMatcher == null) {
            FileTypeManager.$$$reportNull$$$0(9);
        }
        return fileNameMatcher;
    }

    @NotNull
    public abstract FileType getStdFileType(@NotNull @NonNls String var1);

    static {
        FileTypeRegistry.ourInstanceGetter = FileTypeManager::getInstance;
        ourInstance = CachedSingletonsRegistry.markCachedField(FileTypeManager.class);
        TOPIC = new Topic(FileTypeListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/FileTypeManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/FileTypeManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerFileType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKnownFileTypeOrAssociate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "associateExtension";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "associatePattern";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociatedExtension";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseFromString";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

