/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.StringJoiner;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public final class MacKeymapUtil {
    public static final String ESCAPE = "\u238b";
    public static final String TAB = "\u21e5";
    public static final String TAB_BACK = "\u21e4";
    public static final String CAPS_LOCK = "\u21ea";
    public static final String SHIFT = "\u21e7";
    public static final String CONTROL = "\u2303";
    public static final String OPTION = "\u2325";
    public static final String APPLE = "\uf8ff";
    public static final String COMMAND = "\u2318";
    public static final String SPACE = "\u2423";
    public static final String RETURN = "\u23ce";
    public static final String BACKSPACE = "\u232b";
    public static final String DELETE = "\u2326";
    public static final String HOME = "\u2196";
    public static final String END = "\u2198";
    public static final String PAGE_UP = "\u21de";
    public static final String PAGE_DOWN = "\u21df";
    public static final String UP = "\u2191";
    public static final String DOWN = "\u2193";
    public static final String LEFT = "\u2190";
    public static final String RIGHT = "\u2192";
    public static final String CLEAR = "\u2327";
    public static final String NUMBER_LOCK = "\u21ed";
    public static final String ENTER = "\u2324";
    public static final String EJECT = "\u23cf";
    public static final String POWER3 = "\u233d";
    public static final String NUM_PAD = "\u2328";

    @NotNull
    static String getModifiersText(@JdkConstants.InputEventMask int modifiers, String delimiter) {
        StringJoiner buf = new StringJoiner(delimiter != null ? delimiter : "");
        if ((modifiers & 2) != 0) {
            buf.add(MacKeymapUtil.get(CONTROL, "Ctrl+"));
        }
        if ((modifiers & 8) != 0) {
            buf.add(MacKeymapUtil.get(OPTION, "Alt+"));
        }
        if ((modifiers & 1) != 0) {
            buf.add(MacKeymapUtil.get(SHIFT, "Shift+"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.add(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.add(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        if ((modifiers & 4) != 0) {
            buf.add(MacKeymapUtil.get(COMMAND, "Cmd+"));
        }
        String string = buf.toString();
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    static String getModifiersText(@JdkConstants.InputEventMask int modifiers) {
        return MacKeymapUtil.getModifiersText(modifiers, null);
    }

    @NotNull
    public static String getKeyText(int code) {
        if (!Registry.is((String)"ide.macos.disable.native.shortcut.symbols", (boolean)false)) {
            switch (code) {
                case 8: {
                    return MacKeymapUtil.get(BACKSPACE, "Backspace");
                }
                case 27: {
                    return MacKeymapUtil.get(ESCAPE, "Escape");
                }
                case 20: {
                    return MacKeymapUtil.get(CAPS_LOCK, "Caps Lock");
                }
                case 9: {
                    return MacKeymapUtil.get(TAB, "Tab");
                }
                case 32: {
                    return "Space";
                }
                case 127: {
                    return MacKeymapUtil.get(DELETE, "Delete");
                }
                case 36: {
                    return MacKeymapUtil.get(HOME, "Home");
                }
                case 35: {
                    return MacKeymapUtil.get(END, "End");
                }
                case 33: {
                    return MacKeymapUtil.get(PAGE_UP, "Page Up");
                }
                case 34: {
                    return MacKeymapUtil.get(PAGE_DOWN, "Page Down");
                }
                case 38: {
                    return MacKeymapUtil.get(UP, "Up Arrow");
                }
                case 40: {
                    return MacKeymapUtil.get(DOWN, "Down Arrow");
                }
                case 37: {
                    return MacKeymapUtil.get(LEFT, "Left Arrow");
                }
                case 39: {
                    return MacKeymapUtil.get(RIGHT, "Right Arrow");
                }
                case 144: {
                    return MacKeymapUtil.get(NUMBER_LOCK, "Num Lock");
                }
                case 10: {
                    return MacKeymapUtil.get(RETURN, "Return");
                }
                case 520: {
                    return MacKeymapUtil.get(NUM_PAD, "NumPad");
                }
                case 106: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + " *";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                case 109: {
                    return "-";
                }
                case 107: {
                    return "+";
                }
                case 45: {
                    return "-";
                }
                case 521: {
                    return "+";
                }
                case 111: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "/";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                case 96: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "0";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                case 97: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "1";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                case 98: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "2";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(5);
                    }
                    return string;
                }
                case 99: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "3";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(6);
                    }
                    return string;
                }
                case 100: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "4";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(7);
                    }
                    return string;
                }
                case 101: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "5";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(8);
                    }
                    return string;
                }
                case 102: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "6";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(9);
                    }
                    return string;
                }
                case 103: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "7";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(10);
                    }
                    return string;
                }
                case 104: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "8";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(11);
                    }
                    return string;
                }
                case 105: {
                    String string = MacKeymapUtil.get(NUM_PAD, "NumPad") + "9";
                    if (string == null) {
                        MacKeymapUtil.$$$reportNull$$$0(12);
                    }
                    return string;
                }
                case 0: {
                    return "fn";
                }
            }
        }
        String string = KeyEvent.getKeyText(code);
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String getKeyStrokeText(@NotNull KeyStroke keyStroke, String delimiter, boolean onlyDelimIntoModifiersAndKey) {
        if (keyStroke == null) {
            MacKeymapUtil.$$$reportNull$$$0(14);
        }
        String modifiers = MacKeymapUtil.getModifiersText(keyStroke.getModifiers());
        String key = KeymapUtil.getKeyText(keyStroke.getKeyCode());
        if (!onlyDelimIntoModifiersAndKey) {
            modifiers = MacKeymapUtil.getModifiersText(keyStroke.getModifiers(), delimiter);
        }
        if (delimiter != null) {
            if (modifiers.isEmpty()) {
                String string = key;
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(15);
                }
                return string;
            }
            String string = modifiers + delimiter + key;
            if (string == null) {
                MacKeymapUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = modifiers + key;
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String getKeyStrokeText(@NotNull KeyStroke keyStroke) {
        if (keyStroke == null) {
            MacKeymapUtil.$$$reportNull$$$0(18);
        }
        return MacKeymapUtil.getKeyStrokeText(keyStroke, null, true);
    }

    @NotNull
    private static String get(@NotNull String value2, @NotNull String replacement) {
        if (value2 == null) {
            MacKeymapUtil.$$$reportNull$$$0(19);
        }
        if (replacement == null) {
            MacKeymapUtil.$$$reportNull$$$0(20);
        }
        if (Registry.is((String)"ide.macos.disable.native.shortcut.symbols", (boolean)false)) {
            String string = replacement;
            if (string == null) {
                MacKeymapUtil.$$$reportNull$$$0(21);
            }
            return string;
        }
        Font font = UIUtil.getLabelFont();
        String string = font == null || font.canDisplayUpTo(value2) == -1 ? value2 : replacement;
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/MacKeymapUtil";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/MacKeymapUtil";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokeText";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 14: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStrokeText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

