/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationQuickFix;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.util.NlsContexts;
import org.jetbrains.annotations.Nullable;

public class ConfigurationException
extends Exception {
    @NlsContexts.DialogTitle
    private String myTitle = ConfigurationException.getDefaultTitle();
    private ConfigurationQuickFix myQuickFix;
    private Configurable myOriginator;

    public ConfigurationException(@NlsContexts.DialogMessage String message) {
        super(message);
    }

    public ConfigurationException(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title) {
        super(message);
        this.myTitle = title;
    }

    public ConfigurationException(@NlsContexts.DialogMessage String message, Throwable cause, @NlsContexts.DialogTitle String title) {
        super(message, cause);
        this.myTitle = title;
    }

    @Override
    @NlsContexts.DialogMessage
    public String getMessage() {
        return super.getMessage();
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        return this.myTitle;
    }

    public void setQuickFix(@Nullable Runnable quickFix) {
        this.myQuickFix = quickFix == null ? null : dataContext -> quickFix.run();
    }

    public void setQuickFix(@Nullable ConfigurationQuickFix quickFix) {
        this.myQuickFix = quickFix;
    }

    @Deprecated
    @Nullable
    public Runnable getQuickFix() {
        return this.myQuickFix == null ? null : () -> this.myQuickFix.applyFix(DataContext.EMPTY_CONTEXT);
    }

    @Nullable
    public ConfigurationQuickFix getConfigurationQuickFix() {
        return this.myQuickFix;
    }

    @Nullable
    public Configurable getOriginator() {
        return this.myOriginator;
    }

    public void setOriginator(@Nullable Configurable originator) {
        this.myOriginator = originator;
    }

    public boolean shouldShowInDumbMode() {
        return true;
    }

    @NlsContexts.DialogTitle
    public static String getDefaultTitle() {
        return OptionsBundle.message("cannot.save.settings.default.dialog.title", new Object[0]);
    }
}

