/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeSettingsEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsEditor<Settings>
implements Disposable {
    private final List<SettingsEditorListener<Settings>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private UserActivityWatcher myWatcher;
    private boolean myIsInUpdate = false;
    private final Factory<? extends Settings> mySettingsFactory;
    private CompositeSettingsEditor<Settings> myOwner;
    private JComponent myEditorComponent;

    protected abstract void resetEditorFrom(@NotNull Settings var1);

    protected abstract void applyEditorTo(@NotNull Settings var1) throws ConfigurationException;

    @NotNull
    protected abstract JComponent createEditor();

    protected void disposeEditor() {
    }

    public SettingsEditor() {
        this(null);
    }

    public SettingsEditor(@Nullable Factory<? extends Settings> settingsFactory) {
        this.mySettingsFactory = settingsFactory;
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                SettingsEditor.this.disposeEditor();
                SettingsEditor.this.uninstallWatcher();
            }
        });
    }

    @NotNull
    public Settings getSnapshot() throws ConfigurationException {
        if (this.myOwner != null) {
            Settings Settings2 = this.myOwner.getSnapshot();
            if (Settings2 == null) {
                SettingsEditor.$$$reportNull$$$0(0);
            }
            return Settings2;
        }
        Object settings = this.mySettingsFactory.create();
        this.applyTo(settings);
        Object object = settings;
        if (object == null) {
            SettingsEditor.$$$reportNull$$$0(1);
        }
        return (Settings)object;
    }

    final void setOwner(CompositeSettingsEditor<Settings> owner) {
        this.myOwner = owner;
    }

    public final CompositeSettingsEditor<Settings> getOwner() {
        return this.myOwner;
    }

    public Factory<? extends Settings> getFactory() {
        return this.mySettingsFactory;
    }

    public final void resetFrom(Settings s) {
        this.bulkUpdate(() -> {
            if (this.myEditorComponent == null) {
                this.getComponent();
            }
            this.resetEditorFrom(s);
        });
    }

    public final void bulkUpdate(Runnable runnable) {
        boolean wasInUpdate = this.myIsInUpdate;
        try {
            this.myIsInUpdate = true;
            runnable.run();
        }
        finally {
            this.myIsInUpdate = wasInUpdate;
        }
        this.fireEditorStateChanged();
    }

    public final void applyTo(Settings s) throws ConfigurationException {
        this.applyEditorTo(s);
    }

    public final JComponent getComponent() {
        if (this.myEditorComponent == null) {
            this.myEditorComponent = this.createEditor();
            this.installWatcher(this.myEditorComponent);
        }
        return this.myEditorComponent;
    }

    public final void dispose() {
        this.myListeners.clear();
    }

    protected void uninstallWatcher() {
        this.myWatcher = null;
    }

    protected void installWatcher(JComponent c) {
        this.myWatcher = this.createWatcher();
        this.myWatcher.register(c);
        UserActivityListener userActivityListener = new UserActivityListener(){

            @Override
            public void stateChanged() {
                SettingsEditor.this.fireEditorStateChanged();
            }
        };
        this.myWatcher.addUserActivityListener(userActivityListener, this);
    }

    @NotNull
    protected UserActivityWatcher createWatcher() {
        return new UserActivityWatcher();
    }

    public final void addSettingsEditorListener(SettingsEditorListener<Settings> listener2) {
        this.myListeners.add(listener2);
    }

    public final void removeSettingsEditorListener(SettingsEditorListener<Settings> listener2) {
        this.myListeners.remove(listener2);
    }

    protected final void fireEditorStateChanged() {
        if (this.myIsInUpdate) {
            return;
        }
        for (SettingsEditorListener<Settings> listener2 : this.myListeners) {
            listener2.stateChanged(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SettingsEditor", "getSnapshot"));
    }
}

