/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.PassThroughIdeFocusManager;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeFocusManager
implements FocusRequestor {
    public ActionCallback requestFocusInProject(@NotNull Component c, @Nullable Project project) {
        if (c == null) {
            IdeFocusManager.$$$reportNull$$$0(0);
        }
        return this.requestFocus(c, false);
    }

    @Nullable
    public abstract JComponent getFocusTargetFor(@NotNull JComponent var1);

    public abstract void doWhenFocusSettlesDown(@NotNull Runnable var1);

    public abstract void doWhenFocusSettlesDown(@NotNull Runnable var1, @NotNull ModalityState var2);

    public abstract void doWhenFocusSettlesDown(@NotNull ExpirableRunnable var1);

    @Nullable
    public abstract Component getFocusedDescendantFor(@NotNull Component var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void typeAheadUntil(ActionCallback done2) {
    }

    @Deprecated
    public void typeAheadUntil(ActionCallback done2, @NotNull String cause) {
        if (cause == null) {
            IdeFocusManager.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            IdeFocusManager.$$$reportNull$$$0(2);
        }
        return actionCallback;
    }

    public abstract boolean isFocusTransferEnabled();

    @Deprecated
    public void setTypeaheadEnabled(boolean enabled) {
    }

    public abstract Component getFocusOwner();

    public abstract void runOnOwnContext(@NotNull DataContext var1, @NotNull Runnable var2);

    @Nullable
    public abstract Component getLastFocusedFor(@Nullable Window var1);

    @Nullable
    public abstract IdeFrame getLastFocusedFrame();

    @Nullable
    public abstract Window getLastFocusedIdeWindow();

    public abstract void toFront(JComponent var1);

    public static IdeFocusManager getInstance(@Nullable Project project) {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isHeadlessEnvironment() || app.isUnitTestMode() || project == null || project.isDisposed() || !project.isInitialized()) {
            return IdeFocusManager.getGlobalInstance();
        }
        return (IdeFocusManager)project.getService(IdeFocusManager.class);
    }

    @NotNull
    public static IdeFocusManager findInstanceByContext(@Nullable DataContext context) {
        IdeFocusManager instance = null;
        if (context != null) {
            instance = IdeFocusManager.getInstanceSafe((Project)CommonDataKeys.PROJECT.getData(context));
        }
        if (instance == null) {
            instance = IdeFocusManager.findByComponent(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
        }
        if (instance == null) {
            instance = IdeFocusManager.getGlobalInstance();
        }
        IdeFocusManager ideFocusManager = instance;
        if (ideFocusManager == null) {
            IdeFocusManager.$$$reportNull$$$0(3);
        }
        return ideFocusManager;
    }

    @NotNull
    public static IdeFocusManager findInstanceByComponent(@NotNull Component component) {
        IdeFocusManager instance;
        if (component == null) {
            IdeFocusManager.$$$reportNull$$$0(4);
        }
        IdeFocusManager ideFocusManager = (instance = IdeFocusManager.findByComponent(component)) == null ? IdeFocusManager.findInstanceByContext(null) : instance;
        if (ideFocusManager == null) {
            IdeFocusManager.$$$reportNull$$$0(5);
        }
        return ideFocusManager;
    }

    @Nullable
    private static IdeFocusManager findByComponent(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        Component parent = ComponentUtil.findUltimateParent((Component)component);
        return parent instanceof IdeFrame ? IdeFocusManager.getInstanceSafe(((IdeFrame)((Object)parent)).getProject()) : null;
    }

    @Nullable
    private static IdeFocusManager getInstanceSafe(@Nullable Project project) {
        if (project != null && !project.isDisposed() && project.isInitialized()) {
            return IdeFocusManager.getInstance(project);
        }
        return null;
    }

    @NotNull
    public static IdeFocusManager findInstance() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return owner != null ? IdeFocusManager.findInstanceByComponent(owner) : IdeFocusManager.findInstanceByContext(null);
    }

    @NotNull
    public static IdeFocusManager getGlobalInstance() {
        IdeFocusManager focusManager = null;
        Application app = ApplicationManager.getApplication();
        if (app != null && LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            focusManager = (IdeFocusManager)app.getService(IdeFocusManager.class);
        }
        if (focusManager == null) {
            focusManager = PassThroughIdeFocusManager.getInstance();
        }
        PassThroughIdeFocusManager passThroughIdeFocusManager = focusManager;
        if (passThroughIdeFocusManager == null) {
            IdeFocusManager.$$$reportNull$$$0(6);
        }
        return passThroughIdeFocusManager;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/IdeFocusManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/IdeFocusManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requestDefaultFocus";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstanceByContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstanceByComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestFocusInProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "typeAheadUntil";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findInstanceByComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

