/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.presentation;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSelectSettingPresentation
extends CodeStyleSettingPresentation {
    protected int @NotNull [] myValues;
    protected String @NotNull [] myValueUiNames;
    protected int myLowerBound;
    protected int myUpperBound;

    public CodeStyleSelectSettingPresentation(@NotNull String fieldName, @NlsContexts.Label @NotNull String uiName, int @NotNull [] values, String @NotNull [] valueUiNames) {
        if (fieldName == null) {
            CodeStyleSelectSettingPresentation.$$$reportNull$$$0(0);
        }
        if (uiName == null) {
            CodeStyleSelectSettingPresentation.$$$reportNull$$$0(1);
        }
        if (values == null) {
            CodeStyleSelectSettingPresentation.$$$reportNull$$$0(2);
        }
        if (valueUiNames == null) {
            CodeStyleSelectSettingPresentation.$$$reportNull$$$0(3);
        }
        super(fieldName, uiName);
        assert (values.length == valueUiNames.length);
        assert (values.length > 0);
        this.myValues = values;
        this.myValueUiNames = valueUiNames;
        this.myLowerBound = values[0];
        this.myUpperBound = values[0];
        for (int value2 : values) {
            this.myLowerBound = Math.min(value2, this.myLowerBound);
            this.myUpperBound = Math.max(value2, this.myUpperBound);
        }
    }

    @Override
    @NotNull
    public String getValueUiName(@NotNull Object value2) {
        if (value2 == null) {
            CodeStyleSelectSettingPresentation.$$$reportNull$$$0(4);
        }
        if (value2 instanceof Integer) {
            int intValue = (Integer)value2;
            for (int i = 0; i < this.myValues.length; ++i) {
                if (this.myValues[i] != intValue) continue;
                String string = this.myValueUiNames[i];
                if (string == null) {
                    CodeStyleSelectSettingPresentation.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        String string = super.getValueUiName(value2);
        if (string == null) {
            CodeStyleSelectSettingPresentation.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int getLowerBound() {
        return this.myLowerBound;
    }

    public int getUpperBound() {
        return this.myUpperBound;
    }

    public int @NotNull [] getValues() {
        if (this.myValues == null) {
            CodeStyleSelectSettingPresentation.$$$reportNull$$$0(7);
        }
        return this.myValues;
    }

    public String @NotNull [] getOptions() {
        if (this.myValueUiNames == null) {
            CodeStyleSelectSettingPresentation.$$$reportNull$$$0(8);
        }
        return this.myValueUiNames;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueUiNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/presentation/CodeStyleSelectSettingPresentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueUiName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValueUiName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

