/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.animation.Easing;
import com.intellij.util.animation.JBAnimator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class Animation {
    @NotNull
    private final DoubleConsumer myConsumer;
    @NotNull
    private Easing myEasing;
    private int myDelay;
    private int myDuration;
    @Nullable
    private List<Listener> myListeners;

    public Animation(@NotNull DoubleConsumer consumer2) {
        if (consumer2 == null) {
            Animation.$$$reportNull$$$0(0);
        }
        this.myEasing = Easing.LINEAR;
        this.myDelay = 0;
        this.myDuration = 500;
        this.myConsumer = consumer2;
    }

    public Animation(DoubleConsumer ... consumers) {
        if (consumers == null) {
            Animation.$$$reportNull$$$0(1);
        }
        this.myEasing = Easing.LINEAR;
        this.myDelay = 0;
        this.myDuration = 500;
        this.myConsumer = value2 -> {
            for (DoubleConsumer consumer2 : consumers) {
                consumer2.accept(value2);
            }
        };
    }

    public <T> Animation(@NotNull DoubleFunction<? extends T> function, @NotNull Consumer<T> consumer2) {
        if (function == null) {
            Animation.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            Animation.$$$reportNull$$$0(3);
        }
        this.myEasing = Easing.LINEAR;
        this.myDelay = 0;
        this.myDuration = 500;
        this.myConsumer = value2 -> consumer2.accept(function.apply(value2));
    }

    public int getDelay() {
        return this.myDelay;
    }

    @NotNull
    public Animation setDelay(int delay) {
        this.myDelay = Math.max(delay, 0);
        Animation animation2 = this;
        if (animation2 == null) {
            Animation.$$$reportNull$$$0(4);
        }
        return animation2;
    }

    public int getDuration() {
        return this.myDuration;
    }

    @NotNull
    public Animation setDuration(int duration) {
        this.myDuration = Math.max(duration, 0);
        Animation animation2 = this;
        if (animation2 == null) {
            Animation.$$$reportNull$$$0(5);
        }
        return animation2;
    }

    void update(double timeline) {
        this.myConsumer.accept(this.myEasing.calc(timeline));
    }

    @NotNull
    public Easing getEasing() {
        Easing easing = this.myEasing;
        if (easing == null) {
            Animation.$$$reportNull$$$0(6);
        }
        return easing;
    }

    @NotNull
    public Animation setEasing(@NotNull Easing easing) {
        if (easing == null) {
            Animation.$$$reportNull$$$0(7);
        }
        this.myEasing = easing;
        Animation animation2 = this;
        if (animation2 == null) {
            Animation.$$$reportNull$$$0(8);
        }
        return animation2;
    }

    @NotNull
    public Animation addListener(@NotNull Listener listener2) {
        if (listener2 == null) {
            Animation.$$$reportNull$$$0(9);
        }
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<Listener>();
        }
        this.myListeners.add(listener2);
        Animation animation2 = this;
        if (animation2 == null) {
            Animation.$$$reportNull$$$0(10);
        }
        return animation2;
    }

    @NotNull
    public Animation runWhenScheduled(@NotNull Runnable runnable) {
        if (runnable == null) {
            Animation.$$$reportNull$$$0(11);
        }
        return this.addListener(Phase.SCHEDULED, runnable);
    }

    @NotNull
    public Animation runWhenUpdated(@NotNull Runnable runnable) {
        if (runnable == null) {
            Animation.$$$reportNull$$$0(12);
        }
        return this.addListener(Phase.UPDATED, runnable);
    }

    @NotNull
    public Animation runWhenExpired(@NotNull Runnable runnable) {
        if (runnable == null) {
            Animation.$$$reportNull$$$0(13);
        }
        return this.addListener(Phase.EXPIRED, runnable);
    }

    @NotNull
    private Animation addListener(@NotNull Phase phase, @NotNull Runnable runnable) {
        if (phase == null) {
            Animation.$$$reportNull$$$0(14);
        }
        if (runnable == null) {
            Animation.$$$reportNull$$$0(15);
        }
        Animation animation2 = this.addListener(p -> {
            if (p == phase) {
                runnable.run();
            }
        });
        if (animation2 == null) {
            Animation.$$$reportNull$$$0(16);
        }
        return animation2;
    }

    public void fireEvent(@NotNull Phase phase) {
        if (phase == null) {
            Animation.$$$reportNull$$$0(17);
        }
        if (this.myListeners == null) {
            return;
        }
        Iterator<Listener> iterator = this.myListeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().update(phase);
            }
            catch (Throwable t) {
                iterator.remove();
                Logger.getInstance(JBAnimator.class).error("Listener caused an error and was removed from listeners", t);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/animation/Animation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "easing";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/animation/Animation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setDelay";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setDuration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEasing";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setEasing";
                break;
            }
            case 10: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setEasing";
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runWhenScheduled";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runWhenUpdated";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runWhenExpired";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Phase {
        SCHEDULED,
        UPDATED,
        EXPIRED;

    }

    @FunctionalInterface
    public static interface Listener {
        public void update(@NotNull Phase var1);
    }
}

