/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.animation.Animation;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class JBAnimator
implements Disposable {
    private int myPeriod;
    @NotNull
    private Type myType;
    private boolean myCyclic;
    private boolean myIgnorePowerSaveMode;
    @NotNull
    private final ScheduledExecutorService myService;
    @NotNull
    private final AtomicLong myRunning;
    @NotNull
    private final AtomicBoolean myDisposed;

    public JBAnimator() {
        this(Thread.SWING_THREAD, null);
    }

    public JBAnimator(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JBAnimator.$$$reportNull$$$0(0);
        }
        this(Thread.SWING_THREAD, parentDisposable);
    }

    public JBAnimator(@NotNull Thread threadToUse, @Nullable Disposable parentDisposable) {
        if (threadToUse == null) {
            JBAnimator.$$$reportNull$$$0(1);
        }
        this.myPeriod = 16;
        this.myType = Type.IN_TIME;
        this.myCyclic = false;
        this.myIgnorePowerSaveMode = false;
        this.myRunning = new AtomicLong();
        this.myDisposed = new AtomicBoolean();
        ScheduledExecutorService scheduledExecutorService = this.myService = threadToUse == Thread.SWING_THREAD ? EdtExecutorService.getScheduledExecutorInstance() : AppExecutorUtil.createBoundedScheduledExecutorService((String)"Animator Pool", (int)1);
        if (parentDisposable == null) {
            if (threadToUse != Thread.SWING_THREAD) {
                Logger.getInstance(JBAnimator.class).error((Throwable)new IllegalArgumentException("You must provide parent Disposable for non-swing thread Alarm"));
            }
        } else {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    public void animate(Animation ... animations) {
        if (animations == null) {
            JBAnimator.$$$reportNull$$$0(2);
        }
        this.animate(Arrays.asList(animations));
    }

    public void animate(final @NotNull @NotNull Collection<@NotNull Animation> animations) {
        int duration;
        if (animations == null) {
            JBAnimator.$$$reportNull$$$0(3);
        }
        if (this.myDisposed.get()) {
            Logger.getInstance(JBAnimator.class).warn("Animator is already disposed");
            return;
        }
        int from = Integer.MAX_VALUE;
        int to = 0;
        for (Animation animation2 : animations) {
            from = Math.min(animation2.getDelay(), from);
            to = Math.max(animation2.getDelay() + animation2.getDuration(), to);
        }
        final int delay = animations.isEmpty() ? 0 : from;
        int n = duration = animations.isEmpty() ? 0 : to - from;
        if (!this.myIgnorePowerSaveMode && PowerSaveMode.isEnabled() || duration == 0) {
            this.myService.schedule(() -> {
                this.myRunning.incrementAndGet();
                for (Animation animation2 : animations) {
                    try {
                        animation2.fireEvent(Animation.Phase.SCHEDULED);
                        animation2.update(1.0);
                        animation2.fireEvent(Animation.Phase.UPDATED);
                        animation2.fireEvent(Animation.Phase.EXPIRED);
                    }
                    catch (Throwable t) {
                        Logger.getInstance(Animation.class).error(t);
                    }
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
            return;
        }
        this.myService.schedule(new Runnable(){
            final long rid;
            @Nullable
            FrameCounter frameCounter;
            @NotNull
            LinkedHashSet<Animation> scheduledAnimations;
            {
                this.rid = JBAnimator.this.myRunning.incrementAndGet();
                this.scheduledAnimations = new LinkedHashSet();
            }

            private void prepareAnimations() {
                this.frameCounter = JBAnimator.create(JBAnimator.this.myType, JBAnimator.this.myPeriod, duration, delay);
                this.scheduledAnimations = new LinkedHashSet(animations);
                for (Animation animation2 : this.scheduledAnimations) {
                    animation2.fireEvent(Animation.Phase.SCHEDULED);
                }
            }

            @Override
            public void run() {
                if (this.rid < JBAnimator.this.myRunning.get()) {
                    return;
                }
                if (this.frameCounter == null) {
                    this.prepareAnimations();
                }
                long totalFrames = this.frameCounter.getTotalFrames();
                long currentFrame = Math.min(this.frameCounter.getCurrentFrame(), totalFrames);
                long nextDelay = this.frameCounter.getDelay(currentFrame);
                double timeline = (double)currentFrame / (double)totalFrames;
                if (currentFrame >= totalFrames && JBAnimator.this.myCyclic) {
                    this.frameCounter = null;
                }
                LinkedList<Animation> expired = new LinkedList<Animation>();
                for (Animation animation2 : this.scheduledAnimations) {
                    double start = (double)(animation2.getDelay() - delay) / (double)duration;
                    double end = start + (double)animation2.getDuration() / (double)duration;
                    if (start <= timeline) {
                        try {
                            animation2.update((timeline - start) / (end - start));
                            animation2.fireEvent(Animation.Phase.UPDATED);
                        }
                        catch (Throwable t) {
                            Logger.getInstance(Animation.class).error(t);
                        }
                    }
                    if (!(timeline > end)) continue;
                    expired.add(animation2);
                }
                expired.forEach(this.scheduledAnimations::remove);
                boolean isProceed = currentFrame < totalFrames || JBAnimator.this.myCyclic;
                for (Animation animation3 : isProceed ? expired : this.scheduledAnimations) {
                    animation3.fireEvent(Animation.Phase.EXPIRED);
                }
                if (isProceed) {
                    JBAnimator.this.myService.schedule(this, nextDelay, TimeUnit.MILLISECONDS);
                }
            }
        }, (long)delay, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.myRunning.incrementAndGet();
    }

    public int getPeriod() {
        return this.myPeriod;
    }

    @NotNull
    public JBAnimator setPeriod(int period) {
        this.myPeriod = Math.max(period, 5);
        JBAnimator jBAnimator = this;
        if (jBAnimator == null) {
            JBAnimator.$$$reportNull$$$0(4);
        }
        return jBAnimator;
    }

    public boolean isCyclic() {
        return this.myCyclic;
    }

    @NotNull
    public JBAnimator setCyclic(boolean cyclic) {
        this.myCyclic = cyclic;
        JBAnimator jBAnimator = this;
        if (jBAnimator == null) {
            JBAnimator.$$$reportNull$$$0(5);
        }
        return jBAnimator;
    }

    @NotNull
    public JBAnimator ignorePowerSaveMode() {
        this.myIgnorePowerSaveMode = true;
        JBAnimator jBAnimator = this;
        if (jBAnimator == null) {
            JBAnimator.$$$reportNull$$$0(6);
        }
        return jBAnimator;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            JBAnimator.$$$reportNull$$$0(7);
        }
        return type;
    }

    @NotNull
    public JBAnimator setType(Type type) {
        this.myType = type;
        JBAnimator jBAnimator = this;
        if (jBAnimator == null) {
            JBAnimator.$$$reportNull$$$0(8);
        }
        return jBAnimator;
    }

    public void dispose() {
        this.stop();
        if (!this.myDisposed.getAndSet(true) && this.myService != EdtExecutorService.getScheduledExecutorInstance()) {
            this.myService.shutdownNow();
        }
    }

    private static FrameCounter create(@NotNull Type type, final int period, final int duration, final int delay) {
        if (type == null) {
            JBAnimator.$$$reportNull$$$0(9);
        }
        switch (type) {
            case EACH_FRAME: {
                return new FrameCounter(){
                    final long frames;
                    long frame;
                    {
                        this.frames = duration / period + (duration % period == 0 ? 0 : 1);
                        this.frame = 0L;
                    }

                    @Override
                    public long getCurrentFrame() {
                        return this.frame++;
                    }

                    @Override
                    public long getTotalFrames() {
                        return Math.max(this.frames, 1L);
                    }

                    @Override
                    public long getDelay(long currentFrame) {
                        return period;
                    }
                };
            }
            case IN_TIME: {
                return new FrameCounter(){
                    final long startTime;
                    {
                        this.startTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + (long)delay;
                    }

                    @Override
                    public long getCurrentFrame() {
                        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.startTime;
                    }

                    @Override
                    public long getTotalFrames() {
                        return duration;
                    }

                    @Override
                    public long getDelay(long currentFrame) {
                        return Math.min((long)duration - currentFrame, (long)period);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadToUse";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "animations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/animation/JBAnimator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/animation/JBAnimator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setPeriod";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setCyclic";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ignorePowerSaveMode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "animate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface FrameCounter {
        public long getCurrentFrame();

        public long getTotalFrames();

        public long getDelay(long var1);
    }

    public static enum Type {
        EACH_FRAME,
        IN_TIME;

    }

    public static enum Thread {
        SWING_THREAD,
        POOLED_THREAD;

    }
}

