/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangPreprocessedReport {
    @NotNull
    private final List<PreprocessedFile> myPreprocessedFiles;

    public ClangPreprocessedReport(@NotNull List<PreprocessedFile> preprocessedFiles) {
        if (preprocessedFiles == null) {
            ClangPreprocessedReport.$$$reportNull$$$0(0);
        }
        this.myPreprocessedFiles = preprocessedFiles;
    }

    @NotNull
    public List<PreprocessedFile> getPreprocessedFiles() {
        List<PreprocessedFile> list = Collections.unmodifiableList(this.myPreprocessedFiles);
        if (list == null) {
            ClangPreprocessedReport.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preprocessedFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangPreprocessedReport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangPreprocessedReport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreprocessedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PreprocessedFile {
        @NotNull
        public final String targetPath;
        @Nullable
        public final String lastDiagnostics;
        @NotNull
        public final List<String> commandLine;
        @NotNull
        public final String clangTidyConfig;
        @NotNull
        public final String clionClangTidyConfig;
        @NotNull
        public final String clazyConfig;
        public final boolean namehintsEnabled;
        @Nullable
        public final ClionClangDFAConfigParams dfaConfigParams;
        @NotNull
        public final UnusedIncludesInspectionMode unusedIncludesMode;
        @NotNull
        public final String diags;
        @Nullable
        public final String content;
        @NotNull
        public final String macros;

        public PreprocessedFile(@NotNull String path, @Nullable String lastDiagnostics, @NotNull List<String> commandLine, @NotNull String clangTidyConfig, @NotNull String clionClangTidyConfig, @NotNull String clazyConfig, boolean namehintsEnabled, @Nullable ClionClangDFAConfigParams dfaConfigParams, @NotNull UnusedIncludesInspectionMode unusedIncludesMode, @NotNull String diags, @Nullable String content, @NotNull String macros) {
            if (path == null) {
                PreprocessedFile.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                PreprocessedFile.$$$reportNull$$$0(1);
            }
            if (clangTidyConfig == null) {
                PreprocessedFile.$$$reportNull$$$0(2);
            }
            if (clionClangTidyConfig == null) {
                PreprocessedFile.$$$reportNull$$$0(3);
            }
            if (clazyConfig == null) {
                PreprocessedFile.$$$reportNull$$$0(4);
            }
            if (unusedIncludesMode == null) {
                PreprocessedFile.$$$reportNull$$$0(5);
            }
            if (diags == null) {
                PreprocessedFile.$$$reportNull$$$0(6);
            }
            if (macros == null) {
                PreprocessedFile.$$$reportNull$$$0(7);
            }
            this.targetPath = path;
            this.commandLine = commandLine;
            this.clangTidyConfig = clangTidyConfig;
            this.clionClangTidyConfig = clionClangTidyConfig;
            this.clazyConfig = clazyConfig;
            this.namehintsEnabled = namehintsEnabled;
            this.dfaConfigParams = dfaConfigParams;
            this.unusedIncludesMode = unusedIncludesMode;
            this.diags = diags;
            this.content = content;
            this.macros = macros;
            this.lastDiagnostics = lastDiagnostics;
        }

        @NotNull
        public String getCompilationInfoAsString(@Nullable Obfuscator obfuscator) {
            List<String> preparedCommandLine;
            String preparedTargetPath;
            if (obfuscator != null) {
                preparedTargetPath = obfuscator.obfuscatePath(this.targetPath);
                preparedCommandLine = obfuscator.obfuscateCommandLine(this.commandLine);
            } else {
                preparedTargetPath = this.targetPath;
                preparedCommandLine = this.commandLine;
            }
            String string = "Target file: " + preparedTargetPath + "\nCompilation command: " + StringUtil.join(preparedCommandLine, (String)" ") + "\nClang-tidy config: " + this.clangTidyConfig + "\nCLion clang-tidy config: " + this.clionClangTidyConfig + "\nClazy config: " + this.clazyConfig + "\nNamehints: " + this.namehintsEnabled + "\nDFA Input: " + this.getDfaConfigAsString() + "\nUnusedIncludesInspection: " + this.unusedIncludesMode + "\nPP Diagnostics: " + this.diags + "\n";
            if (string == null) {
                PreprocessedFile.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public String getContent(@Nullable Obfuscator obfuscator) {
            if (this.content == null) {
                return "<failed to preprocess>";
            }
            if (obfuscator != null) {
                String string = obfuscator.obfuscate(this.content);
                if (string == null) {
                    PreprocessedFile.$$$reportNull$$$0(9);
                }
                return string;
            }
            String string = this.content;
            if (string == null) {
                PreprocessedFile.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        public String getTargetPath(@Nullable Obfuscator obfuscator) {
            String string = obfuscator != null ? obfuscator.obfuscatePath(this.targetPath) : this.targetPath;
            if (string == null) {
                PreprocessedFile.$$$reportNull$$$0(11);
            }
            return string;
        }

        @NotNull
        private String getDfaConfigAsString() {
            if (this.dfaConfigParams == null) {
                return "disabled";
            }
            return this.dfaConfigParams.isGlobalMode() ? "global" : "local";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clangTidyConfig";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clionClangTidyConfig";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazyConfig";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unusedIncludesMode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diags";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "macros";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangPreprocessedReport$PreprocessedFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangPreprocessedReport$PreprocessedFile";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompilationInfoAsString";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

