/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import java.io.File;
import java.net.URI;
import org.jetbrains.annotations.NotNull;

public class ClangUrlConverter {
    private static final Logger LOG = Logger.getInstance((String)ClangUrlConverter.class.getName());

    public boolean isAcceptable(@NotNull String url) {
        if (url == null) {
            ClangUrlConverter.$$$reportNull$$$0(0);
        }
        return url.startsWith("file://");
    }

    @NotNull
    public String fromUri(@NotNull String uri) {
        String string;
        int index;
        if (uri == null) {
            ClangUrlConverter.$$$reportNull$$$0(1);
        }
        if ((index = uri.indexOf("://")) < 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("fromUri: Passed url/path '" + uri + "' is already decoded");
            }
            String string2 = uri;
            if (string2 == null) {
                ClangUrlConverter.$$$reportNull$$$0(2);
            }
            return string2;
        }
        try {
            URI javaUri = URI.create(ClangUrlConverter.fixFileSchemeUrl(uri));
            String path = javaUri.getPath();
            if (SystemInfo.isWindows && path.startsWith("/") && path.length() > 2 && Character.isLetter(path.charAt(1)) && path.charAt(2) == ':') {
                path = path.substring(1);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("fromUri: Passed url/path '" + uri + "' decoded to '" + path + "'");
            }
            string = path;
        }
        catch (IllegalArgumentException ex) {
            ClangUtils.warnClangd(LOG, "Failed to decode " + uri);
            String string3 = uri;
            if (string3 == null) {
                ClangUrlConverter.$$$reportNull$$$0(4);
            }
            return string3;
        }
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String toUri(@NotNull String urlOrPath) {
        int index;
        if (urlOrPath == null) {
            ClangUrlConverter.$$$reportNull$$$0(5);
        }
        if ((index = urlOrPath.indexOf("://")) >= 0) {
            return ClangUrlConverter.urlToUri(urlOrPath);
        }
        return ClangUrlConverter.pathToUri(urlOrPath);
    }

    @NotNull
    public String fromUriToUrl(@NotNull String uri) {
        if (uri == null) {
            ClangUrlConverter.$$$reportNull$$$0(6);
        }
        String string = VirtualFileManager.constructUrl((String)"file", (String)this.fromUri(uri));
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String pathToUri(@NotNull String path) {
        String string;
        if (path == null) {
            ClangUrlConverter.$$$reportNull$$$0(8);
        }
        assert (!path.contains("://"));
        try {
            URI uri = VfsUtil.toUri((File)new File(path));
            if (LOG.isTraceEnabled()) {
                LOG.trace("toUri: Passed path '" + path + "' encoded to '" + uri.toString() + "'");
            }
            string = uri.toString();
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Throwable)ex);
            String string2 = path;
            if (string2 == null) {
                ClangUrlConverter.$$$reportNull$$$0(10);
            }
            return string2;
        }
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String urlToUri(@NotNull String url) {
        if (url == null) {
            ClangUrlConverter.$$$reportNull$$$0(11);
        }
        assert (url.startsWith("file://")) : "urlToUri: url '" + url + "' must have file:// protocol";
        String withFixedScheme = ClangUrlConverter.fixFileSchemeUrl(url);
        return ClangUrlConverter.fixSpacesInUrl(withFixedScheme);
    }

    @NotNull
    private static String fixFileSchemeUrl(@NotNull String url) {
        if (url == null) {
            ClangUrlConverter.$$$reportNull$$$0(12);
        }
        int index = url.indexOf("://");
        assert (index >= 0) : "Why not url?";
        Object fixedUrl = url;
        int afterSchemeIndex = index + "://".length();
        if (afterSchemeIndex == url.length()) {
            fixedUrl = url + "/";
        } else if (SystemInfo.isWindows && url.substring(afterSchemeIndex).startsWith("wsl")) {
            fixedUrl = url.substring(0, afterSchemeIndex) + "//" + url.substring(afterSchemeIndex);
        } else if (url.charAt(afterSchemeIndex) != '/') {
            fixedUrl = url.substring(0, afterSchemeIndex) + "/" + url.substring(afterSchemeIndex);
        }
        Object result = fixedUrl;
        if (LOG.isTraceEnabled() && !((String)result).contentEquals(url)) {
            LOG.trace("toUri: Passed url '" + url + "' fixed into '" + (String)result + "'");
        }
        Object object = result;
        if (object == null) {
            ClangUrlConverter.$$$reportNull$$$0(13);
        }
        return object;
    }

    @NotNull
    private static String fixSpacesInUrl(@NotNull String url) {
        if (url == null) {
            ClangUrlConverter.$$$reportNull$$$0(14);
        }
        if (url.contains(" ")) {
            String string = url.replaceAll(" ", "%20");
            if (string == null) {
                ClangUrlConverter.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangUrlConverter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlOrPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangUrlConverter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromUri";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromUriToUrl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToUri";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fixFileSchemeUrl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fixSpacesInUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromUri";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toUri";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromUriToUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pathToUri";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "urlToUri";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fixFileSchemeUrl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fixSpacesInUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

