/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Producer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangPreprocessedReport;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.FullCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ThrowableFunction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdContentDependentCaches;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdRequestsPlanner;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.InlayHintsKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.LineMarkersKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.TestLineMarkersKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.memory.ClangMemoryUsageWatchDogImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCheckPreprocessedCaseParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCompletionParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionWorkspaceSymbolParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangdInlayHint;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFileStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionSetCDBParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionTestRunLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTBasedRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCancelParseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClionLineMarkersRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCloseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLine;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLineArgument;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCompletionRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDeleteNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDumpASTRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDumpTokensRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFormatConfigurationRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFormatRangeRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangGotoDefinitionRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangHeavyRequestBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangIndentRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInlayHintsRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOpenNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOptionsFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangParseCommandLineRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPreprocessRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReloadGraphNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReloadIndexNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSaveRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSetCDBNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangTestLineMarkersRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingParseListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.eclipse.lsp4j.CompletionContext;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdLanguageService
implements ClangLanguageService,
PendingParseListener,
PsiModificationTracker.Listener {
    private static final Logger LOG = Logger.getInstance((String)ClangdLanguageService.class.getName());
    private static final WorkspaceFile.Key<Map<OpenRequestId, Integer>> OPEN_REQUESTS = new WorkspaceFile.Key<Map>("OpenRequests", () -> new HashMap());
    private static final Key<UsagesInfo> USAGES_MAP = new Key("UsagesMap");
    private static final Key<Object> CANCELED_FLAG = new Key("CanceledFlag");
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ClangLocalWorkspace myWorkspace;
    @NotNull
    private final ClangIdeFacade myIdeFacade;
    @NotNull
    protected final ClangdRequestsPlanner myRequestsPlanner;
    @NotNull
    private final ClangMemoryUsageWatchDog myMemoryUsageWatchDog;
    @NotNull
    private final Set<UserDataHolder> myDebugUsagesSet;
    @NotNull
    private final ClangdContentDependentCaches myContentDependentCache;
    @NotNull
    private final Cache<GotoDefinitionKey, ClangGotoDefinitionRequest> myGotoDefinitionCache;

    public ClangdLanguageService(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangdLanguageService.$$$reportNull$$$0(0);
        }
        this.myDebugUsagesSet = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
        this.myContentDependentCache = new ClangdContentDependentCaches();
        this.myGotoDefinitionCache = CacheBuilder.newBuilder().maximumSize(4096L).build();
        this.myContext = context;
        this.myProject = context.getProject();
        this.myWorkspace = context.getLocalWorkspace();
        this.myIdeFacade = context.getIdeFacade();
        this.myRequestsPlanner = new ClangdRequestsPlanner(context.getDescriptor(), context.getServerAccessorProvider().createServerAccessor(context));
        this.myWorkspace.addPendingParseListener(this);
        this.myMemoryUsageWatchDog = new ClangMemoryUsageWatchDogImpl(context, this);
        context.getProject().getMessageBus().connect((Disposable)context).subscribe(PsiModificationTracker.TOPIC, (Object)this);
        if (context.shouldStartServerImmediately()) {
            this.myRequestsPlanner.sendImmediately(ClangInteraction.createSimple("Misc", (Consumer<? super ClangServer>)((Consumer)server -> {}), true));
        }
    }

    @Override
    public void onOverflow(@NotNull ClangParseResponse oldest) {
        if (oldest == null) {
            ClangdLanguageService.$$$reportNull$$$0(1);
        }
        this.myWorkspace.modify(oldest.getUrl(), wf -> this.sendCancelParse((LocalWorkspaceFile)wf, oldest));
    }

    public void modificationCountChanged() {
        this.myContentDependentCache.clear();
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    @NotNull
    public Disposable getAssociatedDisposable() {
        ClangDaemonContext clangDaemonContext = this.myContext;
        if (clangDaemonContext == null) {
            ClangdLanguageService.$$$reportNull$$$0(2);
        }
        return clangDaemonContext;
    }

    @Override
    @NotNull
    public String getDescriptor() {
        String string = this.myContext.getDescriptor();
        if (string == null) {
            ClangdLanguageService.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myContext.getMessageBus();
        if (messageBus == null) {
            ClangdLanguageService.$$$reportNull$$$0(4);
        }
        return messageBus;
    }

    @Override
    @NotNull
    public ClangIdeFacade getClangIdeFacade() {
        ClangIdeFacade clangIdeFacade = this.myIdeFacade;
        if (clangIdeFacade == null) {
            ClangdLanguageService.$$$reportNull$$$0(5);
        }
        return clangIdeFacade;
    }

    @Override
    public boolean isActive() {
        return !this.myContext.isStopped();
    }

    @Override
    @NotNull
    public ClangTelemetry getTelemetry() {
        ClangTelemetry clangTelemetry = this.myContext.getTelemetry();
        if (clangTelemetry == null) {
            ClangdLanguageService.$$$reportNull$$$0(6);
        }
        return clangTelemetry;
    }

    @Override
    @NotNull
    public ClangMemoryUsageWatchDog getMemoryUsageWatchDog() {
        ClangMemoryUsageWatchDog clangMemoryUsageWatchDog = this.myMemoryUsageWatchDog;
        if (clangMemoryUsageWatchDog == null) {
            ClangdLanguageService.$$$reportNull$$$0(7);
        }
        return clangMemoryUsageWatchDog;
    }

    @Override
    public <E extends Throwable> void gotoDefinition(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<List<ClangSym>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(9);
        }
        ClangResultImpl result = this.computeWithParsedInternal("gotoDefinition", file, (modifier, response) -> this.sendGotoDefinition((ClangParseResponse)response, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void dumpAST(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<String, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(11);
        }
        ClangResultImpl result = this.computeWithParsedInternal("dumpAST", file, (modifier, response) -> this.sendDumpAST((ClangParseResponse)response, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void dumpTokens(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<String, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(13);
        }
        ClangResultImpl result = this.computeWithParsedInternal("dumpTokens", file, (modifier, response) -> this.sendDumpTokens((ClangParseResponse)response, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void complete(@NotNull VirtualFile file, int line, int column, @NotNull String fileText, @NotNull CompletionTriggerKind kind, @NotNull CLionCompletionKind completionKind, Pair<Integer, ArrayList<String>> postfixTemplates, @NotNull ClangResultConsumer<Either<List<CLionCompletionItem>, CLionCompletionList>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(14);
        }
        if (fileText == null) {
            ClangdLanguageService.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            ClangdLanguageService.$$$reportNull$$$0(16);
        }
        if (completionKind == null) {
            ClangdLanguageService.$$$reportNull$$$0(17);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(18);
        }
        ClangResultImpl result = this.computeWithParsedInternal("complete", file, (wf, response) -> this.sendRequestComplete(file, line, column, fileText, kind, completionKind, postfixTemplates));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getFastLineMarkers(@NotNull VirtualFile file, int fromOffset, int toOffset, @NotNull ClangResultConsumer<List<ClionLineMarker>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(19);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(20);
        }
        ClangResultImpl result = this.computeWithParsedInternal("getFastLineMarkers", file, (wf, response) -> this.sendClionLineMarkers(file, fromOffset, toOffset, true));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getSlowLineMarkers(@NotNull VirtualFile file, int fromOffset, int toOffset, @NotNull ClangResultConsumer<List<ClionLineMarker>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(21);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(22);
        }
        ClangResultImpl result = this.computeWithParsedInternal("getSlowLineMarkers", file, (wf, response) -> this.sendClionLineMarkers(file, fromOffset, toOffset, false));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getTestLineMarkers(@NotNull VirtualFile file, @NotNull List<String> enabledTestFrameworksNames, @NotNull ClangResultConsumer<List<ClionTestRunLineMarker>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(23);
        }
        if (enabledTestFrameworksNames == null) {
            ClangdLanguageService.$$$reportNull$$$0(24);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(25);
        }
        ClangResultImpl result = this.computeWithParsedInternal("getTestRunLineMarkers", file, (wf, response) -> this.sendClionTestLineMarkers(file, enabledTestFrameworksNames));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getInlayHints(@NotNull VirtualFile file, @NotNull ClangResultConsumer<List<ClangdInlayHint>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(26);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(27);
        }
        ClangResultImpl result = this.computeWithParsedInternal("getInlayHints", file, (wf, response) -> this.sendInlayHints(file));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    @NotNull
    public CompletableFuture<ClionFileStats> requestTimingStats(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(28);
        }
        CompletableFuture<ClionFileStats> result = new CompletableFuture<ClionFileStats>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("RequestTimingsStat").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionRequestTimingsStat(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file.getUrl()))).whenComplete((res, ex) -> result.complete((ClionFileStats)res)))).onSkipped(() -> result.complete(null)).onRejected(() -> result.complete(null)).requiresRecover().create());
        CompletableFuture<ClionFileStats> completableFuture = result;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(29);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<String> preprocess(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(30);
        }
        CompletableFuture completableFuture = this.myWorkspace.applyWithRead(file.getUrl(), wf -> {
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(wf.getUrl()));
            ClangPreprocessRequest request = new ClangPreprocessRequest(file.getUrl(), identifier);
            this.myRequestsPlanner.send(ClangPreprocessRequest.createPromise(this.myContext, request));
            return request.getResponse();
        });
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(31);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<String> requestClangFormatConfiguration(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(32);
        }
        return this.withOpenedFile(file, wf -> this.sendRequestClangFormatConfiguration(file));
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> formatRange(@NotNull VirtualFile file, @NotNull TextRange range, @Nullable String style) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(33);
        }
        if (range == null) {
            ClangdLanguageService.$$$reportNull$$$0(34);
        }
        CompletableFuture completableFuture = this.myWorkspace.applyWithRead(file.getUrl(), wf -> this.sendFormatRangeRequest(file, range, style));
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(35);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> indentLine(@NotNull VirtualFile file, int lineStartOffset, @Nullable String style) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(36);
        }
        CompletableFuture completableFuture = this.myWorkspace.applyWithRead(file.getUrl(), wf -> this.isAcceptable(file) ? this.sendIndentRequest(file, lineStartOffset, style) : CompletableFuture.completedFuture(null));
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(37);
        }
        return completableFuture;
    }

    @Override
    @Nullable
    public ClangParseResponse getParsed(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(38);
        }
        String url = file.getUrl();
        if (!this.myContext.getUrlConverter().isAcceptable(url)) {
            return null;
        }
        String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
        return this.myWorkspace.applyWithRead(Arrays.asList(url, macrosUrl), files -> {
            LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
            assert (workspaceFile != null) : "requested file must not be null!";
            LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
            assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
            return this.getOrParse(file, workspaceFile, macrosWorkspaceFile, null);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<List<CLionSymbolInformation>> getSymbols(@NotNull String query, boolean onlyStatic) {
        if (query == null) {
            ClangdLanguageService.$$$reportNull$$$0(39);
        }
        CompletableFuture<List<CLionSymbolInformation>> result = new CompletableFuture<List<CLionSymbolInformation>>();
        this.myRequestsPlanner.getServerAccessor().post(ClangInteraction.newInteraction("workspace/symbol").requiresRecover().action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionWorkspaceSymbol(new CLionWorkspaceSymbolParams(query, onlyStatic))))).onSkipped(() -> result.complete(Collections.emptyList())).onRejected(() -> result.complete(Collections.emptyList())).create());
        CompletableFuture<List<CLionSymbolInformation>> completableFuture = result;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(40);
        }
        return completableFuture;
    }

    @Override
    public <E extends Throwable> void runWithParsed(@NotNull VirtualFile file, @NotNull ThrowableConsumer<ClangParseResponse, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(41);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(42);
        }
        this.computeWithParsed(file, response -> {
            consumer.consume(response);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computeWithParsed(@NotNull VirtualFile file, @NotNull ThrowableFunction<ClangParseResponse, T, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(43);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(44);
        }
        Ref response = Ref.create();
        Ref usageID = Ref.create();
        try {
            ReadAction.run(() -> {
                String url = file.getUrl();
                if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                    return;
                }
                String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
                ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
                try {
                    this.myWorkspace.modify(Arrays.asList(url, macrosUrl), files -> {
                        LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
                        assert (workspaceFile != null) : "requested file must not be null!";
                        LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
                        assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
                        if (!workspaceFile.isOpened() && ClangDebugLevel.isWarnOrMore()) {
                            CidrLogService.logOnce((Level)Level.WARNING, (String)("Trying to parse closed file: " + workspaceFile.getUrl()), (Throwable)new Exception());
                        }
                        response.set((Object)this.getOrParse(file, workspaceFile, macrosWorkspaceFile, deferrer));
                        usageID.set((Object)this.trackParseUsage(workspaceFile, (ClangParseResponse)response.get()));
                    });
                }
                finally {
                    deferrer.runDeferred();
                }
            });
            T t = consumer.apply((ClangParseResponse)response.get());
            return t;
        }
        finally {
            if (!response.isNull() && !usageID.isNull()) {
                this.freeParseUsage((ClangParseResponse)response.get(), (Integer)usageID.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computeWithOpenedAndParsed(@NotNull VirtualFile file, @NotNull ThrowableFunction<ClangParseResponse, T, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(45);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(46);
        }
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "computeWithOpenedAndParsed for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            T t = this.computeWithParsed(file, consumer);
            return t;
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Throwable> void runWithOpenedAndParsed(@NotNull VirtualFile file, @NotNull ThrowableConsumer<ClangParseResponse, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(47);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(48);
        }
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "runWithOpenedAndParsed for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            this.runWithParsed(file, consumer);
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    @NotNull
    private <T> ClangResultImpl<T> computeWithParsedInternal(@NonNls @NotNull String title, @NotNull VirtualFile file, @NotNull BiFunction<LocalWorkspaceFile, ClangParseResponse, ClangASTBasedRequest<?, T>> consumer) {
        if (title == null) {
            ClangdLanguageService.$$$reportNull$$$0(49);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(50);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(51);
        }
        ClangResultImpl clangResultImpl = (ClangResultImpl)ReadAction.compute(() -> {
            String url = file.getUrl();
            if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                return new ClangResultImpl<Object>(title, CompletableFuture.completedFuture(null));
            }
            String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
            ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
            try {
                ClangResultImpl clangResultImpl = this.myWorkspace.apply(Arrays.asList(url, macrosUrl), files -> {
                    LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
                    assert (workspaceFile != null) : "requested file must not be null!";
                    LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
                    assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
                    ClangParseResponse response = this.getOrParse(file, workspaceFile, macrosWorkspaceFile, deferrer);
                    if (response != null) {
                        int parseUsageID = this.trackParseUsage(workspaceFile, response);
                        try {
                            ClangASTBasedRequest request = (ClangASTBasedRequest)consumer.apply(workspaceFile, response);
                            if (request != null) {
                                int reqUsageID = this.trackRequestUsage(workspaceFile, request);
                                return new ClangResultImpl(title, request.getResponse(), () -> {
                                    this.freeRequestUsage(request, reqUsageID);
                                    this.freeParseUsage(response, parseUsageID);
                                });
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.freeParseUsage(response, parseUsageID);
                    }
                    return new ClangResultImpl<Object>(title, CompletableFuture.completedFuture(null));
                });
                return clangResultImpl;
            }
            finally {
                deferrer.runDeferred();
            }
        });
        if (clangResultImpl == null) {
            ClangdLanguageService.$$$reportNull$$$0(52);
        }
        return clangResultImpl;
    }

    private static <T, E extends Throwable> void applyConsumer(@NotNull ClangResultConsumer<T, E> consumer, @NotNull ClangResultImpl<T> res) throws E {
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(53);
        }
        if (res == null) {
            ClangdLanguageService.$$$reportNull$$$0(54);
        }
        try {
            consumer.consume(res);
        }
        finally {
            res.release();
        }
    }

    private int trackParseUsage(@NotNull LocalWorkspaceFile wf, @Nullable ClangParseResponse response) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(55);
        }
        if (response == null) {
            return -1;
        }
        UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
        int ID = ++usages.nextID;
        usages.id2Stack.put(ID, this.debugTrackUsage((UserDataHolder)response));
        return ID;
    }

    private void freeParseUsage(@NotNull ClangParseResponse response, int usageID) {
        if (response == null) {
            ClangdLanguageService.$$$reportNull$$$0(56);
        }
        this.myWorkspace.modify(response.getUrl(), wf -> {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
            usages.id2Stack.remove(usageID);
            if (usages.id2Stack.isEmpty()) {
                this.debugFreeUsage((UserDataHolder)response);
                this.cancelParse((LocalWorkspaceFile)wf, response);
            }
        });
    }

    private int trackRequestUsage(@NotNull LocalWorkspaceFile wf, @NotNull ClangASTBasedRequest<?, ?> request) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(57);
        }
        if (request == null) {
            ClangdLanguageService.$$$reportNull$$$0(58);
        }
        assert (wf.getUrl().contentEquals(request.getAstFileUrl()));
        UsagesInfo usages = ClangdLanguageService.computeIfAbsent(request, USAGES_MAP, () -> new UsagesInfo());
        int ID = ++usages.nextID;
        usages.id2Stack.put(ID, this.debugTrackUsage((UserDataHolder)request));
        return ID;
    }

    private void freeRequestUsage(@NotNull ClangASTBasedRequest<?, ?> request, int usageID) {
        if (request == null) {
            ClangdLanguageService.$$$reportNull$$$0(59);
        }
        this.myWorkspace.modify(request.getAstFileUrl(), wf -> {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)request, USAGES_MAP, () -> new UsagesInfo());
            usages.id2Stack.remove(usageID);
            if (usages.id2Stack.isEmpty()) {
                this.debugFreeUsage((UserDataHolder)request);
                this.cancelRequest(request);
            }
        });
    }

    @Nullable
    private Exception debugTrackUsage(@NotNull UserDataHolder usedObject) {
        if (usedObject == null) {
            ClangdLanguageService.$$$reportNull$$$0(60);
        }
        if (Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            this.myDebugUsagesSet.add(usedObject);
            return new Exception();
        }
        return null;
    }

    private void debugFreeUsage(@NotNull UserDataHolder usedObject) {
        if (usedObject == null) {
            ClangdLanguageService.$$$reportNull$$$0(61);
        }
        if (Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            UsagesInfo usages = (UsagesInfo)usedObject.getUserData(USAGES_MAP);
            assert (usages != null && usages.id2Stack.isEmpty());
            this.myDebugUsagesSet.remove(usedObject);
        }
    }

    private static boolean isCanceled(@NotNull UserDataHolder something) {
        if (something == null) {
            ClangdLanguageService.$$$reportNull$$$0(62);
        }
        return something.getUserData(CANCELED_FLAG) != null;
    }

    private static void setCanceled(@NotNull UserDataHolder something) {
        if (something == null) {
            ClangdLanguageService.$$$reportNull$$$0(63);
        }
        something.putUserData(CANCELED_FLAG, (Object)true);
    }

    private void cancelParseGently(@NotNull LocalWorkspaceFile wf, @Nullable ClangParseResponse response) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(64);
        }
        if (response != null) {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
            if (usages.id2Stack.isEmpty()) {
                this.cancelParse(wf, response);
            }
        }
    }

    private void cancelParse(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse response) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(65);
        }
        if (response == null) {
            ClangdLanguageService.$$$reportNull$$$0(66);
        }
        if (response.isCancellable() && wf.getVersion() > response.getVersion() && !ClangParseResponse.areAnswersCompleted(response)) {
            this.sendCancelParse(wf, response);
        }
    }

    private void cancelRequest(@NotNull ClangAbstractRequest<?, ?> request) {
        if (request == null) {
            ClangdLanguageService.$$$reportNull$$$0(67);
        }
        if (!ClangdLanguageService.isCanceled(request) && !request.getResponse().isDone()) {
            this.myRequestsPlanner.sendImmediately(request.cancel());
            ClangdLanguageService.setCanceled(request);
        }
    }

    private void sendCancelParse(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse response) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(68);
        }
        if (response == null) {
            ClangdLanguageService.$$$reportNull$$$0(69);
        }
        if (!ClangdLanguageService.isCanceled((UserDataHolder)response)) {
            this.myRequestsPlanner.send(ClangCancelParseNotification.createPromise(this.myContext, response));
            ClangdLanguageService.setCanceled((UserDataHolder)response);
            ClangParseResponse.completeAnswersExceptionally(response, new CancellationException());
        }
    }

    @NotNull
    private static <T> T computeIfAbsent(@NotNull UserDataHolder holder, @NotNull Key<T> key, @NotNull Producer<T> producer) {
        Object data;
        if (holder == null) {
            ClangdLanguageService.$$$reportNull$$$0(70);
        }
        if (key == null) {
            ClangdLanguageService.$$$reportNull$$$0(71);
        }
        if (producer == null) {
            ClangdLanguageService.$$$reportNull$$$0(72);
        }
        if ((data = holder.getUserData(key)) == null) {
            data = producer.produce();
            assert (data != null);
            holder.putUserData(key, data);
        }
        Object object = data;
        if (object == null) {
            ClangdLanguageService.$$$reportNull$$$0(73);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public ClangLocalWorkspace getLocalWorkspace() {
        ClangLocalWorkspace clangLocalWorkspace = this.myWorkspace;
        if (clangLocalWorkspace == null) {
            ClangdLanguageService.$$$reportNull$$$0(74);
        }
        return clangLocalWorkspace;
    }

    @Override
    @NotNull
    public String getClangdModulesPath() {
        String string = this.myContext.getClangdModulesPath();
        if (string == null) {
            ClangdLanguageService.$$$reportNull$$$0(75);
        }
        return string;
    }

    @Override
    public boolean isIndexer() {
        return this.myContext.isIndexer();
    }

    @Override
    @NotNull
    public CompletableFuture<ClangPreprocessedReport> generatePreprocessedReport(@NotNull List<String> urls) {
        if (urls == null) {
            ClangdLanguageService.$$$reportNull$$$0(76);
        }
        CompletableFuture<ClangPreprocessedReport> result = new CompletableFuture<ClangPreprocessedReport>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("CrashReport").action((server, ws) -> {
            ArrayList<CompletionStage> crashReportFutures = new ArrayList<CompletionStage>();
            for (String url : urls) {
                ClionReparseTextDocumentParams cc = ws.getReparseParams(url);
                String macros = StringUtil.notNullize((String)ws.getContent(ClangRequestsHelper.getMacrosFileUrl(this.myContext, url)));
                if (cc != null) {
                    ClangParseResponse lastParseResponse = this.myContext.getLocalWorkspace().apply(url, wf -> wf.getLastParseResponse());
                    crashReportFutures.add(((CompletableFuture)server.clionPreprocessFile(cc.getCompilationCommand()).thenApply(res -> ClangdLanguageService.createPreprocessedFile(this.myContext.getUrlConverter().fromUri(url), cc, macros, lastParseResponse, res, null))).exceptionally(ex -> ClangdLanguageService.createPreprocessedFile(this.myContext.getUrlConverter().fromUri(url), cc, macros, lastParseResponse, null, ex)));
                    continue;
                }
                LOG.warn("Failed to get compilation command for previously parsed file " + url);
            }
            CompletableFuture.allOf(crashReportFutures.toArray(new CompletableFuture[0])).whenComplete((res, ex) -> {
                if (ex != null) {
                    LOG.warn("Failed to generate crash reports!", ex);
                    result.complete(null);
                    return;
                }
                try {
                    ArrayList<ClangPreprocessedReport.PreprocessedFile> crashReports = new ArrayList<ClangPreprocessedReport.PreprocessedFile>();
                    for (CompletableFuture reportFuture : crashReportFutures) {
                        assert (reportFuture.isDone());
                        ClangPreprocessedReport.PreprocessedFile file = (ClangPreprocessedReport.PreprocessedFile)reportFuture.get();
                        if (file == null) continue;
                        crashReports.add(file);
                    }
                    result.complete(new ClangPreprocessedReport(crashReports));
                }
                catch (InterruptedException | ExecutionException ee) {
                    LOG.warn((Throwable)ee);
                    result.complete(null);
                }
            });
        }).requiresRecover().onSkipped(() -> result.complete(null)).onRejected(() -> result.complete(null)).create());
        CompletableFuture<ClangPreprocessedReport> completableFuture = result;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(77);
        }
        return completableFuture;
    }

    private static @Nullable ClangPreprocessedReport.PreprocessedFile createPreprocessedFile(@NotNull String path, @NotNull ClionReparseTextDocumentParams cc, @NotNull String macros, @Nullable ClangParseResponse lastParseReponse, @Nullable CLionClangPreprocessResult ppRes, @Nullable Throwable ex) {
        List lastDiagsList;
        Supplier lastDiagsSupplier;
        if (path == null) {
            ClangdLanguageService.$$$reportNull$$$0(78);
        }
        if (cc == null) {
            ClangdLanguageService.$$$reportNull$$$0(79);
        }
        if (macros == null) {
            ClangdLanguageService.$$$reportNull$$$0(80);
        }
        if (ppRes == null && ex == null) {
            return null;
        }
        String lastDiags = null;
        if (lastParseReponse != null && (lastDiagsSupplier = (Supplier)CidrConcurrentUtilsKt.getIfCompletedNormally(lastParseReponse.getDiagnostics())) != null && (lastDiagsList = (List)lastDiagsSupplier.get()) != null) {
            StringBuilder lastDiagsBuilder = new StringBuilder();
            for (ClangDiagnostic lastDiag : lastDiagsList) {
                lastDiagsBuilder.append(lastDiag.toString()).append("\n");
            }
            lastDiags = lastDiagsBuilder.toString();
        }
        String clangTidyConfig = "";
        String clionClangTidyConfig = "";
        if (cc.getClangTidyOptions() != null) {
            clangTidyConfig = StringUtil.notNullize((String)cc.getClangTidyOptions().getConfig());
            clionClangTidyConfig = StringUtil.notNullize((String)cc.getClangTidyOptions().getClionConfig());
        }
        String clazyConfig = "";
        if (cc.getClazyOptions() != null) {
            clazyConfig = StringUtil.notNullize((String)cc.getClazyOptions().getConfig());
        }
        boolean namehintsEnabled = cc.getClangNamehintOptions() != null && cc.getClangNamehintOptions().isEnableNamehints();
        UnusedIncludesInspectionMode uiMode = cc.getUnusedIncludesInspectionMode() != null ? cc.getUnusedIncludesInspectionMode() : UnusedIncludesInspectionMode.Off;
        String diags = ppRes != null ? ppRes.getDiags() : "";
        String ppBody = ppRes != null ? ppRes.getPpOutput() : ExceptionUtil.getThrowableText((Throwable)ex);
        return new ClangPreprocessedReport.PreprocessedFile(path, lastDiags, cc.getCompilationCommand().getCommandLine(), clangTidyConfig, clionClangTidyConfig, clazyConfig, namehintsEnabled, cc.getDFAOptions(), uiMode, diags, ppBody, macros);
    }

    @Override
    @NotNull
    public ClangStopData stop() {
        ClangUtils.warnClangd(LOG, "Stopping " + this.getClass().getSimpleName() + "\n" + this.myContext.getLocalWorkspace().printStats("  ") + this.myContext.getCrashHandler().printStats("  Blacklist: "));
        Disposer.dispose((Disposable)this.myContext);
        ClangStopData clangStopData = this.myRequestsPlanner.stop();
        if (clangStopData == null) {
            ClangdLanguageService.$$$reportNull$$$0(81);
        }
        return clangStopData;
    }

    @Override
    public int getVersion(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(82);
        }
        return this.myWorkspace.apply(file.getUrl(), wf -> wf.getVersion());
    }

    @Override
    @NotNull
    public CompletableFuture<ClionPublishDiagnosticsParams> checkPreprocessedCase(@NotNull File crashCase, @NotNull FullCompilationInfo ccInfo) {
        if (crashCase == null) {
            ClangdLanguageService.$$$reportNull$$$0(83);
        }
        if (ccInfo == null) {
            ClangdLanguageService.$$$reportNull$$$0(84);
        }
        ClangUrlConverter conv = this.myContext.getUrlConverter();
        String crashCaseUri = conv.toUri(crashCase.getPath());
        CLionCheckPreprocessedCaseParams params = new CLionCheckPreprocessedCaseParams(crashCaseUri, new ClionReparseTextDocumentParams(new VersionedTextDocumentIdentifier(crashCaseUri, Integer.valueOf(1)), new ClionCompileCommandParams(conv.toUri(ccInfo.targetFile), conv.toUri(ccInfo.entryFile), new File(ccInfo.entryFile).getParent(), ccInfo.compilationCommand, "/dev/null"), new ClionClangTidyConfigParams(ccInfo.ourClangTidyConfig, ccInfo.clangTidyConfig, false), new ClionClangNamehintConfigParams(ccInfo.namehints, true, true, true, true), ccInfo.unusedMode, new CLionClazyConfigParams(ccInfo.clazyConfig), ClionWantDiagnostics.Yes, ccInfo.dfaOptions, ccInfo.globalCompletionCacheParams));
        CompletableFuture<ClionPublishDiagnosticsParams> result = new CompletableFuture<ClionPublishDiagnosticsParams>();
        this.myRequestsPlanner.getServerAccessor().post(ClangInteraction.newInteraction("checkPreprocessedCase").requiresRecover().action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionCheckPreprocessedCase(params)))).onRejected(() -> result.complete(null)).onSkipped(() -> result.complete(null)).create());
        CompletableFuture<ClionPublishDiagnosticsParams> completableFuture = result;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(85);
        }
        return completableFuture;
    }

    @Override
    public boolean notifyDocumentOpened(@NotNull VirtualFile file, @NotNull OpenRequestId openRequestId) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(86);
        }
        if (openRequestId == null) {
            ClangdLanguageService.$$$reportNull$$$0(87);
        }
        return this.myWorkspace.applyWithRead(file.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return false;
            }
            ClangdLanguageService.addOpenRequest(wf, openRequestId);
            if (!wf.isOpened()) {
                int nextVersion = wf.nextOpen();
                this.myRequestsPlanner.send(ClangOpenNotification.createPromise(this.myContext, file, nextVersion));
            }
            return true;
        });
    }

    private static void addOpenRequest(@NotNull LocalWorkspaceFile wf, @NotNull OpenRequestId id) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(88);
        }
        if (id == null) {
            ClangdLanguageService.$$$reportNull$$$0(89);
        }
        Map<OpenRequestId, Integer> openRequests = wf.getOrDefault(OPEN_REQUESTS);
        if (id.ignoreSame()) {
            openRequests.putIfAbsent(id, 1);
        } else {
            openRequests.merge(id, 1, Integer::sum);
        }
    }

    @Override
    public void notifyDocumentClosed(@NotNull VirtualFile file, @NotNull OpenRequestId openRequestId) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(90);
        }
        if (openRequestId == null) {
            ClangdLanguageService.$$$reportNull$$$0(91);
        }
        String url = file.getUrl();
        if (!this.myContext.getUrlConverter().isAcceptable(url)) {
            return;
        }
        String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
        this.myWorkspace.modifyWithRead(Arrays.asList(url, macrosUrl), files -> {
            LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
            assert (workspaceFile != null) : "requested file must not be null!";
            LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
            assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
            if (!this.isAcceptable(file)) {
                return;
            }
            if (!workspaceFile.isOpened()) {
                return;
            }
            if (ClangdLanguageService.removeOpenRequest(workspaceFile, openRequestId)) {
                boolean isSaved = !this.myIdeFacade.isModified(file);
                ClangFileFacade helper = this.myIdeFacade.getFileFacade(file);
                String content = helper != null ? helper.getText().toString() : "";
                int nextVersion = workspaceFile.nextClose();
                this.myRequestsPlanner.send(ClangCloseNotification.createPromise(this.myContext, workspaceFile.getUrl(), nextVersion, content, isSaved));
                if (macrosWorkspaceFile.getVersion() >= 0) {
                    this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, macrosWorkspaceFile.getUrl(), macrosWorkspaceFile.nextDelete()));
                }
            }
        });
    }

    @NotNull
    private static CharSequence notNullize(@Nullable CharSequence seq) {
        return seq != null ? seq : "";
    }

    private static boolean removeOpenRequest(@NotNull LocalWorkspaceFile wf, @NotNull OpenRequestId id) {
        Map<OpenRequestId, Integer> openRequests;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(92);
        }
        if (id == null) {
            ClangdLanguageService.$$$reportNull$$$0(93);
        }
        if ((openRequests = wf.get(OPEN_REQUESTS)).containsKey(id)) {
            openRequests.merge(id, -1, (oldV, newV) -> oldV + newV > 0 ? Integer.valueOf(oldV + newV) : null);
            return openRequests.isEmpty();
        }
        return false;
    }

    @Override
    public void notifyDocumentChanged(@NotNull VirtualFile file, @NotNull DocumentEvent event) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(94);
        }
        if (event == null) {
            ClangdLanguageService.$$$reportNull$$$0(95);
        }
        this.myWorkspace.modifyWithRead(file.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return;
            }
            int nextVersion = wf.nextChange();
            DidChangeTextDocumentParams params = this.prepareChangeParams(wf.getUrl(), nextVersion, event, file);
            boolean isSaved = !this.myIdeFacade.isModified(file);
            this.myRequestsPlanner.send(ClangChangeNotification.createPromise(this.myContext, wf.getUrl(), nextVersion, params, isSaved));
        });
    }

    @NotNull
    private DidChangeTextDocumentParams prepareChangeParams(@NotNull String url, int version, @NotNull DocumentEvent event, @NotNull VirtualFile file) {
        if (url == null) {
            ClangdLanguageService.$$$reportNull$$$0(96);
        }
        if (event == null) {
            ClangdLanguageService.$$$reportNull$$$0(97);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(98);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TextDocumentSyncKind syncKind = TextDocumentSyncKind.None;
        ServerCapabilities serverCapabilities = this.myRequestsPlanner.getServerAccessor().getCapabilities();
        if (serverCapabilities != null) {
            syncKind = serverCapabilities.getTextDocumentSync().isLeft() ? (TextDocumentSyncKind)serverCapabilities.getTextDocumentSync().getLeft() : ((TextDocumentSyncOptions)serverCapabilities.getTextDocumentSync().getRight()).getChange();
        }
        Document document = event.getDocument();
        TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
        switch (syncKind) {
            case Incremental: {
                changeEvent.setText(ClangdLanguageService.notNullize(this.myIdeFacade.getFileFacade(file, document).getText()).toString());
                break;
            }
            case None: 
            case Full: {
                changeEvent.setText(document.getText());
            }
        }
        VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
        docId.setUri(this.myContext.getUrlConverter().toUri(url));
        docId.setVersion(Integer.valueOf(version));
        return new DidChangeTextDocumentParams(docId, Collections.singletonList(changeEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReparseRequired(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(99);
        }
        ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
        try {
            String url = file.getUrl();
            if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                return;
            }
            String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
            this.myWorkspace.modifyWithRead(Arrays.asList(url, macrosUrl), files -> {
                LocalWorkspaceFile wf = (LocalWorkspaceFile)files.get(url);
                assert (wf != null) : "requested file must not be null!";
                LocalWorkspaceFile macrosWf = (LocalWorkspaceFile)files.get(macrosUrl);
                assert (macrosWf != null) : "requested macros file must not be null!";
                this.notifyReparseRequiredImpl(file, wf, macrosWf, deferrer);
            });
        }
        finally {
            deferrer.runDeferred();
        }
    }

    @Nullable
    private ClangParseResponse notifyReparseRequiredImpl(@NotNull VirtualFile file, @NotNull LocalWorkspaceFile workspaceFile, @NotNull LocalWorkspaceFile macrosWorkspaceFile, @NotNull ClangHeavyRequestBuilder deferrer) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(100);
        }
        if (workspaceFile == null) {
            ClangdLanguageService.$$$reportNull$$$0(101);
        }
        if (macrosWorkspaceFile == null) {
            ClangdLanguageService.$$$reportNull$$$0(102);
        }
        if (deferrer == null) {
            ClangdLanguageService.$$$reportNull$$$0(103);
        }
        if (this.myContext.getProject().isDisposed()) {
            ClangUtils.warnClangd(LOG, "Will not reparse file " + file.getName() + " because project is already disposed.");
            return null;
        }
        if (!this.isAcceptable(file)) {
            ClangUtils.warnClangd(LOG, "Cannot reparse because file " + file.getName() + " is not acceptable.");
            return null;
        }
        if (!workspaceFile.isOpened()) {
            ClangUtils.warnClangd(LOG, "Cannot reparse because file " + file.getName() + " is not opened locally.");
            return null;
        }
        ClangParseResponse prevResponse = workspaceFile.getLastParseResponse();
        ClangParseResponse response = workspaceFile.nextParse(file, true);
        response.putUserData(ClangParseResponse.PSI_GLOBAL_MODIFICATION_COUNTER, this.myIdeFacade.getPsiModificationCounter(this.myProject));
        this.cancelParseGently(workspaceFile, prevResponse);
        String macrosUrl = macrosWorkspaceFile.getUrl();
        int macrosVersion = macrosWorkspaceFile.nextChange();
        this.myRequestsPlanner.send(ClangReparseNotification.createPromise(deferrer, this.myContext, file, response, macrosUrl, macrosVersion));
        return response;
    }

    @Override
    public void notifyDocumentSaved(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(104);
        }
        this.myWorkspace.modifyWithRead(file.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return;
            }
            this.myRequestsPlanner.send(ClangSaveRequest.createPromise(this.myContext, wf.getUrl()));
        });
    }

    @Override
    @NotNull
    public CompletableFuture<List<? extends ClangCommandLineArgument>> parseCommandLine(@NotNull List<String> switches, @Nullable EnumSet<ClangOptionsFlags> flagsToInclude, @Nullable EnumSet<ClangOptionsFlags> flagsToExclude) {
        if (switches == null) {
            ClangdLanguageService.$$$reportNull$$$0(105);
        }
        ClangCommandLine commandLine = new ClangCommandLine(switches, ClangdLanguageService.flagsEnumSetToBitField(flagsToInclude), ClangdLanguageService.flagsEnumSetToBitField(flagsToExclude));
        ClangParseCommandLineRequest request = new ClangParseCommandLineRequest(commandLine);
        this.myRequestsPlanner.send(ClangParseCommandLineRequest.Companion.createPromise(request));
        CompletableFuture<List<? extends ClangCommandLineArgument>> completableFuture = request.getResponse();
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(106);
        }
        return completableFuture;
    }

    private static int flagsEnumSetToBitField(@Nullable EnumSet<ClangOptionsFlags> flags) {
        if (flags == null) {
            return 0;
        }
        int bitField = 0;
        for (ClangOptionsFlags flag : flags) {
            bitField |= flag.getValue();
        }
        return bitField;
    }

    @Override
    public void notifyDocumentMoved(@NotNull VirtualFile newFile, @NotNull String oldUrl, @NotNull String newUrl) {
        if (newFile == null) {
            ClangdLanguageService.$$$reportNull$$$0(107);
        }
        if (oldUrl == null) {
            ClangdLanguageService.$$$reportNull$$$0(108);
        }
        if (newUrl == null) {
            ClangdLanguageService.$$$reportNull$$$0(109);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (newUrl.contentEquals(newFile.getUrl()));
        if (oldUrl.contentEquals(newUrl)) {
            return;
        }
        String oldMacrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, oldUrl);
        this.myWorkspace.modifyWithRead(Arrays.asList(oldUrl, newUrl, oldMacrosUrl), mapOfFiles -> {
            LocalWorkspaceFile oldWf = (LocalWorkspaceFile)mapOfFiles.get(oldUrl);
            LocalWorkspaceFile oldMacrosWf = (LocalWorkspaceFile)mapOfFiles.get(oldMacrosUrl);
            LocalWorkspaceFile newWf = (LocalWorkspaceFile)mapOfFiles.get(newUrl);
            ApplicationManager.getApplication().assertReadAccessAllowed();
            boolean oldIsAcceptable = oldWf.getVersion() > 0;
            boolean oldIsOpened = oldWf.isOpened();
            boolean newIsAcceptable = this.isAcceptable(newFile);
            if (oldIsAcceptable && newIsAcceptable) {
                if (oldIsOpened) {
                    Map<OpenRequestId, Integer> newOpenRequests = newWf.getOrDefault(OPEN_REQUESTS);
                    Map<OpenRequestId, Integer> oldOpenRequests = oldWf.getOrDefault(OPEN_REQUESTS);
                    oldOpenRequests.forEach((id, counter) -> newOpenRequests.merge((OpenRequestId)id, (Integer)counter, Integer::sum));
                    oldOpenRequests.clear();
                    this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                    this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, oldMacrosWf.getUrl(), oldMacrosWf.nextDelete()));
                    this.myRequestsPlanner.send(ClangOpenNotification.createPromise(this.myContext, newFile, newWf.nextOpen()));
                } else {
                    this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                    this.sendContent(newWf, newFile);
                }
            } else if (oldIsAcceptable) {
                Map<OpenRequestId, Integer> oldEditors = oldWf.getOrDefault(OPEN_REQUESTS);
                oldEditors.clear();
                this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                if (oldIsOpened) {
                    this.myRequestsPlanner.send(ClangDeleteNotification.createPromise(this.myContext, oldMacrosWf.getUrl(), oldMacrosWf.nextDelete()));
                }
            } else if (newIsAcceptable) {
                List<OpenRequestId> openRequests = this.myIdeFacade.getOpenRequests(this.myProject, newFile);
                for (OpenRequestId openRequest : openRequests) {
                    this.notifyDocumentOpened(newFile, openRequest);
                }
                if (!newWf.isOpened() && this.myIdeFacade.isModified(newFile)) {
                    this.sendContent(newWf, newFile);
                }
            }
        });
    }

    @Override
    public void notifySetCDB(@NotNull Collection<VirtualFile> forFiles) {
        if (forFiles == null) {
            ClangdLanguageService.$$$reportNull$$$0(110);
        }
        ArrayList<ClionCompileCommandParams> commands = new ArrayList<ClionCompileCommandParams>();
        ArrayList<String> macrosPaths = new ArrayList<String>();
        ArrayList<String> macrosContents = new ArrayList<String>();
        for (VirtualFile file : forFiles) {
            String macrosPath;
            ClangUrlConverter urlConv = this.myContext.getUrlConverter();
            ClangdCompilationCommand command = this.myIdeFacade.getCompilationCommand(urlConv, this.myProject, file, macrosPath = urlConv.fromUri(urlConv.toUri(ClangRequestsHelper.getMacrosFileUrl(this.myContext, file.getUrl()))));
            if (command == null) continue;
            commands.add(command.ccParams);
            macrosPaths.add(macrosPath);
            macrosContents.add(command.ppDefines);
        }
        ClionSetCDBParams newCDB = new ClionSetCDBParams(commands, macrosPaths, macrosContents);
        this.myRequestsPlanner.sendImmediately(new ClangSetCDBNotification(newCDB));
    }

    @Override
    public void notifyLoadIndex(@NotNull String path) {
        if (path == null) {
            ClangdLanguageService.$$$reportNull$$$0(111);
        }
        this.myRequestsPlanner.sendImmediately(new ClangReloadIndexNotification(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(path))));
    }

    @Override
    public void notifyLoadGraph(@NotNull String path) {
        if (path == null) {
            ClangdLanguageService.$$$reportNull$$$0(112);
        }
        this.myRequestsPlanner.sendImmediately(new ClangReloadGraphNotification(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(path))));
    }

    @Nullable
    public Endpoint remoteEndpoint() {
        return this.myRequestsPlanner.getServerAccessor().getRemoteEndpoint();
    }

    @Nullable
    public ServerConnection serverConnection() {
        return this.myRequestsPlanner.getServerAccessor().getServerConnection();
    }

    @Override
    @NotNull
    public ClangStopData shutDownServer() {
        ClangStopData clangStopData = this.myRequestsPlanner.getServerAccessor().shutDown();
        if (clangStopData == null) {
            ClangdLanguageService.$$$reportNull$$$0(113);
        }
        return clangStopData;
    }

    @Override
    public boolean isFileBanned(@NotNull String url) {
        if (url == null) {
            ClangdLanguageService.$$$reportNull$$$0(114);
        }
        return !ClangRequestsHelper.isAllowedByGuard(this.myContext, url);
    }

    @Override
    public void debugDumpServerState() {
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("DumpServerState").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionDumpServerState())).create());
    }

    @Override
    public String debugDumpUsages(@NotNull String url) {
        if (url == null) {
            ClangdLanguageService.$$$reportNull$$$0(115);
        }
        if (!Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            return "Did you forgot to turn on 'clion.clang.clangd.debug.cancellation'?\n";
        }
        BiConsumer<StringBuilder, UserDataHolder> usagesDumper = (sb, usedObject) -> {
            if (sb == null) {
                ClangdLanguageService.$$$reportNull$$$0(167);
            }
            if (usedObject == null) {
                ClangdLanguageService.$$$reportNull$$$0(168);
            }
            UsagesInfo usages = (UsagesInfo)usedObject.getUserData(USAGES_MAP);
            sb.append("usage counter = ").append(usages != null ? usages.id2Stack.size() : 0).append("\n");
            if (usages != null && !usages.id2Stack.isEmpty()) {
                usages.id2Stack.values().forEach(ex -> {
                    sb.append("=== Usage:");
                    if (ex != null) {
                        StackTraceElement[] stackTrace = ex.getStackTrace();
                        for (int i2 = 0; i2 < Math.min(stackTrace.length, 20); ++i2) {
                            StackTraceElement trace = stackTrace[i2];
                            sb.append("  ").append(trace.toString()).append("\n");
                        }
                    } else {
                        sb.append(" stack trace is not available. Did you forgot to turn on 'clion.clang.clangd.debug.cancellation'?\n");
                    }
                });
            }
        };
        return this.myWorkspace.apply(url, wf -> {
            StringBuilder sb = new StringBuilder();
            Set<UserDataHolder> set = this.myDebugUsagesSet;
            synchronized (set) {
                for (UserDataHolder holder : this.myDebugUsagesSet) {
                    if (holder instanceof ClangParseResponse) {
                        ClangParseResponse response = (ClangParseResponse)holder;
                        sb.append("Parse ").append(response.getVersion()).append(": ").append(ClangdLanguageService.isCanceled((UserDataHolder)response) ? "canceled" : "not canceled").append(", ").append(response.isCancellable() ? "cancellable" : "not cancellable").append(", ").append(ClangParseResponse.areAnswersCompleted(response) ? "completed" : "not completed").append(", ");
                        usagesDumper.accept(sb, (UserDataHolder)response);
                        continue;
                    }
                    if (!(holder instanceof ClangASTBasedRequest)) continue;
                    ClangASTBasedRequest request = (ClangASTBasedRequest)holder;
                    sb.append(request.getClass().getSimpleName()).append(": ").append(ClangdLanguageService.isCanceled((UserDataHolder)request) ? "canceled" : "not canceled").append(", ").append(request.getResponse().isDone() ? "completed" : "not completed").append(", ");
                    usagesDumper.accept(sb, (UserDataHolder)request);
                }
            }
            return sb.toString();
        });
    }

    @Override
    @NotNull
    public CompletableFuture<ClangMemoryUsageInfo> debugDumpMemoryStat() {
        CompletableFuture<ClangMemoryUsageInfo> answer = new CompletableFuture<ClangMemoryUsageInfo>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("DumpMemoryStat").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionDebugDumpMemoryStat().whenComplete((info, ex) -> {
            if (ex != null) {
                answer.completeExceptionally((Throwable)ex);
                return;
            }
            ClangMemoryUsageInfo memoryUsageInfo = new ClangMemoryUsageInfo(info.getWorkingSet(), info.getDrafts(), info.getUnsaved(), ContainerUtil.map(info.getPerFile(), p -> new ClangMemoryUsageInfo.PerFile(p.getPath(), p.getKb())));
            answer.complete(memoryUsageInfo);
            this.myIdeFacade.sendMessageLater(() -> {
                if (this.myContext.canPublishMessage()) {
                    ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onMemoryUsageInfoReceived(memoryUsageInfo);
                }
            });
        }))).onSkipped(() -> answer.complete(null)).onRejected(() -> answer.complete(null)).create());
        CompletableFuture<ClangMemoryUsageInfo> completableFuture = answer;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(116);
        }
        return completableFuture;
    }

    @Override
    public void debugCrashServer() {
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("CrashServer").action((Consumer<? super ClangServer>)((Consumer)server -> {
            server.shutdown();
            server.exit();
        })).create());
    }

    @Override
    public void waitUntilTasksFinished() {
        if (this.isActive()) {
            this.myRequestsPlanner.waitUntilTasksFinished();
        }
    }

    @Override
    public int getServerPid() {
        return ClangLanguageServiceUtils.getServerPid(this.serverConnection());
    }

    @Override
    @NonNls
    @NotNull
    public String getNativeStacktrace() {
        String string = ClangLanguageServiceUtils.getNativeStacktrace(this.serverConnection());
        if (string == null) {
            ClangdLanguageService.$$$reportNull$$$0(117);
        }
        return string;
    }

    @NotNull
    private <T> CompletableFuture<T> withOpenedFile(@NotNull VirtualFile file, @NotNull Function<LocalWorkspaceFile, CompletableFuture<T>> consumer) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(118);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(119);
        }
        CompletableFuture completableFuture = this.myWorkspace.applyWithRead(file.getUrl(), wf -> {
            if (!wf.isOpened()) {
                return CompletableFuture.completedFuture(null);
            }
            return (CompletableFuture)consumer.apply((LocalWorkspaceFile)wf);
        });
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(120);
        }
        return completableFuture;
    }

    @Nullable
    private ClangParseResponse getOrParse(@NotNull VirtualFile file, @NotNull LocalWorkspaceFile workspaceFile, @NotNull LocalWorkspaceFile macrosWorkspaceFile, @Nullable ClangHeavyRequestBuilder deferrer) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(121);
        }
        if (workspaceFile == null) {
            ClangdLanguageService.$$$reportNull$$$0(122);
        }
        if (macrosWorkspaceFile == null) {
            ClangdLanguageService.$$$reportNull$$$0(123);
        }
        if (!workspaceFile.isOpened()) {
            return null;
        }
        ClangParseResponse reparsedFile = workspaceFile.getLastParseResponse();
        if (reparsedFile != null) {
            if (reparsedFile.getVersion() < workspaceFile.getVersion()) {
                reparsedFile = null;
            } else if (ClangdLanguageService.isCanceled((UserDataHolder)reparsedFile)) {
                reparsedFile = null;
            } else if (ClangParseResponse.isInFailedState(reparsedFile)) {
                reparsedFile = null;
            } else {
                Long lastReparsedAtCounter = (Long)reparsedFile.getUserData(ClangParseResponse.PSI_GLOBAL_MODIFICATION_COUNTER);
                Long currentCounter = this.myIdeFacade.getPsiModificationCounter(this.myProject);
                if (currentCounter != null && lastReparsedAtCounter != null && currentCounter > lastReparsedAtCounter) {
                    reparsedFile = null;
                }
            }
        }
        if (reparsedFile == null && deferrer != null) {
            reparsedFile = this.notifyReparseRequiredImpl(file, workspaceFile, macrosWorkspaceFile, deferrer);
        }
        return reparsedFile;
    }

    @Nullable
    private ClangGotoDefinitionRequest sendGotoDefinition(@NotNull ClangParseResponse reparse, @NotNull VirtualFile file, int offset) {
        if (reparse == null) {
            ClangdLanguageService.$$$reportNull$$$0(124);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(125);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GotoDefinitionKey requestCacheKey = new GotoDefinitionKey(reparse, offset);
        ClangGotoDefinitionRequest cachedAnswer = (ClangGotoDefinitionRequest)this.myGotoDefinitionCache.getIfPresent((Object)requestCacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Pair paramsAndRange = this.findLine(file, offset, (text, lineColumn) -> {
            TextDocumentIdentifier textDocIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file.getUrl()));
            Position position = new Position(lineColumn.line, lineColumn.column);
            TextDocumentPositionParams params = new TextDocumentPositionParams(textDocIdent, position);
            return Pair.create((Object)params, (Object)ClangUtils.findIdentifierRange(text, offset));
        });
        if (paramsAndRange == null) {
            return null;
        }
        ClangGotoDefinitionRequest gotoRequest = new ClangGotoDefinitionRequest(this.myContext, (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(ClangGotoDefinitionRequest.createPromise(this.myContext, gotoRequest));
        TextRange range = (TextRange)paramsAndRange.second;
        if (range != null) {
            for (int cacheOffset = range.getStartOffset(); cacheOffset < range.getEndOffset(); ++cacheOffset) {
                this.myGotoDefinitionCache.put((Object)new GotoDefinitionKey(reparse, cacheOffset), (Object)gotoRequest);
            }
        } else {
            this.myGotoDefinitionCache.put((Object)requestCacheKey, (Object)gotoRequest);
        }
        return gotoRequest;
    }

    @Nullable
    private ClangClionLineMarkersRequest sendClionLineMarkers(@NotNull VirtualFile file, int fromOffset, int toOffset, boolean fast) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(126);
        }
        LineMarkersKey lineMarkersCacheKey = new LineMarkersKey(file.getUrl(), fromOffset, toOffset, fast);
        ClangClionLineMarkersRequest cachedAnswer = (ClangClionLineMarkersRequest)this.myContentDependentCache.getLineMarkersCache().get(lineMarkersCacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Document document = this.myContext.getIdeFacade().getDocument(file);
        if (document == null) {
            return null;
        }
        TextDocumentIdentifier docIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file.getUrl()));
        Range lspRange = ClangLanguageServiceUtils.offsets2Range(document, fromOffset, toOffset);
        ClangInteractionPromise<ClangClionLineMarkersRequest> promise = ClangClionLineMarkersRequest.createPromise(this.myContext, docIdent, lspRange, fast);
        ClangClionLineMarkersRequest request = (ClangClionLineMarkersRequest)CidrConcurrentUtilsKt.getIfCompletedNormally(promise.getInteraction());
        assert (request != null);
        this.myRequestsPlanner.send(promise);
        this.myContentDependentCache.getLineMarkersCache().put(lineMarkersCacheKey, request);
        return request;
    }

    @Nullable
    private ClangTestLineMarkersRequest sendClionTestLineMarkers(@NotNull VirtualFile file, @NotNull List<String> enabledFrameworkNames) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(127);
        }
        if (enabledFrameworkNames == null) {
            ClangdLanguageService.$$$reportNull$$$0(128);
        }
        TestLineMarkersKey cacheKey = new TestLineMarkersKey(file.getUrl(), enabledFrameworkNames);
        ClangTestLineMarkersRequest cachedAnswer = (ClangTestLineMarkersRequest)this.myContentDependentCache.getTestLineMarkersCache().get(cacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Document document = this.myContext.getIdeFacade().getDocument(file);
        if (document == null) {
            return null;
        }
        TextDocumentIdentifier docIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file.getUrl()));
        ClangInteractionPromise<ClangTestLineMarkersRequest> promise = ClangTestLineMarkersRequest.createPromise(this.myContext, docIdent, enabledFrameworkNames);
        ClangTestLineMarkersRequest request = (ClangTestLineMarkersRequest)CidrConcurrentUtilsKt.getIfCompletedNormally(promise.getInteraction());
        assert (request != null);
        this.myRequestsPlanner.send(promise);
        this.myContentDependentCache.getTestLineMarkersCache().put(cacheKey, request);
        return request;
    }

    @NotNull
    private ClangInlayHintsRequest sendInlayHints(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(129);
        }
        InlayHintsKey cacheKey = new InlayHintsKey(file.getUrl());
        ClangInlayHintsRequest cachedAnswer = (ClangInlayHintsRequest)this.myContentDependentCache.getInlayHintsCache().get(cacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            ClangInlayHintsRequest clangInlayHintsRequest = cachedAnswer;
            if (clangInlayHintsRequest == null) {
                ClangdLanguageService.$$$reportNull$$$0(130);
            }
            return clangInlayHintsRequest;
        }
        TextDocumentIdentifier docIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file.getUrl()));
        ClangInteractionPromise<ClangInlayHintsRequest> promise = ClangInlayHintsRequest.createPromise(this.myContext, docIdent);
        ClangInlayHintsRequest request = (ClangInlayHintsRequest)CidrConcurrentUtilsKt.getIfCompletedNormally(promise.getInteraction());
        assert (request != null);
        this.myRequestsPlanner.send(promise);
        this.myContentDependentCache.getInlayHintsCache().put(cacheKey, request);
        ClangInlayHintsRequest clangInlayHintsRequest = request;
        if (clangInlayHintsRequest == null) {
            ClangdLanguageService.$$$reportNull$$$0(131);
        }
        return clangInlayHintsRequest;
    }

    @Nullable
    private ClangDumpASTRequest sendDumpAST(@NotNull ClangParseResponse reparse, @NotNull VirtualFile file, int offset) {
        TextDocumentPositionParams params;
        if (reparse == null) {
            ClangdLanguageService.$$$reportNull$$$0(132);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(133);
        }
        if ((params = this.toTextDocumentPositionParams(file, offset)) == null) {
            return null;
        }
        ClangDumpASTRequest dumpASTRequest = new ClangDumpASTRequest(reparse.getUrl(), params);
        this.myRequestsPlanner.send(ClangDumpASTRequest.create(this.myContext, dumpASTRequest));
        return dumpASTRequest;
    }

    @NotNull
    private CompletableFuture<String> sendRequestClangFormatConfiguration(@NotNull VirtualFile file) {
        TextDocumentPositionParams params;
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(134);
        }
        if ((params = this.toTextDocumentPositionParams(file, 0)) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                ClangdLanguageService.$$$reportNull$$$0(135);
            }
            return completableFuture;
        }
        ClangFormatConfigurationRequest formatConfigurationRequest = new ClangFormatConfigurationRequest(file.getUrl(), params);
        this.myRequestsPlanner.send(ClangFormatConfigurationRequest.createPromise(formatConfigurationRequest));
        CompletableFuture<String> completableFuture = formatConfigurationRequest.getResponse();
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(136);
        }
        return completableFuture;
    }

    @Nullable
    private ClangDumpTokensRequest sendDumpTokens(@NotNull ClangParseResponse reparse, @NotNull VirtualFile file, int offset) {
        TextDocumentPositionParams params;
        if (reparse == null) {
            ClangdLanguageService.$$$reportNull$$$0(137);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(138);
        }
        if ((params = this.toTextDocumentPositionParams(file, offset)) == null) {
            return null;
        }
        ClangDumpTokensRequest request = new ClangDumpTokensRequest(reparse.getUrl(), params);
        this.myRequestsPlanner.send(ClangDumpTokensRequest.createPromise(this.myContext, request));
        return request;
    }

    @NotNull
    private static FormattingOptions buildFormattingOptions(@Nullable String style) {
        FormattingOptions options = new FormattingOptions(4, true);
        if (style != null) {
            options.putString("style", "#yaml\n" + style);
        }
        FormattingOptions formattingOptions = options;
        if (formattingOptions == null) {
            ClangdLanguageService.$$$reportNull$$$0(139);
        }
        return formattingOptions;
    }

    @NotNull
    private CompletableFuture<List<ClangLineColReplace>> sendFormatRangeRequest(@NotNull VirtualFile file, @NotNull TextRange range, @Nullable String style) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(140);
        }
        if (range == null) {
            ClangdLanguageService.$$$reportNull$$$0(141);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document = this.myContext.getIdeFacade().getDocument(file);
        if (document == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                ClangdLanguageService.$$$reportNull$$$0(142);
            }
            return completableFuture;
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(ClangdLanguageService.vfs2fileUriTransform(this.myContext.getUrlConverter()::toUri, file.getUrl()));
        DocumentRangeFormattingParams params = new DocumentRangeFormattingParams(new Range(ClangLanguageServiceUtils.offset2LspPos(document, range.getStartOffset()), ClangLanguageServiceUtils.offset2LspPos(document, range.getEndOffset())));
        params.setTextDocument(identifier);
        FormattingOptions options = ClangdLanguageService.buildFormattingOptions(style);
        options.putString("code", document.getText());
        params.setOptions(options);
        ClangFormatRangeRequest request = new ClangFormatRangeRequest(file.getUrl(), params);
        this.myRequestsPlanner.send(ClangFormatRangeRequest.createPromise(request));
        CompletableFuture<List<ClangLineColReplace>> completableFuture = request.getResponse();
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(143);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<List<ClangLineColReplace>> sendIndentRequest(@NotNull VirtualFile file, int lineStartOffset, @Nullable String style) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(144);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document = this.myContext.getIdeFacade().getDocument(file);
        if (document == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                ClangdLanguageService.$$$reportNull$$$0(145);
            }
            return completableFuture;
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(ClangdLanguageService.vfs2fileUriTransform(this.myContext.getUrlConverter()::toUri, file.getUrl()));
        DocumentOnTypeFormattingParams params = new DocumentOnTypeFormattingParams(ClangLanguageServiceUtils.offset2LspPos(document, lineStartOffset), "\n");
        params.setTextDocument(identifier);
        FormattingOptions options = ClangdLanguageService.buildFormattingOptions(style);
        options.putString("code", document.getText());
        params.setOptions(options);
        ClangIndentRequest request = new ClangIndentRequest(file.getUrl(), params);
        this.myRequestsPlanner.send(ClangIndentRequest.createPromise(request));
        CompletableFuture<List<ClangLineColReplace>> completableFuture = request.getResponse();
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(146);
        }
        return completableFuture;
    }

    @NotNull
    private ClangCompletionRequest sendRequestComplete(@NotNull VirtualFile file, int line, int column, @NotNull String fileText, @NotNull CompletionTriggerKind kind, @NotNull CLionCompletionKind completionKind, Pair<Integer, ArrayList<String>> postfixTemplates) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(147);
        }
        if (fileText == null) {
            ClangdLanguageService.$$$reportNull$$$0(148);
        }
        if (kind == null) {
            ClangdLanguageService.$$$reportNull$$$0(149);
        }
        if (completionKind == null) {
            ClangdLanguageService.$$$reportNull$$$0(150);
        }
        CLionCompletionParams params = this.toCompletionParams(file, line, column, fileText, completionKind, postfixTemplates);
        CompletionContext context = new CompletionContext();
        context.setTriggerKind(kind);
        params.setContext(context);
        ClangCompletionRequest request = new ClangCompletionRequest(file.getUrl(), params);
        this.myRequestsPlanner.send(ClangCompletionRequest.createPromise(this.myContext, request));
        ClangCompletionRequest clangCompletionRequest = request;
        if (clangCompletionRequest == null) {
            ClangdLanguageService.$$$reportNull$$$0(151);
        }
        return clangCompletionRequest;
    }

    @NonNls
    @NotNull
    public static String vfs2fileUriTransform(@NotNull Function<? super String, String> baseToUri, @NonNls @NotNull String urlOrPath) {
        if (baseToUri == null) {
            ClangdLanguageService.$$$reportNull$$$0(152);
        }
        if (urlOrPath == null) {
            ClangdLanguageService.$$$reportNull$$$0(153);
        }
        if (urlOrPath.startsWith("mock://")) {
            if (urlOrPath.startsWith("mock:///")) {
                String string = urlOrPath.replace("mock:///", ClangdLanguageService.getMockUriRootWithProtocolAndTailBackslash());
                if (string == null) {
                    ClangdLanguageService.$$$reportNull$$$0(154);
                }
                return string;
            }
            String string = urlOrPath.replace("mock://", ClangdLanguageService.getMockUriRootWithProtocolAndTailBackslash());
            if (string == null) {
                ClangdLanguageService.$$$reportNull$$$0(155);
            }
            return string;
        }
        String string = baseToUri.apply(urlOrPath);
        if (string == null) {
            ClangdLanguageService.$$$reportNull$$$0(156);
        }
        return string;
    }

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    private static String getMockUriRootWithProtocolAndTailBackslash() {
        return SystemInfo.isWindows ? "file:///X:/cidr_memory_mapped_mock/" : "file:///cidr_memory_mapped_mock/";
    }

    @Nullable
    private Pair<TextDocumentIdentifier, Position> textDocumentPositionParams(@NotNull VirtualFile file, int offset) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(157);
        }
        return this.findLine(file, offset, (text, lineColumn) -> Pair.create((Object)new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file.getUrl())), (Object)new Position(lineColumn.line, lineColumn.column)));
    }

    private <R> R findLine(@NotNull VirtualFile file, int offset, @NotNull BiFunction<CharSequence, LineColumn, R> lineConsumer) {
        CharSequence content;
        ClangFileFacade helper;
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(158);
        }
        if (lineConsumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(159);
        }
        LineColumn lineColumn = (helper = this.myIdeFacade.getFileFacade(file)) != null ? helper.getLineColumn(offset) : null;
        CharSequence charSequence = content = helper != null ? helper.getText() : null;
        if (content == null || lineColumn == null) {
            return null;
        }
        return lineConsumer.apply(content, lineColumn);
    }

    @Nullable
    private TextDocumentPositionParams toTextDocumentPositionParams(@NotNull VirtualFile file, int offset) {
        Pair<TextDocumentIdentifier, Position> params;
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(160);
        }
        if ((params = this.textDocumentPositionParams(file, offset)) == null) {
            return null;
        }
        return new TextDocumentPositionParams((TextDocumentIdentifier)params.first, (Position)params.second);
    }

    @NotNull
    private CLionCompletionParams toCompletionParams(@NotNull VirtualFile file, int line, int column, @NotNull String fileText, @NotNull CLionCompletionKind completionKind, Pair<Integer, ArrayList<String>> postfixTemplates) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(161);
        }
        if (fileText == null) {
            ClangdLanguageService.$$$reportNull$$$0(162);
        }
        if (completionKind == null) {
            ClangdLanguageService.$$$reportNull$$$0(163);
        }
        Pair params = Pair.create((Object)new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file.getUrl())), (Object)new Position(line, column));
        return new CLionCompletionParams((TextDocumentIdentifier)params.first, (Position)params.second, fileText, completionKind, (Integer)postfixTemplates.first, (List)postfixTemplates.second);
    }

    private void sendContent(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile virtFile) {
        ClangFileFacade helper;
        CharSequence fileText;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(164);
        }
        if (virtFile == null) {
            ClangdLanguageService.$$$reportNull$$$0(165);
        }
        CharSequence charSequence = fileText = (helper = this.myIdeFacade.getFileFacade(virtFile)) != null ? helper.getText() : null;
        if (fileText != null) {
            int nextVersion = wf.nextChange();
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(fileText.toString());
            VersionedTextDocumentIdentifier id = new VersionedTextDocumentIdentifier();
            id.setUri(this.myContext.getUrlConverter().toUri(wf.getUrl()));
            id.setVersion(Integer.valueOf(nextVersion));
            this.myRequestsPlanner.send(ClangChangeNotification.createPromise(this.myContext, wf.getUrl(), nextVersion, new DidChangeTextDocumentParams(id, Collections.singletonList(changeEvent)), false));
        }
    }

    private boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(166);
        }
        return this.myContext.getUrlConverter().isAcceptable(file.getUrl()) && ClangdBridge.isSupported(this.myProject, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 40: 
            case 52: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 81: 
            case 85: 
            case 106: 
            case 113: 
            case 116: 
            case 117: 
            case 120: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 151: 
            case 154: 
            case 155: 
            case 156: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 40: 
            case 52: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 81: 
            case 85: 
            case 106: 
            case 113: 
            case 116: 
            case 117: 
            case 120: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 151: 
            case 154: 
            case 155: 
            case 156: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldest";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 40: 
            case 52: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 81: 
            case 85: 
            case 106: 
            case 113: 
            case 116: 
            case 117: 
            case 120: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 151: 
            case 154: 
            case 155: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageService";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 82: 
            case 86: 
            case 90: 
            case 94: 
            case 98: 
            case 99: 
            case 100: 
            case 104: 
            case 118: 
            case 121: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 133: 
            case 134: 
            case 138: 
            case 140: 
            case 144: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 53: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 15: 
            case 148: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 16: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: 
            case 150: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionKind";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledTestFrameworksNames";
                break;
            }
            case 34: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 55: 
            case 57: 
            case 64: 
            case 65: 
            case 68: 
            case 88: 
            case 92: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wf";
                break;
            }
            case 56: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 58: 
            case 59: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 60: 
            case 61: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedObject";
                break;
            }
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "something";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 78: 
            case 111: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cc";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macros";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crashCase";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ccInfo";
                break;
            }
            case 87: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openRequestId";
                break;
            }
            case 89: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 96: 
            case 114: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 101: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFile";
                break;
            }
            case 102: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macrosWorkspaceFile";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deferrer";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldUrl";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newUrl";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forFiles";
                break;
            }
            case 124: 
            case 132: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparse";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledFrameworkNames";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseToUri";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlOrPath";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineConsumer";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtFile";
                break;
            }
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedDisposable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangIdeFacade";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTelemetry";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemoryUsageWatchDog";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "requestTimingStats";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocess";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "formatRange";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "indentLine";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbols";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWithParsedInternal";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "computeIfAbsent";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalWorkspace";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangdModulesPath";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreprocessedReport";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPreprocessedCase";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCommandLine";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "shutDownServer";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "debugDumpMemoryStat";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeStacktrace";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "withOpenedFile";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "sendInlayHints";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequestClangFormatConfiguration";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFormattingOptions";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "sendFormatRangeRequest";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "sendIndentRequest";
                break;
            }
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequestComplete";
                break;
            }
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "vfs2fileUriTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onOverflow";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 40: 
            case 52: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 81: 
            case 85: 
            case 106: 
            case 113: 
            case 116: 
            case 117: 
            case 120: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 151: 
            case 154: 
            case 155: 
            case 156: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "gotoDefinition";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dumpAST";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "dumpTokens";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFastLineMarkers";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSlowLineMarkers";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTestLineMarkers";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getInlayHints";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "requestTimingStats";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "requestClangFormatConfiguration";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "formatRange";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "indentLine";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getParsed";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSymbols";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runWithParsed";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "computeWithParsed";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "computeWithOpenedAndParsed";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "runWithOpenedAndParsed";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "computeWithParsedInternal";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "applyConsumer";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "trackParseUsage";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "freeParseUsage";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "trackRequestUsage";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "freeRequestUsage";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "debugTrackUsage";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "debugFreeUsage";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isCanceled";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setCanceled";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "cancelParseGently";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "cancelParse";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "cancelRequest";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "sendCancelParse";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "computeIfAbsent";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "generatePreprocessedReport";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createPreprocessedFile";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "checkPreprocessedCase";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "notifyDocumentOpened";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "addOpenRequest";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "notifyDocumentClosed";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "removeOpenRequest";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "notifyDocumentChanged";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "prepareChangeParams";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "notifyReparseRequired";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "notifyReparseRequiredImpl";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "notifyDocumentSaved";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandLine";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "notifyDocumentMoved";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "notifySetCDB";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "notifyLoadIndex";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "notifyLoadGraph";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "isFileBanned";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "debugDumpUsages";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "withOpenedFile";
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getOrParse";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "sendGotoDefinition";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "sendClionLineMarkers";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "sendClionTestLineMarkers";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "sendInlayHints";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "sendDumpAST";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestClangFormatConfiguration";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "sendDumpTokens";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "sendFormatRangeRequest";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "sendIndentRequest";
                break;
            }
            case 147: 
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestComplete";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "vfs2fileUriTransform";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "textDocumentPositionParams";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "findLine";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "toTextDocumentPositionParams";
                break;
            }
            case 161: 
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "toCompletionParams";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "sendContent";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "lambda$debugDumpUsages$57";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 40: 
            case 52: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 81: 
            case 85: 
            case 106: 
            case 113: 
            case 116: 
            case 117: 
            case 120: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 151: 
            case 154: 
            case 155: 
            case 156: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UsagesInfo {
        @NotNull
        final Map<Integer, Exception> id2Stack = new HashMap<Integer, Exception>(12);
        int nextID = 0;

        private UsagesInfo() {
        }
    }

    private static final class GotoDefinitionKey {
        @NotNull
        private final String myUrl;
        private final int myFileVersion;
        private final int myOffset;

        private GotoDefinitionKey(@NotNull ClangParseResponse file, int offset) {
            if (file == null) {
                GotoDefinitionKey.$$$reportNull$$$0(0);
            }
            this.myUrl = file.getUrl();
            this.myFileVersion = file.getVersion();
            this.myOffset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GotoDefinitionKey key = (GotoDefinitionKey)o;
            return Objects.equals(this.myUrl, key.myUrl) && this.myOffset == key.myOffset && this.myFileVersion == key.myFileVersion;
        }

        public int hashCode() {
            return Objects.hash(this.myUrl, this.myFileVersion, this.myOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageService$GotoDefinitionKey", "<init>"));
        }
    }
}

