/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.DummyLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContextImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceProvider;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClangdLanguageServiceHolder {
    private static final Logger LOG = Logger.getInstance(ClangdLanguageServiceProvider.class);
    private static final boolean ourIndexerEnabled = Registry.is((String)"clion.clang.clangd.index.on");
    @NonNls
    @NotNull
    private final String myDescriptor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final File myClangdModulesPath;
    private final boolean myIndexer;
    @NotNull
    private final Object myServiceLock;
    @Nullable
    private ClangLanguageService myService;

    ClangdLanguageServiceHolder(@NonNls @NotNull String descriptor, @NotNull Project project, @NotNull File clangdModulesPath, boolean indexer) {
        if (descriptor == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(1);
        }
        if (clangdModulesPath == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(2);
        }
        this.myServiceLock = new Object();
        this.myService = null;
        this.myDescriptor = descriptor;
        this.myProject = project;
        this.myClangdModulesPath = clangdModulesPath;
        this.myIndexer = indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ClangLanguageService getOrStart() {
        if (!ClangUtils.isClangdAllowed(this.myProject)) {
            throw new ClangUtils.NotAllowedException();
        }
        Object object = this.myServiceLock;
        // MONITORENTER : object
        if (this.myService != null) {
            ClangLanguageService clangLanguageService = this.myService;
            // MONITOREXIT : object
            if (clangLanguageService != null) return clangLanguageService;
            ClangdLanguageServiceHolder.$$$reportNull$$$0(3);
            return clangLanguageService;
        }
        if (this.myIndexer && !ourIndexerEnabled) {
            this.myService = DummyLanguageService.INSTANCE;
            // MONITOREXIT : object
            if (this.myService != null) return this.myService;
            ClangdLanguageServiceHolder.$$$reportNull$$$0(4);
            return this.myService;
        }
        this.myService = ClangdLanguageServiceHolder.startImpl(this.myDescriptor, this.myProject, this.myClangdModulesPath, this.myIndexer);
        if (!this.myProject.isDisposed()) {
            ((ClangLanguageServiceProviderListener)this.myProject.getMessageBus().syncPublisher(ClangLanguageServiceProviderListener.TOPIC)).onServiceStarted(this.myService);
        }
        ClangLanguageService clangLanguageService = this.myService;
        // MONITOREXIT : object
        if (clangLanguageService != null) return clangLanguageService;
        ClangdLanguageServiceHolder.$$$reportNull$$$0(5);
        return clangLanguageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ClangLanguageService getIfStarted() {
        Object object = this.myServiceLock;
        synchronized (object) {
            return this.myService;
        }
    }

    @NotNull
    private static ClangLanguageService startImpl(@NonNls @NotNull String descriptor, @NotNull Project project, @NotNull File clangdModulesPath, boolean indexer) {
        if (descriptor == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(7);
        }
        if (clangdModulesPath == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(8);
        }
        ClangDaemonContextImpl context = null;
        try {
            ClangUrlConverter urlConverter = (ClangUrlConverter)project.getUserData(ClangDaemonContext.URL_CONVERTER_KEY);
            if (urlConverter == null) {
                urlConverter = new ClangUrlConverter();
            }
            ClangDaemonContextImpl.Builder builder = new ClangDaemonContextImpl.Builder(descriptor, project).setIndexer(indexer).setUrlConverter(urlConverter).setIdeFacade(ClangdBridge.createClangIdeFacade(descriptor, indexer)).setClangdModulesPath(clangdModulesPath.getPath());
            if (!indexer) {
                builder.setMessageBus(project.getMessageBus());
            }
            context = builder.create();
            return indexer ? new ClangdIndexerService(context) : new ClangdLanguageService(context);
        }
        catch (Throwable thr) {
            if (context != null) {
                Disposer.dispose(context);
            }
            throw thr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ClangStopData stop() {
        ClangStopData clangStopData;
        ClangLanguageService service;
        Object object = this.myServiceLock;
        synchronized (object) {
            if (this.myService == null) {
                ClangStopData clangStopData2 = ClangStopData.EMPTY;
                // MONITOREXIT @DISABLED, blocks:[4, 10] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                if (clangStopData2 == null) {
                    ClangdLanguageServiceHolder.$$$reportNull$$$0(9);
                }
                return clangStopData2;
            }
            service = this.myService;
            this.myService = null;
            ClangStopData clangStopData3 = service.stop();
            // MONITOREXIT @DISABLED, blocks:[2, 4] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
            clangStopData = clangStopData3;
        }
        if (clangStopData == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(10);
        }
        return clangStopData;
        {
            finally {
                if (!this.myProject.isDisposed()) {
                    ((ClangLanguageServiceProviderListener)this.myProject.getMessageBus().syncPublisher(ClangLanguageServiceProviderListener.TOPIC)).onServiceStopped(service);
                }
            }
        }
    }

    public void forceStop() {
        ClangStopData stopData = this.stop();
        try {
            stopData.exitCode.get(450L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.warn((Throwable)ex);
        }
        catch (TimeoutException ex) {
            LOG.info((Throwable)ex);
            stopData.killRunnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangdModulesPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageServiceHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageServiceHolder";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrStart";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

