/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceHolder;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdLanguageServiceProvider
implements ClangLanguageServiceProvider {
    @NotNull
    private final ClangdLanguageServiceHolder myMainHolder;
    @NotNull
    private final ClangdLanguageServiceHolder myIndexerHolder;
    private static final boolean ourIndexerEnabled = Registry.is((String)"clion.clang.clangd.index.on");

    public ClangdLanguageServiceProvider(@NotNull Project project) {
        if (project == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(0);
        }
        String clangdModulesPath = ClangdLanguageServiceProvider.getModulesPath(project);
        if (ourIndexerEnabled && !FileUtil.exists((String)clangdModulesPath)) {
            FileUtil.createDirectory((File)new File(clangdModulesPath));
        }
        CidrLogService.LOG.info("clangd modules path: " + clangdModulesPath);
        this.myMainHolder = new ClangdLanguageServiceHolder("main", project, new File(clangdModulesPath), false);
        this.myIndexerHolder = new ClangdLanguageServiceHolder("indexer", project, new File(clangdModulesPath), true);
        ClangUtils.subscribeToStyleChanges(this, project);
    }

    @Override
    @NotNull
    public ClangLanguageService getOrStart() {
        ClangLanguageService clangLanguageService = this.myMainHolder.getOrStart();
        if (clangLanguageService == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(1);
        }
        return clangLanguageService;
    }

    @Override
    @Nullable
    public ClangLanguageService getIfStarted() {
        return this.myMainHolder.getIfStarted();
    }

    @Override
    @NotNull
    public ClangStopData stop() {
        ClangStopData clangStopData = this.myMainHolder.stop();
        if (clangStopData == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(2);
        }
        return clangStopData;
    }

    @Override
    @NotNull
    public ClangLanguageService getOrStartIndexer() {
        ClangLanguageService clangLanguageService = this.myIndexerHolder.getOrStart();
        if (clangLanguageService == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(3);
        }
        return clangLanguageService;
    }

    @Override
    @Nullable
    public ClangLanguageService getIfStartedIndexer() {
        return this.myIndexerHolder.getIfStarted();
    }

    @Override
    @NotNull
    public ClangStopData stopIndexer() {
        ClangStopData clangStopData = this.myIndexerHolder.stop();
        if (clangStopData == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(4);
        }
        return clangStopData;
    }

    @NotNull
    static String getModulesPath(@NotNull Project project) {
        Object clangdModulesPath;
        if (project == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(5);
        }
        if ((clangdModulesPath = System.getProperty("MODULES_PATH")) == null && (clangdModulesPath = System.getenv("MODULES_PATH")) == null) {
            String dir = System.getProperty("caches_dir");
            Object object = clangdModulesPath = dir == null ? PathManager.getSystemPath() + "/caches/" : dir;
        }
        if (!((String)clangdModulesPath).endsWith("/")) {
            clangdModulesPath = (String)clangdModulesPath + "/";
        }
        Object object = clangdModulesPath = (String)clangdModulesPath + "clangd_modules/" + project.getLocationHash();
        if (object == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(6);
        }
        return object;
    }

    public void dispose() {
        this.myMainHolder.forceStop();
        this.myIndexerHolder.forceStop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageServiceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageServiceProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrStart";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrStartIndexer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "stopIndexer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModulesPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

