/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessor;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdRequestsPlanner {
    static final int DEFAULT_PATIENT_SEND_DELAY_SEC = 10;
    private static final Logger LOG = Logger.getInstance((String)ClangdRequestsPlanner.class.getName());
    @NotNull
    private final ClangServerAccessor myServerAccessor;
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final AtomicBoolean myIsStopped;
    @NotNull
    private final LinkedList<ClangRequestTask> myQueue;
    @NotNull
    private final AtomicBoolean myExecutorMonitor;
    @Nullable
    private final ScheduledFuture<?> myTimerFuture;

    public ClangdRequestsPlanner(@NotNull String descriptor, @NotNull ClangServerAccessor serverAccessor) {
        if (descriptor == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(0);
        }
        if (serverAccessor == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(1);
        }
        this(descriptor, serverAccessor, 10);
    }

    public ClangdRequestsPlanner(@NotNull String descriptor, @NotNull ClangServerAccessor serverAccessor, int patientSendDelaySeconds) {
        if (descriptor == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(2);
        }
        if (serverAccessor == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(3);
        }
        this.myIsStopped = new AtomicBoolean(false);
        this.myQueue = new LinkedList();
        this.myExecutorMonitor = new AtomicBoolean(false);
        this.myServerAccessor = serverAccessor;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)("ClangdRequestsPlanner [" + descriptor + "]"));
        this.myExecutorService.execute(new ExecutorRunnable());
        this.myTimerFuture = patientSendDelaySeconds > 0 ? AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::notifyExecutor, patientSendDelaySeconds, patientSendDelaySeconds, TimeUnit.SECONDS) : null;
    }

    @NotNull
    ClangServerAccessor getServerAccessor() {
        ClangServerAccessor clangServerAccessor = this.myServerAccessor;
        if (clangServerAccessor == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(4);
        }
        return clangServerAccessor;
    }

    @NotNull
    Future<Boolean> send(@Nullable ClangInteractionPromise<?> promise) {
        if (promise != null) {
            ClangRequestTask requestTask = ClangdRequestsPlanner.createTask(promise);
            this.addTask(requestTask);
            if (requestTask.isImmediateTask()) {
                this.notifyExecutor();
            }
            CompletableFuture<Boolean> completableFuture = requestTask.getTaskFuture();
            if (completableFuture == null) {
                ClangdRequestsPlanner.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }
        CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
        if (completableFuture == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    void sendImmediately(@NotNull ClangInteraction request) {
        if (request == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(7);
        }
        this.myServerAccessor.post(request);
    }

    void waitUntilTasksFinished() {
        assert (this.myServerAccessor.isRunningSynchronously() || !ApplicationManager.getApplication().isWriteAccessAllowed()) : "Holding write lock here can result in a deadlock, because there could be pending tasks requiring read lock!";
        CompletableFuture waitFuture = new CompletableFuture();
        ClangInteraction waitRequest = ClangInteraction.newInteraction("Wait").action((Consumer<? super ClangServer>)((Consumer)server -> waitFuture.complete(null))).onSkipped(() -> waitFuture.complete(null)).create();
        ClangInteractionPromise<ClangInteraction> waitPromise = new ClangInteractionPromiseImpl.Builder<ClangInteraction>(waitRequest).setRearrangeable(false).create();
        this.addTask(new ClangRequestTask(waitPromise));
        this.notifyExecutor();
        try {
            waitFuture.get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    ClangStopData stop() {
        this.myIsStopped.set(true);
        if (this.myTimerFuture != null) {
            this.myTimerFuture.cancel(true);
        }
        this.notifyExecutor();
        this.myExecutorService.shutdown();
        ClangStopData clangStopData = this.myServerAccessor.stop();
        if (clangStopData == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(8);
        }
        return clangStopData;
    }

    @NotNull
    private static ClangRequestTask createTask(@NotNull ClangInteractionPromise<?> clangRequestPromise) {
        if (clangRequestPromise == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(9);
        }
        if (clangRequestPromise.getInteractionClass().equals(ClangChangeNotification.class)) {
            return new ClangChangeFileTask(clangRequestPromise);
        }
        return new ClangRequestTask(clangRequestPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(@NotNull ClangRequestTask task) {
        if (task == null) {
            ClangdRequestsPlanner.$$$reportNull$$$0(10);
        }
        LinkedList<ClangRequestTask> linkedList = this.myQueue;
        synchronized (linkedList) {
            ClangRequestTask queued;
            ListIterator<ClangRequestTask> iterator = this.myQueue.listIterator(this.myQueue.size());
            while (iterator.hasPrevious() && task.canEat(queued = iterator.previous())) {
                queued.onRejected();
                iterator.remove();
            }
            this.myQueue.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<ClangRequestTask> takeTasks() {
        LinkedList<ClangRequestTask> linkedList = this.myQueue;
        // MONITORENTER : linkedList
        ArrayList<ClangRequestTask> toProcess = new ArrayList<ClangRequestTask>(this.myQueue);
        this.myQueue.clear();
        ArrayList<ClangRequestTask> arrayList = toProcess;
        // MONITOREXIT : linkedList
        if (arrayList != null) return arrayList;
        ClangdRequestsPlanner.$$$reportNull$$$0(11);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEvent() {
        AtomicBoolean atomicBoolean = this.myExecutorMonitor;
        synchronized (atomicBoolean) {
            while (!this.myExecutorMonitor.get()) {
                try {
                    this.myExecutorMonitor.wait();
                }
                catch (InterruptedException ex) {
                    LOG.warn((Throwable)ex);
                    break;
                }
            }
            this.myExecutorMonitor.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExecutor() {
        AtomicBoolean atomicBoolean = this.myExecutorMonitor;
        synchronized (atomicBoolean) {
            this.myExecutorMonitor.set(true);
            this.myExecutorMonitor.notifyAll();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverAccessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangRequestPromise";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerAccessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "send";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "takeTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sendImmediately";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DependenciesManager {
        private static final Function<String, Set<ClangProperty>> EMPTY_PROPERTY_SET = u -> EnumSet.noneOf(ClangProperty.class);
        private boolean hasRequests = false;
        private boolean hasNotRearrangeable = false;
        @NotNull
        private final Map<String, Set<ClangProperty>> myReadAccessedProperties = new HashMap<String, Set<ClangProperty>>();
        @NotNull
        private final Map<String, Set<ClangProperty>> myWriteAccessedProperties = new HashMap<String, Set<ClangProperty>>();

        private DependenciesManager() {
        }

        void mergeNext(@NotNull ClangInteractionPromise<?> promise) {
            List<Pair<String, ClangProperty>> writeProperties;
            List<Pair<String, ClangProperty>> readProperties;
            if (promise == null) {
                DependenciesManager.$$$reportNull$$$0(0);
            }
            if (!promise.isRearrangeable()) {
                this.hasNotRearrangeable = true;
            }
            if ((readProperties = promise.getReadProperties()) != null) {
                for (Pair<String, ClangProperty> urlAndProperty : readProperties) {
                    Set<ClangProperty> properties = this.myReadAccessedProperties.computeIfAbsent((String)urlAndProperty.first, EMPTY_PROPERTY_SET);
                    properties.add((ClangProperty)((Object)urlAndProperty.second));
                }
            }
            if ((writeProperties = promise.getWrittenProperties()) != null) {
                for (Pair<String, ClangProperty> urlAndProperty : writeProperties) {
                    Set<ClangProperty> properties = this.myWriteAccessedProperties.computeIfAbsent((String)urlAndProperty.first, EMPTY_PROPERTY_SET);
                    properties.add((ClangProperty)((Object)urlAndProperty.second));
                }
            }
            this.hasRequests = true;
        }

        boolean isDependent(@NotNull ClangInteractionPromise<?> promise) {
            if (promise == null) {
                DependenciesManager.$$$reportNull$$$0(1);
            }
            if (this.hasRequests && !promise.isRearrangeable()) {
                return true;
            }
            if (this.hasNotRearrangeable) {
                return true;
            }
            if (promise.getReadProperties() != null) {
                for (Pair<String, ClangProperty> urlAndProperty : promise.getReadProperties()) {
                    Set<ClangProperty> writeProperties = this.myWriteAccessedProperties.get(urlAndProperty.first);
                    if (writeProperties == null || !writeProperties.contains(urlAndProperty.second)) continue;
                    return true;
                }
            }
            if (promise.getWrittenProperties() != null) {
                for (Pair<String, ClangProperty> urlAndProperty : promise.getWrittenProperties()) {
                    Set<ClangProperty> readProperties = this.myReadAccessedProperties.get(urlAndProperty.first);
                    if (readProperties != null && readProperties.contains(urlAndProperty.second)) {
                        return true;
                    }
                    Set<ClangProperty> writeProperties = this.myWriteAccessedProperties.get(urlAndProperty.first);
                    if (writeProperties == null || !writeProperties.contains(urlAndProperty.second)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "promise";
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$DependenciesManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeNext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDependent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ExecutorRunnable
    implements Runnable {
        @NotNull
        private final Set<ClangRequestTask> myKnownStuckTasks = Collections.newSetFromMap(new IdentityHashMap());

        private ExecutorRunnable() {
        }

        @Override
        public void run() {
            try {
                LinkedList<ClangRequestTask> executorQueue = new LinkedList<ClangRequestTask>();
                while (true) {
                    List<ClangRequestTask> stuckTasks;
                    ClangdRequestsPlanner.this.waitForEvent();
                    if (ClangdRequestsPlanner.this.myIsStopped.get()) break;
                    List<ClangRequestTask> newTasks = ClangdRequestsPlanner.this.takeTasks();
                    executorQueue.addAll(newTasks);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Taken " + newTasks.size() + " new tasks to execute. Total tasks pool is " + executorQueue.size());
                    }
                    if ((stuckTasks = this.sendPending(executorQueue.iterator())) != null) {
                        assert (!executorQueue.isEmpty());
                        for (ClangRequestTask stuckTask : stuckTasks) {
                            if (this.myKnownStuckTasks.contains(stuckTask)) continue;
                            this.myKnownStuckTasks.add(stuckTask);
                            stuckTask.getRequestPromise().getInteraction().whenComplete((res, resEx) -> ClangdRequestsPlanner.this.notifyExecutor());
                        }
                    }
                    this.myKnownStuckTasks.removeIf(ClangRequestTask::isReady);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Currently there are " + this.myKnownStuckTasks.size() + " known stuck tasks");
                }
                for (ClangRequestTask task : executorQueue) {
                    task.onRejected();
                }
            }
            catch (Throwable ex) {
                LOG.error(ex);
            }
        }

        @Nullable
        private List<ClangRequestTask> sendPending(@NotNull Iterator<ClangRequestTask> iterator) {
            if (iterator == null) {
                ExecutorRunnable.$$$reportNull$$$0(0);
            }
            ArrayList<ClangRequestTask> stuckRequests = null;
            DependenciesManager dependencies = new DependenciesManager();
            while (iterator.hasNext()) {
                ClangRequestTask task = iterator.next();
                if (dependencies.isDependent(task.getRequestPromise())) {
                    dependencies.mergeNext(task.getRequestPromise());
                    continue;
                }
                if (!this.trySendOne(task)) {
                    dependencies.mergeNext(task.getRequestPromise());
                    if (stuckRequests == null) {
                        stuckRequests = new ArrayList<ClangRequestTask>();
                    }
                    stuckRequests.add(task);
                    continue;
                }
                iterator.remove();
            }
            return stuckRequests;
        }

        private boolean trySendOne(@NotNull ClangRequestTask task) {
            if (task == null) {
                ExecutorRunnable.$$$reportNull$$$0(1);
            }
            CompletableFuture<?> futureRequest = task.getRequestPromise().getInteraction();
            try {
                ClangInteraction request = (ClangInteraction)futureRequest.get(100L, TimeUnit.MILLISECONDS);
                if (request != null && !task.getTaskFuture().isCancelled()) {
                    CompletableFuture<Boolean> post = ClangdRequestsPlanner.this.myServerAccessor.post(request);
                    if (post == null) {
                        task.onRejected();
                    } else {
                        ClangUtils.tie(task.getTaskFuture(), post);
                    }
                } else {
                    task.onRejected();
                }
                return true;
            }
            catch (TimeoutException ex) {
                return false;
            }
            catch (CancellationException ex) {
                task.onRejected();
                return true;
            }
            catch (ExecutionException ex) {
                if (!(ex.getCause() instanceof ControlFlowException)) {
                    LOG.warn((Throwable)ex);
                }
                task.onRejected();
                return true;
            }
            catch (Throwable thr) {
                LOG.warn(thr);
                task.onRejected();
                return true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$ExecutorRunnable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sendPending";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trySendOne";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClangChangeFileTask
    extends ClangRequestTask {
        ClangChangeFileTask(@NotNull ClangInteractionPromise<?> requestPromise) {
            if (requestPromise == null) {
                ClangChangeFileTask.$$$reportNull$$$0(0);
            }
            super(requestPromise);
        }

        @Override
        protected boolean canEat(@NotNull ClangRequestTask other) {
            if (other == null) {
                ClangChangeFileTask.$$$reportNull$$$0(1);
            }
            if (!(other instanceof ClangChangeFileTask)) {
                return false;
            }
            if (!this.myRequestPromise.getInteraction().isDone() || !other.myRequestPromise.getInteraction().isDone()) {
                return false;
            }
            ClangInteraction request = (ClangInteraction)CidrConcurrentUtilsKt.getIfCompletedNormally(this.myRequestPromise.getInteraction());
            ClangInteraction otherRequest = (ClangInteraction)CidrConcurrentUtilsKt.getIfCompletedNormally(other.myRequestPromise.getInteraction());
            assert (request instanceof ClangChangeNotification && otherRequest instanceof ClangChangeNotification);
            ClangChangeNotification change = (ClangChangeNotification)request;
            ClangChangeNotification otherChange = (ClangChangeNotification)otherRequest;
            return change.getUrl().contentEquals(otherChange.getUrl()) && change.getVersion() >= otherChange.getVersion();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestPromise";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$ClangChangeFileTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canEat";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClangRequestTask {
        @NotNull
        private final CompletableFuture<Boolean> myTaskFuture;
        @NotNull
        protected final ClangInteractionPromise<?> myRequestPromise;

        ClangRequestTask(@NotNull ClangInteractionPromise<?> requestPromise) {
            if (requestPromise == null) {
                ClangRequestTask.$$$reportNull$$$0(0);
            }
            this.myTaskFuture = new CompletableFuture();
            this.myRequestPromise = requestPromise;
        }

        @NotNull
        private ClangInteractionPromise<?> getRequestPromise() {
            ClangInteractionPromise<?> clangInteractionPromise = this.myRequestPromise;
            if (clangInteractionPromise == null) {
                ClangRequestTask.$$$reportNull$$$0(1);
            }
            return clangInteractionPromise;
        }

        @NotNull
        private CompletableFuture<Boolean> getTaskFuture() {
            CompletableFuture<Boolean> completableFuture = this.myTaskFuture;
            if (completableFuture == null) {
                ClangRequestTask.$$$reportNull$$$0(2);
            }
            return completableFuture;
        }

        protected boolean isImmediateTask() {
            return this.myRequestPromise.isImmediate();
        }

        protected final boolean isReady() {
            return this.myRequestPromise.getInteraction().isDone();
        }

        protected boolean canEat(@NotNull ClangRequestTask other) {
            if (other == null) {
                ClangRequestTask.$$$reportNull$$$0(3);
            }
            return false;
        }

        protected void onRejected() {
            Runnable rejectedHandler;
            this.myTaskFuture.complete(false);
            ClangInteraction request = (ClangInteraction)CidrConcurrentUtilsKt.getIfCompletedNormally(this.myRequestPromise.getInteraction());
            if (request != null) {
                request.onRejected();
            }
            if ((rejectedHandler = this.myRequestPromise.getRejectedHandler()) != null) {
                rejectedHandler.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestPromise";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$ClangRequestTask";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdRequestsPlanner$ClangRequestTask";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestPromise";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTaskFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canEat";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

