/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.Compressor;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangPreprocessedReport;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdReportBugDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdReportBugAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile curFile;
        Project project;
        if (e == null) {
            ClangdReportBugAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) != null && (curFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null) {
            ClangdReportBugDialog dialog = new ClangdReportBugDialog(project);
            dialog.show();
            try {
                if (dialog.isOK()) {
                    switch (dialog.getSelectedOption()) {
                        case AS_IS: {
                            ReportHandler reportHandler = dialog.getSendAsException() ? ClangdReportBugAction::reportExceptionZip : ClangdReportBugAction::reportSaveZip;
                            ClangdReportBugAction.prepareAsIsReport(project, curFile, reportHandler);
                            break;
                        }
                        case PREPROCESSED: {
                            ReportHandler reportHandler = dialog.getSendAsException() ? ClangdReportBugAction::reportException : ClangdReportBugAction::reportSaveZip;
                            ClangdReportBugAction.preparePreprocessedReport(project, curFile, false, reportHandler);
                            break;
                        }
                        case PREPROCESSED_AND_OBFUSCATED: {
                            ReportHandler reportHandler = dialog.getSendAsException() ? ClangdReportBugAction::reportException : ClangdReportBugAction::reportSaveZip;
                            ClangdReportBugAction.preparePreprocessedReport(project, curFile, true, reportHandler);
                            break;
                        }
                    }
                }
            }
            catch (IOException ex) {
                ClangUtils.LOG.warn((Throwable)ex);
            }
        }
    }

    private static void preparePreprocessedReport(@NotNull Project project, @NotNull VirtualFile file, boolean obfuscate, @NotNull ReportHandler handler) throws IOException {
        ClangPreprocessedReport report;
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ClangdReportBugAction.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            ClangdReportBugAction.$$$reportNull$$$0(3);
        }
        if ((report = ClangdReportBugAction.doPreprocess(project, file)) != null && !report.getPreprocessedFiles().isEmpty()) {
            Obfuscator obfuscator = obfuscate ? ClangdBridge.getObfuscator() : null;
            ClangPreprocessedReport.PreprocessedFile ppFile = report.getPreprocessedFiles().get(0);
            HashMap<String, String> file2Content = new HashMap<String, String>();
            file2Content.put("CompilationInfo.txt", ppFile.getCompilationInfoAsString(obfuscator));
            String fileName = "preprocessed_" + PathUtilRt.getFileName((String)ppFile.getTargetPath(obfuscator));
            file2Content.put(fileName, ppFile.getContent(obfuscator));
            if (ppFile.lastDiagnostics != null) {
                file2Content.put("LastDiagnostics.txt", ppFile.lastDiagnostics);
            }
            handler.accept(project, file2Content);
        }
    }

    private static void prepareAsIsReport(@NotNull Project project, @NotNull VirtualFile file, @NotNull ReportHandler handler) throws IOException {
        ClangPreprocessedReport report;
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            ClangdReportBugAction.$$$reportNull$$$0(5);
        }
        if (handler == null) {
            ClangdReportBugAction.$$$reportNull$$$0(6);
        }
        if ((report = ClangdReportBugAction.doPreprocess(project, file)) != null && !report.getPreprocessedFiles().isEmpty()) {
            ClangPreprocessedReport.PreprocessedFile ppFile = report.getPreprocessedFiles().get(0);
            if (ppFile.content != null) {
                HashSet<String> paths = new HashSet<String>();
                Pattern regex = Pattern.compile("#\\s[0-9]+\\s\"([^\"]*?)\"");
                Matcher matcher = regex.matcher(ppFile.content);
                while (matcher.find()) {
                    String path = matcher.group(1);
                    if (StringUtil.isEmpty((String)path)) continue;
                    paths.add(path);
                }
                paths.remove("<command line>");
                paths.remove("<built-in>");
                HashMap<String, String> file2Content = new HashMap<String, String>();
                file2Content.put("CompilationInfo.txt", ppFile.getCompilationInfoAsString(null));
                if (ppFile.lastDiagnostics != null) {
                    file2Content.put("LastDiagnostics.txt", ppFile.lastDiagnostics);
                }
                file2Content.put("preprocessed_" + PathUtilRt.getFileName((String)ppFile.getTargetPath(null)), ppFile.getContent(null));
                ClangdReportBugAction.collectFiles(ppFile, paths, file2Content);
                handler.accept(project, file2Content);
            }
        }
    }

    @Nullable
    private static ClangPreprocessedReport doPreprocess(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            ClangdReportBugAction.$$$reportNull$$$0(8);
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getOrStart(project);
        return (ClangPreprocessedReport)CidrConcurrentUtilsKt.computeUnderProgress((String)ClangdBundle.message("clangd.report.bug.collecting.title", new Object[0]), (Project)project, () -> {
            try {
                return (ClangPreprocessedReport)CidrConcurrentUtilsKt.waitCancelAware(service.generatePreprocessedReport(Collections.singletonList(file.getUrl())), (String)"preprocessed report");
            }
            catch (ExecutionException ex) {
                ClangUtils.LOG.warn((Throwable)ex);
                return null;
            }
        });
    }

    @Nullable
    private static File getSavePath(@NotNull Project project) {
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(9);
        }
        String name = project.getName().replaceAll("[^a-zA-Z0-9\\-_]", "_");
        VirtualFileWrapper saved = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(ClangdBundle.message("clangd.report.bug.save.title", new Object[0]), ClangdBundle.message("clangd.report.bug.save.description", new Object[0]), new String[0]), project).save(name + "_report.zip");
        return saved != null ? saved.getFile() : null;
    }

    private static void collectFiles(@NotNull ClangPreprocessedReport.PreprocessedFile ppFile, @NotNull Collection<String> paths, @NotNull Map<String, String> file2Content) throws IOException {
        if (ppFile == null) {
            ClangdReportBugAction.$$$reportNull$$$0(10);
        }
        if (paths == null) {
            ClangdReportBugAction.$$$reportNull$$$0(11);
        }
        if (file2Content == null) {
            ClangdReportBugAction.$$$reportNull$$$0(12);
        }
        for (String path : paths) {
            if (ClangRequestsHelper.isMacroPath(path)) {
                file2Content.put(path, ppFile.macros);
                continue;
            }
            if (!FileUtil.exists((String)path)) continue;
            file2Content.put(path, FileUtilRt.loadFile((File)new File(path)));
        }
    }

    @NotNull
    private static String convertWindowsPath(@NotNull String path) {
        if (path == null) {
            ClangdReportBugAction.$$$reportNull$$$0(13);
        }
        if (path.length() > 1 && !path.startsWith("/") && path.charAt(1) == ':') {
            String string = "/drive_" + path.charAt(0) + path.substring(2);
            if (string == null) {
                ClangdReportBugAction.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            ClangdReportBugAction.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static void reportSaveZip(@NotNull Project project, @NotNull Map<String, String> file2Content) throws IOException {
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(16);
        }
        if (file2Content == null) {
            ClangdReportBugAction.$$$reportNull$$$0(17);
        }
        byte[] zipArchive = ClangdReportBugAction.makeZipArchive(file2Content);
        File savePath = ClangdReportBugAction.getSavePath(project);
        if (savePath != null) {
            FileUtil.writeToFile((File)savePath, (byte[])zipArchive);
        }
    }

    private static void reportExceptionZip(@NotNull Project project, @NotNull Map<String, String> file2Content) throws IOException {
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(18);
        }
        if (file2Content == null) {
            ClangdReportBugAction.$$$reportNull$$$0(19);
        }
        byte[] zipArchive = ClangdReportBugAction.makeZipArchive(file2Content);
        ClangUtils.LOG.error("Collected sources are placed into ZIP archive. Please, attach it to the report", new Attachment[]{new Attachment("report.zip", zipArchive, "Collected sources in a .zip archive")});
    }

    private static byte[] makeZipArchive(@NotNull Map<String, String> file2Content) throws IOException {
        if (file2Content == null) {
            ClangdReportBugAction.$$$reportNull$$$0(20);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (Compressor.Zip zip = new Compressor.Zip((OutputStream)baos);){
            for (Map.Entry<String, String> entry : file2Content.entrySet()) {
                zip.addFile(ClangdReportBugAction.convertWindowsPath(entry.getKey()), entry.getValue().getBytes(StandardCharsets.UTF_8));
            }
        }
        return baos.toByteArray();
    }

    private static void reportException(@NotNull Project project, @NotNull Map<String, String> file2Content) throws IOException {
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(21);
        }
        if (file2Content == null) {
            ClangdReportBugAction.$$$reportNull$$$0(22);
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (Map.Entry<String, String> entry : file2Content.entrySet()) {
            attachments.add(new Attachment(entry.getKey(), entry.getValue()));
        }
        ClangUtils.LOG.error("Please, attach collected sources to the report", attachments.toArray(Attachment.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ppFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2Content";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdReportBugAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdReportBugAction";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertWindowsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preparePreprocessedReport";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareAsIsReport";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doPreprocess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSavePath";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertWindowsPath";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reportSaveZip";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reportExceptionZip";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "makeZipArchive";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reportException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface ReportHandler {
        public void accept(@NotNull Project var1, @NotNull Map<String, String> var2) throws IOException;
    }
}

