/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SourceLocation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTBasedRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColPosition;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangGotoDefinitionRequest
extends ClangASTBasedRequest<TextDocumentPositionParams, List<ClangSym>> {
    @NotNull
    private final ClangDaemonContext myContext;

    @NotNull
    public static ClangInteractionPromise<ClangGotoDefinitionRequest> createPromise(@NotNull ClangDaemonContext context, @NotNull ClangGotoDefinitionRequest request) {
        if (context == null) {
            ClangGotoDefinitionRequest.$$$reportNull$$$0(0);
        }
        if (request == null) {
            ClangGotoDefinitionRequest.$$$reportNull$$$0(1);
        }
        String url = context.getUrlConverter().fromUriToUrl(((TextDocumentPositionParams)request.myParams).getTextDocument().getUri());
        ClangInteractionPromise<ClangGotoDefinitionRequest> clangInteractionPromise = new ClangInteractionPromiseImpl.Builder<ClangGotoDefinitionRequest>(request).addReadAccessedProperties(url, ClangProperty.Ast).create();
        if (clangInteractionPromise == null) {
            ClangGotoDefinitionRequest.$$$reportNull$$$0(2);
        }
        return clangInteractionPromise;
    }

    public ClangGotoDefinitionRequest(@NotNull ClangDaemonContext context, @NotNull TextDocumentPositionParams params) {
        if (context == null) {
            ClangGotoDefinitionRequest.$$$reportNull$$$0(3);
        }
        if (params == null) {
            ClangGotoDefinitionRequest.$$$reportNull$$$0(4);
        }
        super(context.getUrlConverter().fromUriToUrl(params.getTextDocument().getUri()), params);
        this.myContext = context;
    }

    @Override
    @Nullable
    protected CompletableFuture<List<ClangSym>> sendRequestImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (server == null) {
            ClangGotoDefinitionRequest.$$$reportNull$$$0(5);
        }
        if (ws == null) {
            ClangGotoDefinitionRequest.$$$reportNull$$$0(6);
        }
        return server.clionDefinition((TextDocumentPositionParams)this.myParams).thenApply(infos -> {
            if (ContainerUtil.isEmpty((Collection)infos)) {
                return null;
            }
            ArrayList<ClangSym> answer = new ArrayList<ClangSym>(infos.size());
            for (SymbolInformation symInfo : infos) {
                try {
                    Location loc = symInfo.getLocation();
                    SourceLocation srcLoc = new SourceLocation(new URI(loc.getUri()), new ClangLineColPosition(loc.getRange().getStart()));
                    answer.add(new ClangSym(symInfo.getName(), srcLoc, ClangRequestsHelper.isMacroLSPSymbolKind(symInfo.getKind())));
                }
                catch (URISyntaxException ex) {
                    ClangUtils.warnClangd(LOG, ex);
                }
            }
            return answer;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangGotoDefinitionRequest";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ws";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangGotoDefinitionRequest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPromise";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

