/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.system.CpuArch;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitDownloadAndInstallKt;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitInstaller;
import git4idea.config.WindowsExecutableProblemHandler;
import git4idea.config.WindowsExecutableProblemHandler$WhenMappings;
import git4idea.i18n.GitBundle;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J&\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lgit4idea/config/WindowsExecutableProblemHandler;", "Lgit4idea/config/GitExecutableProblemHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "archMatches", "", "arch", "", "installGit", "", "exeFile", "Ljava/io/File;", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "onErrorResolved", "Lkotlin/Function0;", "showError", "exception", "", "Companion", "intellij.vcs.git"})
public final class WindowsExecutableProblemHandler
implements GitExecutableProblemHandler {
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void showError(@NotNull Throwable exception, @NotNull ErrorNotifier errorNotifier, @NotNull Function0<Unit> onErrorResolved) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        Intrinsics.checkNotNullParameter(onErrorResolved, (String)"onErrorResolved");
        String string = GitBundle.message("executable.error.git.not.installed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"execu\u2026error.git.not.installed\")");
        String string2 = GitExecutableProblemHandlersKt.getHumanReadableErrorFor(exception);
        String string3 = GitBundle.message("install.download.and.install.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GitBundle.message(\"insta\u2026load.and.install.action\")");
        errorNotifier.showError(string, string2, new ErrorNotifier.FixOption.Standard(string3, (Function0<Unit>)((Function0)new Function0<Unit>(this, errorNotifier, onErrorResolved){
            final /* synthetic */ WindowsExecutableProblemHandler this$0;
            final /* synthetic */ ErrorNotifier $errorNotifier;
            final /* synthetic */ Function0 $onErrorResolved;

            public final void invoke() {
                String string = GitBundle.message("install.downloading.progress", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"install.downloading.progress\")");
                this.$errorNotifier.executeTask(string, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ showError.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        GitInstaller installer2 = GitDownloadAndInstallKt.fetchInstaller(this.this$0.$errorNotifier, (Function1<? super GitInstaller, Boolean>)((Function1)new Function1<GitInstaller, Boolean>(this){
                            final /* synthetic */ showError.1 this$0;

                            public final boolean invoke(@NotNull GitInstaller it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)it.getOs(), (Object)"windows") && WindowsExecutableProblemHandler.access$archMatches(this.this$0.this$0.this$0, it.getArch());
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        if (installer2 != null) {
                            String fileName = installer2.getFileName();
                            File exeFile = new File(PathManager.getTempPath(), fileName);
                            try {
                                if (GitDownloadAndInstallKt.downloadGit(installer2, exeFile, this.this$0.this$0.getProject(), this.this$0.$errorNotifier)) {
                                    ErrorNotifier errorNotifier = this.this$0.$errorNotifier;
                                    String string = GitBundle.message("install.installing.progress", new Object[0]);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"install.installing.progress\")");
                                    errorNotifier.changeProgressTitle(string);
                                    WindowsExecutableProblemHandler.access$installGit(this.this$0.this$0, exeFile, this.this$0.$errorNotifier, this.this$0.$onErrorResolved);
                                }
                            }
                            finally {
                                FileUtil.delete((File)exeFile);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = windowsExecutableProblemHandler;
                this.$errorNotifier = errorNotifier;
                this.$onErrorResolved = function0;
                super(0);
            }
        })));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean archMatches(String arch) {
        CpuArch cpuArch = CpuArch.CURRENT;
        if (cpuArch == null) return false;
        switch (WindowsExecutableProblemHandler$WhenMappings.$EnumSwitchMapping$0[cpuArch.ordinal()]) {
            case 1: {
                boolean bl = Intrinsics.areEqual((Object)arch, (Object)"x86_32");
                return bl;
            }
            case 2: {
                boolean bl = Intrinsics.areEqual((Object)arch, (Object)"x86_64");
                return bl;
            }
            default: {
                return false;
            }
        }
    }

    private final void installGit(File exeFile, ErrorNotifier errorNotifier, Function0<Unit> onErrorResolved) {
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(exeFile.getPath()).withParameters(new String[]{"/verysilent"});
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine()\n   \u2026Parameters(\"/verysilent\")");
        GeneralCommandLine commandLine = generalCommandLine;
        try {
            ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
            if (!output2.checkSuccess(LOG)) {
                String string = GitBundle.message("install.general.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"install.general.error\")");
                errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
            } else {
                LOG.info("Installed Git. " + GitExecutableProblemHandlersKt.dumpToString(output2));
                String string = GitBundle.message("install.success.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"install.success.message\")");
                errorNotifier.showMessage(string);
                errorNotifier.resetGitExecutable();
                onErrorResolved.invoke();
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't run " + commandLine);
            String string = GitBundle.message("install.general.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"install.general.error\")");
            errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public WindowsExecutableProblemHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WindowsExecutableProblemHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Override
    @RequiresEdt
    public void showError(@NotNull Throwable exception, @NotNull ErrorNotifier errorNotifier) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        GitExecutableProblemHandler.DefaultImpls.showError(this, exception, errorNotifier);
    }

    public static final /* synthetic */ boolean access$archMatches(WindowsExecutableProblemHandler $this, String arch) {
        return $this.archMatches(arch);
    }

    public static final /* synthetic */ void access$installGit(WindowsExecutableProblemHandler $this, File exeFile, ErrorNotifier errorNotifier, Function0 onErrorResolved) {
        $this.installGit(exeFile, errorNotifier, (Function0<Unit>)onErrorResolved);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/config/WindowsExecutableProblemHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

