/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VirtualFileFilteringListener;
import git4idea.i18n.GitBundle;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexVirtualFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J*\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\"\u0010\u0011\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0010H\u0014J\"\u0010\u0014\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0010H\u0014J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\nH\u0014J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010\u001f\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0014J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u001eH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\"\u0010$\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0010H\u0014R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystem;", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "()V", "listenerWrappers", "", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "addVirtualFileListener", "", "listener", "copyFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "requestor", "", "virtualFile", "newParent", "copyName", "", "createChildDirectory", "vDir", "dirName", "createChildFile", "fileName", "deleteFile", "", "vFile", "extractPresentableUrl", "path", "findFileByPath", "getProtocol", "isReadOnly", "", "moveFile", "refresh", "asynchronous", "refreshAndFindFileByPath", "removeVirtualFileListener", "renameFile", "newName", "Companion", "intellij.vcs.git"})
public final class GitIndexFileSystem
extends VirtualFileSystem {
    private final Map<VirtualFileListener, VirtualFileListener> listenerWrappers = new ConcurrentHashMap();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getProtocol() {
        return "gitIndexFs";
    }

    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        void virtualFile;
        void project;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Triple<Project, VirtualFile, FilePath> triple = GitIndexVirtualFile.Companion.decode(path);
        if (triple == null) {
            return null;
        }
        Triple<Project, VirtualFile, FilePath> triple2 = triple;
        Project project2 = (Project)triple2.component1();
        VirtualFile virtualFile2 = (VirtualFile)triple2.component2();
        FilePath filePath = (FilePath)triple2.component3();
        return GitIndexFileSystemRefresher.Companion.getInstance((Project)project).getFile((VirtualFile)virtualFile, filePath);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.findFileByPath(path);
    }

    public void refresh(boolean asynchronous) {
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String extractPresentableUrl = GitIndexVirtualFile.Companion.extractPresentableUrl(path);
        String string = GitBundle.message("stage.vfs.presentable.file.name", extractPresentableUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"stage\u2026\", extractPresentableUrl)");
        return string;
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        VirtualFileListener wrapper = (VirtualFileListener)new VirtualFileFilteringListener(listener2, (VirtualFileSystem)this);
        VirtualFileManager.getInstance().addVirtualFileListener(wrapper);
        this.listenerWrappers.put(listener2, wrapper);
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            VirtualFileListener virtualFileListener = this.listenerWrappers.remove(listener2);
            if (virtualFileListener == null) break block0;
            VirtualFileListener virtualFileListener2 = virtualFileListener;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFileListener it = virtualFileListener2;
            boolean bl3 = false;
            VirtualFileManager.getInstance().removeVirtualFileListener(it);
        }
    }

    @NotNull
    protected Void deleteFile(@Nullable Object requestor, @NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    protected Void moveFile(@Nullable Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    protected Void renameFile(@Nullable Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    protected VirtualFile createChildFile(@Nullable Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)vDir, (String)"vDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    protected VirtualFile createChildDirectory(@Nullable Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)vDir, (String)"vDir");
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    protected VirtualFile copyFile(@Nullable Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        Intrinsics.checkNotNullParameter((Object)copyName, (String)"copyName");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public static final GitIndexFileSystem getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystem$Companion;", "", "()V", "instance", "Lgit4idea/index/vfs/GitIndexFileSystem;", "getInstance$annotations", "getInstance", "()Lgit4idea/index/vfs/GitIndexFileSystem;", "intellij.vcs.git"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final GitIndexFileSystem getInstance() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("gitIndexFs");
            if (virtualFileSystem == null) {
                throw new NullPointerException("null cannot be cast to non-null type git4idea.index.vfs.GitIndexFileSystem");
            }
            return (GitIndexFileSystem)virtualFileSystem;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

