/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.config.GitExecutableManager;
import git4idea.i18n.GitBundle;
import git4idea.log.GitShowExternalLogAction;
import git4idea.log.GitShowExternalLogActionKt;
import git4idea.log.MyContentComponent;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lgit4idea/log/ShowLogInDialogTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "vcs", "Lgit4idea/GitVcs;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lgit4idea/GitVcs;)V", "getRoots", "()Ljava/util/List;", "getVcs", "()Lgit4idea/GitVcs;", "onSuccess", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.vcs.git"})
final class ShowLogInDialogTask
extends Task.Backgroundable {
    @NotNull
    private final List<VirtualFile> roots;
    @NotNull
    private final GitVcs vcs;

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!GitExecutableManager.getInstance().testGitExecutableVersionValid(this.getProject())) {
            throw (Throwable)new ProcessCanceledException();
        }
    }

    public void onSuccess() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (!project.isDisposed()) {
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            MyContentComponent content2 = GitShowExternalLogActionKt.access$createManagerAndContent(project2, this.vcs, this.roots, false);
            WindowWrapper windowWrapper = new WindowWrapperBuilder(WindowWrapper.Mode.FRAME, (JComponent)content2).setProject(this.getProject()).setTitle(GitBundle.message("git.log.external.window.title", new Object[0])).setPreferredFocusedComponent((JComponent)content2).setDimensionServiceKey(GitShowExternalLogAction.class.getName()).build();
            Intrinsics.checkNotNullExpressionValue((Object)windowWrapper, (String)"WindowWrapperBuilder(Win\u2026va.name)\n        .build()");
            WindowWrapper window = windowWrapper;
            Disposer.register((Disposable)((Disposable)window), (Disposable)content2.getDisposable());
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            GitShowExternalLogActionKt.access$doOnProviderRemoval(project3, content2.getDisposable(), (Function0)new Function0<Unit>(window){
                final /* synthetic */ WindowWrapper $window;

                public final void invoke() {
                    this.$window.close();
                }
                {
                    this.$window = windowWrapper;
                    super(0);
                }
            });
            window.show();
        }
    }

    @NotNull
    public final List<VirtualFile> getRoots() {
        return this.roots;
    }

    @NotNull
    public final GitVcs getVcs() {
        return this.vcs;
    }

    public ShowLogInDialogTask(@NotNull Project project, @NotNull List<? extends VirtualFile> roots, @NotNull GitVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
        super(project, GitBundle.message("git.log.external.loading.process", new Object[0]), true);
        this.roots = roots;
        this.vcs = vcs;
    }
}

