/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.rebase.GitAutomaticRebaseEditor;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.log.GitCommitEditingOperation;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.repo.GitRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f0\u0007\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/rebase/GitRewordOperation;", "Lgit4idea/rebase/log/GitCommitEditingOperation;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "newMessage", "", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "initialHeadPosition", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/Nullable;", "canRewordViaAmend", "", "execute", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "injectRewordAction", "", "Lgit4idea/rebase/GitRebaseEntry;", "list", "isLatestCommit", "rewordViaAmend", "rewordViaRebase", "supplyNewMessage", "editorText", "intellij.vcs.git"})
public final class GitRewordOperation
extends GitCommitEditingOperation {
    private final Logger LOG;
    private final String initialHeadPosition;
    private final VcsCommitMetadata commit;
    private final String newMessage;

    @NotNull
    public final GitCommitEditingOperationResult execute() {
        GitCommitEditingOperationResult operationResult;
        if (this.canRewordViaAmend() && (operationResult = this.rewordViaAmend()) instanceof GitCommitEditingOperationResult.Complete) {
            return operationResult;
        }
        return this.rewordViaRebase();
    }

    private final boolean canRewordViaAmend() {
        return this.isLatestCommit() && GitVersionSpecialty.CAN_AMEND_WITHOUT_FILES.existsIn(this.getProject());
    }

    private final boolean isLatestCommit() {
        return Intrinsics.areEqual((Object)((Hash)this.commit.getId()).asString(), (Object)this.initialHeadPosition);
    }

    private final GitCommitEditingOperationResult rewordViaRebase() {
        Project project = this.getProject();
        VirtualFile virtualFile = this.commit.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commit.root");
        GitAutomaticRebaseEditor rebaseEditor2 = new GitAutomaticRebaseEditor(project, virtualFile, (Function1<? super List<? extends GitRebaseEntry>, ? extends List<? extends GitRebaseEntry>>)((Function1)new Function1<List<? extends GitRebaseEntry>, List<? extends GitRebaseEntry>>(this){
            final /* synthetic */ GitRewordOperation this$0;

            @NotNull
            public final List<GitRebaseEntry> invoke(@NotNull List<? extends GitRebaseEntry> list2) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                return GitRewordOperation.access$injectRewordAction(this.this$0, list2);
            }
            {
                this.this$0 = gitRewordOperation;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)new Function1<String, String>(this){
            final /* synthetic */ GitRewordOperation this$0;

            @NotNull
            public final String invoke(@NotNull String editorText) {
                Intrinsics.checkNotNullParameter((Object)editorText, (String)"editorText");
                return GitRewordOperation.access$supplyNewMessage(this.this$0, editorText);
            }
            {
                this.this$0 = gitRewordOperation;
                super(1);
            }
        }));
        return GitCommitEditingOperation.rebase$default(this, CollectionsKt.listOf((Object)this.commit), rebaseEditor2, false, 4, null);
    }

    private final GitCommitEditingOperationResult rewordViaAmend() {
        GitLineHandler handler = new GitLineHandler(this.getProject(), this.getRepository().getRoot(), GitCommand.COMMIT);
        File messageFile = null;
        try {
            File file = GitCheckinEnvironment.createCommitMessageFile(this.getProject(), this.getRepository().getRoot(), this.newMessage);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"GitCheckinEnvironment.cr\u2026ository.root, newMessage)");
            messageFile = file;
        }
        catch (IOException e) {
            this.LOG.warn("Couldn't create message file", (Throwable)e);
            return GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }
        handler.addParameters("--amend");
        handler.addParameters("-F");
        handler.addAbsoluteFile(messageFile);
        handler.addParameters("--only");
        handler.addParameters("--no-verify");
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"Git.getInstance().runCommand(handler)");
        GitCommandResult result2 = gitCommandResult;
        this.getRepository().update();
        if (result2.success()) {
            GitRepository gitRepository = this.getRepository();
            List list2 = this.commit.getParents();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"commit.parents");
            String string = ((Hash)CollectionsKt.first((List)list2)).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commit.parents.first().asString()");
            String string2 = this.getRepository().getCurrentRevision();
            Intrinsics.checkNotNull((Object)string2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"repository.currentRevision!!");
            return new GitCommitEditingOperationResult.Complete(gitRepository, string, this.initialHeadPosition, string2);
        }
        this.LOG.warn("Couldn't reword via amend: " + result2.getErrorOutputAsJoinedString());
        return GitCommitEditingOperationResult.Incomplete.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final List<GitRebaseEntry> injectRewordAction(List<? extends GitRebaseEntry> list) {
        $this$map$iv = list;
        $i$f$map = false;
        var4_4 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var9_9 = (GitRebaseEntry)item$iv$iv;
            var11_11 = destination$iv$iv;
            $i$a$-map-GitRewordOperation$injectRewordAction$1 = false;
            if (!Intrinsics.areEqual((Object)entry.getAction(), (Object)GitRebaseEntry.Action.PICK.INSTANCE)) ** GOTO lbl-1000
            v0 = ((Hash)this.commit.getId()).asString();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"commit.id.asString()");
            if (StringsKt.startsWith$default((String)v0, (String)entry.getCommit(), (boolean)false, (int)2, null)) {
                v1 = new GitRebaseEntry(GitRebaseEntry.Action.REWORD.INSTANCE, entry.getCommit(), entry.getSubject());
            } else lbl-1000:
            // 2 sources

            {
                v1 = entry;
            }
            var12_12 = v1;
            var11_11.add(var12_12);
        }
        return (List)destination$iv$iv;
    }

    private final String supplyNewMessage(String editorText) {
        String string = this.commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commit.fullMessage");
        if (StringsKt.startsWith$default((String)editorText, (String)string, (boolean)false, (int)2, null)) {
            return this.newMessage;
        }
        this.LOG.error("Unexpected editor content. Charset: " + GitConfigUtil.getCommitEncoding(this.getProject(), this.commit.getRoot()), new Attachment[]{new Attachment("actual.txt", editorText), new Attachment("expected.txt", this.commit.getFullMessage())});
        throw (Throwable)new IllegalStateException("Unexpected editor content");
    }

    public GitRewordOperation(@NotNull GitRepository repository, @NotNull VcsCommitMetadata commit, @NotNull String newMessage) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter((Object)newMessage, (String)"newMessage");
        super(repository);
        this.commit = commit;
        this.newMessage = newMessage;
        repository.update();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitRewordOperation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
        String string = repository.getCurrentRevision();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.currentRevision!!");
        this.initialHeadPosition = string;
    }

    public static final /* synthetic */ List access$injectRewordAction(GitRewordOperation $this, List list2) {
        return $this.injectRewordAction(list2);
    }

    public static final /* synthetic */ String access$supplyNewMessage(GitRewordOperation $this, String editorText) {
        return $this.supplyNewMessage(editorText);
    }
}

