/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitCommitEditingActionBase$WhenMappings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 0*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0004/012B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00028\u0000H\u0015\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0002H\u0003J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH$J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020\u0011H%J&\u0010&\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b'2\u0006\u0010\u000e\u001a\u00028\u00002\b\b\u0001\u0010(\u001a\u00020\u0011H\u0014\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001d\u0010*\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010+J\f\u0010,\u001a\u00020-*\u00020.H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00063"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "prohibitRebaseDuringRebasePolicy", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "getProhibitRebaseDuringRebasePolicy", "()Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformedAfterChecks", "commitEditingData", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)V", "checkCommitsEditingAvailability", "", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)Ljava/lang/String;", "checkHeadLinearHistory", "createCommitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "repository", "Lgit4idea/repo/GitRepository;", "log", "Lcom/intellij/vcs/log/VcsLog;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "getCommitIdByNodeId", "Lcom/intellij/vcs/log/CommitId;", "data", "permanentGraph", "Lcom/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl;", "", "nodeId", "getFailureTitle", "getProhibitedStateMessage", "Lorg/jetbrains/annotations/Nls;", "operation", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;Ljava/lang/String;)Ljava/lang/String;", "update", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)V", "isRootOrMerge", "", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "CommitEditingDataCreationResult", "Companion", "MultipleCommitEditingData", "ProhibitRebaseDuringRebasePolicy", "intellij.vcs.git"})
public abstract class GitCommitEditingActionBase<T extends MultipleCommitEditingData>
extends DumbAwareAction {
    @NotNull
    private final ProhibitRebaseDuringRebasePolicy prohibitRebaseDuringRebasePolicy = ProhibitRebaseDuringRebasePolicy.Allow.INSTANCE;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected ProhibitRebaseDuringRebasePolicy getProhibitRebaseDuringRebasePolicy() {
        return this.prohibitRebaseDuringRebasePolicy;
    }

    protected abstract void actionPerformedAfterChecks(@NotNull T var1);

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected abstract String getFailureTitle();

    @NotNull
    protected abstract CommitEditingDataCreationResult<T> createCommitEditingData(@NotNull GitRepository var1, @NotNull VcsLog var2, @NotNull VcsLogData var3, @NotNull VcsLogUi var4);

    protected void update(@NotNull AnActionEvent e, @NotNull T commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
    }

    public void update(@NotNull AnActionEvent e) {
        String message;
        VcsShortCommitDetails commit;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(false);
        CommitEditingDataCreationResult<T> commitEditingDataCreationResult = this.createCommitEditingData(e);
        if (commitEditingDataCreationResult instanceof CommitEditingDataCreationResult.Prohibited) {
            String description = ((CommitEditingDataCreationResult.Prohibited)commitEditingDataCreationResult).getDescription();
            if (description != null) {
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                presentation2.setVisible(true);
                Presentation presentation3 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
                presentation3.setDescription(description);
            }
            return;
        }
        if (!(commitEditingDataCreationResult instanceof CommitEditingDataCreationResult.Created)) {
            throw new NoWhenBranchMatchedException();
        }
        Object commitEditingData = ((CommitEditingDataCreationResult.Created)commitEditingDataCreationResult).getData();
        Presentation presentation4 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
        presentation4.setVisible(true);
        List<VcsShortCommitDetails> commitList = ((MultipleCommitEditingData)commitEditingData).getSelectedCommitList();
        GitRepository repository = ((MultipleCommitEditingData)commitEditingData).getRepository();
        DataPack dataPack = ((MultipleCommitEditingData)commitEditingData).getLogData().getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"commitEditingData.logData.dataPack");
        if (VcsLogUtil.findBranch((RefsModel)dataPack.getRefsModel(), (VirtualFile)repository.getRoot(), (String)"HEAD") == null) {
            Presentation presentation5 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation5, (String)"e.presentation");
            presentation5.setDescription(GitBundle.message("rebase.log.multiple.commit.editing.action.cant.find.head", commitList.size()));
            return;
        }
        Iterable $this$forEach$iv = commitList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            commit = (VcsShortCommitDetails)element$iv;
            boolean bl = false;
            if (!this.isRootOrMerge(commit)) continue;
            Presentation presentation6 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation6, (String)"e.presentation");
            presentation6.setDescription(GitBundle.message("rebase.log.commit.editing.action.disabled.parents.description", commit.getParents().size()));
            return;
        }
        $this$forEach$iv = CollectionsKt.listOf((Object[])new VcsShortCommitDetails[]{(VcsShortCommitDetails)CollectionsKt.first(commitList), (VcsShortCommitDetails)CollectionsKt.last(commitList)});
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            commit = (VcsShortCommitDetails)element$iv;
            boolean bl = false;
            Collection branches2 = ((MultipleCommitEditingData)commitEditingData).getLog().getContainingBranches((Hash)commit.getId(), commit.getRoot());
            if (branches2 == null) continue;
            if (!branches2.contains("HEAD")) {
                Presentation presentation7 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation7, (String)"e.presentation");
                presentation7.setDescription(GitBundle.message("rebase.log.commit.editing.action.commit.not.in.head.error.text", new Object[0]));
                return;
            }
            String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(repository, branches2);
            if (protectedBranch == null) continue;
            Presentation presentation8 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation8, (String)"e.presentation");
            presentation8.setDescription(GitBundle.message("rebase.log.commit.editing.action.commit.pushed.to.protected.branch.error.text", protectedBranch));
            return;
        }
        ProhibitRebaseDuringRebasePolicy policy = this.getProhibitRebaseDuringRebasePolicy();
        if (!Intrinsics.areEqual((Object)policy, (Object)ProhibitRebaseDuringRebasePolicy.Allow.INSTANCE) && policy instanceof ProhibitRebaseDuringRebasePolicy.Prohibit && (message = this.getProhibitedStateMessage(commitEditingData, ((ProhibitRebaseDuringRebasePolicy.Prohibit)policy).getOperation())) != null) {
            Presentation presentation9 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation9, (String)"e.presentation");
            presentation9.setDescription(message);
            return;
        }
        Presentation presentation10 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation10, (String)"e.presentation");
        presentation10.setEnabledAndVisible(true);
        this.update(e, commitEditingData);
    }

    private final boolean isRootOrMerge(VcsShortCommitDetails $this$isRootOrMerge) {
        return $this$isRootOrMerge.getParents().size() != 1;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CommitEditingDataCreationResult<T> commitEditingDataCreationResult = this.createCommitEditingData(e);
        if (commitEditingDataCreationResult == null) {
            throw new NullPointerException("null cannot be cast to non-null type git4idea.rebase.log.GitCommitEditingActionBase.CommitEditingDataCreationResult.Created<T>");
        }
        Object commitEditingRequirements = ((CommitEditingDataCreationResult.Created)commitEditingDataCreationResult).getData();
        String description = this.checkCommitsEditingAvailability(commitEditingRequirements);
        if (description != null) {
            Messages.showErrorDialog((Project)((MultipleCommitEditingData)commitEditingRequirements).getProject(), (String)description, (String)this.getFailureTitle());
            return;
        }
        this.actionPerformedAfterChecks(commitEditingRequirements);
    }

    @Nls
    @Nullable
    protected String checkCommitsEditingAvailability(@NotNull T commitEditingData) {
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
        String description = this.checkHeadLinearHistory((MultipleCommitEditingData)commitEditingData);
        if (description != null) {
            return description;
        }
        VcsShortCommitDetails lastCommit = (VcsShortCommitDetails)CollectionsKt.last(((MultipleCommitEditingData)commitEditingData).getSelectedCommitList());
        VcsLogData vcsLogData = ((MultipleCommitEditingData)commitEditingData).getLogData();
        VirtualFile virtualFile = lastCommit.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"lastCommit.root");
        Hash hash = (Hash)lastCommit.getId();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"lastCommit.id");
        List<String> branches2 = Companion.findContainingBranches$intellij_vcs_git(vcsLogData, virtualFile, hash);
        String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(((MultipleCommitEditingData)commitEditingData).getRepository(), (Collection<String>)branches2);
        if (protectedBranch != null) {
            return GitBundle.message("rebase.log.commit.editing.action.commit.pushed.to.protected.branch.error.text", protectedBranch);
        }
        return null;
    }

    private final CommitId getCommitIdByNodeId(VcsLogData data, PermanentGraphImpl<Integer> permanentGraph, int nodeId) {
        Object object = permanentGraph.getPermanentCommitsInfo().getCommitId(nodeId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"permanentGraph.permanent\u2026sInfo.getCommitId(nodeId)");
        CommitId commitId = data.getCommitId(((Number)object).intValue());
        Intrinsics.checkNotNull((Object)commitId);
        return commitId;
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    private final String checkHeadLinearHistory(MultipleCommitEditingData commitEditingData) {
        void description;
        void $this$mapTo$iv$iv;
        Project project = commitEditingData.getProject();
        VirtualFile virtualFile = commitEditingData.getRepository().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commitEditingData.repository.root");
        VirtualFile root = virtualFile;
        VcsLogData logData = commitEditingData.getLogData();
        DataPack dataPack = logData.getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"logData.dataPack");
        DataPack dataPack2 = dataPack;
        List<VcsShortCommitDetails> commits2 = commitEditingData.getSelectedCommitList();
        PermanentGraph permanentGraph = dataPack2.getPermanentGraph();
        if (permanentGraph == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl<kotlin.Int>");
        }
        PermanentGraphImpl permanentGraph2 = (PermanentGraphImpl)permanentGraph;
        PermanentCommitsInfoImpl permanentCommitsInfoImpl = permanentGraph2.getPermanentCommitsInfo();
        Intrinsics.checkNotNullExpressionValue((Object)permanentCommitsInfoImpl, (String)"permanentGraph.permanentCommitsInfo");
        PermanentCommitsInfoImpl commitsInfo = permanentCommitsInfoImpl;
        Iterable $this$map$iv = commits2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsShortCommitDetails vcsShortCommitDetails = (VcsShortCommitDetails)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = logData.getCommitIndex((Hash)it.getId(), root);
            collection.add(n);
        }
        List commitIndices = (List)destination$iv$iv;
        $this$map$iv = new Ref.ObjectRef();
        ((Ref.ObjectRef)$this$map$iv).element = null;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, commitsInfo, commitIndices, dataPack2, root, logData, permanentGraph2, (Ref.ObjectRef)description){
            final /* synthetic */ GitCommitEditingActionBase this$0;
            final /* synthetic */ PermanentCommitsInfoImpl $commitsInfo;
            final /* synthetic */ List $commitIndices;
            final /* synthetic */ DataPack $dataPack;
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ VcsLogData $logData;
            final /* synthetic */ PermanentGraphImpl $permanentGraph;
            final /* synthetic */ Ref.ObjectRef $description;

            public final void run() {
                Set set = this.$commitsInfo.convertToNodeIds((Collection)this.$commitIndices);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commitsInfo.convertToNodeIds(commitIndices)");
                Set commitNodeIds = CollectionsKt.toMutableSet((Iterable)set);
                VcsRef vcsRef = VcsLogUtil.findBranch((RefsModel)this.$dataPack.getRefsModel(), (VirtualFile)this.$root, (String)"HEAD");
                Intrinsics.checkNotNull((Object)vcsRef);
                Intrinsics.checkNotNullExpressionValue((Object)vcsRef, (String)"VcsLogUtil.findBranch(da\u2026el, root, GitUtil.HEAD)!!");
                VcsRef headRef = vcsRef;
                int headIndex = this.$logData.getCommitIndex(headRef.getCommitHash(), this.$root);
                int headId = this.$commitsInfo.getNodeId((Object)headIndex);
                Comparable comparable = CollectionsKt.max((Iterable)commitNodeIds);
                Intrinsics.checkNotNull((Object)comparable);
                int maxNodeId = ((Number)((Object)comparable)).intValue();
                LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph((LinearGraph)((LinearGraph)this.$permanentGraph.getLinearGraph()));
                Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"LinearGraphUtils.asLiteL\u2026rmanentGraph.linearGraph)");
                LiteLinearGraph graph = liteLinearGraph;
                BitSetFlags used = new BitSetFlags(this.$permanentGraph.getLinearGraph().nodesCount());
                new DfsWalk((Collection)CollectionsKt.listOf((Object)headId), graph, (Flags)used).walk(true, (Function1)new Function1<Integer, Boolean>(this, graph, maxNodeId, commitNodeIds){
                    final /* synthetic */ checkHeadLinearHistory.1 this$0;
                    final /* synthetic */ LiteLinearGraph $graph;
                    final /* synthetic */ int $maxNodeId;
                    final /* synthetic */ Set $commitNodeIds;

                    public final boolean invoke(int nodeId) {
                        boolean bl;
                        ProgressManager.checkCanceled();
                        List list2 = this.$graph.getNodes(nodeId, LiteLinearGraph.NodeFilter.DOWN);
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"graph.getNodes(nodeId, L\u2026earGraph.NodeFilter.DOWN)");
                        List parents = list2;
                        if (parents.size() != 1) {
                            CommitId commit = GitCommitEditingActionBase.access$getCommitIdByNodeId(this.this$0.this$0, this.this$0.$logData, this.this$0.$permanentGraph, nodeId);
                            this.this$0.$description.element = GitBundle.message("rebase.log.multiple.commit.editing.action.specific.commit.root.or.merge", commit.getHash(), parents.size());
                            bl = false;
                        } else if (nodeId > this.$maxNodeId) {
                            GitCommitEditingActionBase gitCommitEditingActionBase = this.this$0.this$0;
                            VcsLogData vcsLogData = this.this$0.$logData;
                            PermanentGraphImpl permanentGraphImpl = this.this$0.$permanentGraph;
                            Object object = CollectionsKt.first((Iterable)this.$commitNodeIds);
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"commitNodeIds.first()");
                            CommitId commitNotInHead = GitCommitEditingActionBase.access$getCommitIdByNodeId(gitCommitEditingActionBase, vcsLogData, permanentGraphImpl, ((Number)object).intValue());
                            this.this$0.$description.element = GitBundle.message("rebase.log.multiple.commit.editing.action.specific.commit.not.in.head", commitNotInHead.getHash());
                            bl = false;
                        } else {
                            this.$commitNodeIds.remove(nodeId);
                            Collection collection = this.$commitNodeIds;
                            boolean bl2 = false;
                            bl = !collection.isEmpty();
                        }
                        return bl;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$graph = liteLinearGraph;
                        this.$maxNodeId = n;
                        this.$commitNodeIds = set;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = gitCommitEditingActionBase;
                this.$commitsInfo = permanentCommitsInfoImpl;
                this.$commitIndices = list2;
                this.$dataPack = dataPack;
                this.$root = virtualFile;
                this.$logData = vcsLogData;
                this.$permanentGraph = permanentGraphImpl;
                this.$description = objectRef;
            }
        }, GitBundle.message("rebase.log.multiple.commit.editing.action.progress.indicator.action.possibility.check", new Object[0]), true, project);
        return (String)description.element;
    }

    /*
     * WARNING - void declaration
     */
    private final CommitEditingDataCreationResult<T> createCommitEditingData(AnActionEvent e) {
        void $this$mapTo$iv$iv;
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogData logDataProvider = (VcsLogData)e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        VcsLogUi logUi2 = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || log == null || logDataProvider == null || logUi2 == null) {
            return new CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        List list2 = log.getSelectedShortDetails();
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean $i$a$-takeIf-GitCommitEditingActionBase$createCommitEditingData$commitList$22 = false;
        List list3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"it");
        Collection collection = list3;
        boolean bl3 = false;
        List list4 = !collection.isEmpty() ? list2 : null;
        if (list4 == null) {
            return new CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"log.selectedShortDetails\u2026 } ?: return Prohibited()");
        List commitList = list4;
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitUtil.getRepositoryManager(project)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        Iterable $this$map$iv = commitList;
        boolean $i$f$map = false;
        Iterable $i$a$-takeIf-GitCommitEditingActionBase$createCommitEditingData$commitList$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl4 = false;
            void v3 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            VirtualFile virtualFile = v3.getRoot();
            collection2.add(virtualFile);
        }
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        if (virtualFile == null) {
            return new CommitEditingDataCreationResult.Prohibited(GitBundle.message("rebase.log.multiple.commit.editing.action.disabled.multiple.repository.description", commitList.size()));
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commitList.map { it.root\u2026\", commitList.size)\n    )");
        VirtualFile root = virtualFile;
        GitRepository gitRepository = (GitRepository)repositoryManager.getRepositoryForRootQuick(root);
        if (gitRepository == null) {
            return new CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repositoryManager.getRep\u2026t) ?: return Prohibited()");
        GitRepository repository = gitRepository;
        if (repositoryManager.isExternal(repository)) {
            return new CommitEditingDataCreationResult.Prohibited(GitBundle.message("rebase.log.multiple.commit.editing.action.disabled.external.repository.description", commitList.size()));
        }
        return this.createCommitEditingData(repository, log, logDataProvider, logUi2);
    }

    @Nullable
    protected String getProhibitedStateMessage(@NotNull T commitEditingData, @Nls @NotNull String operation) {
        String string;
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        switch (GitCommitEditingActionBase$WhenMappings.$EnumSwitchMapping$0[((MultipleCommitEditingData)commitEditingData).getRepository().getState().ordinal()]) {
            case 1: 
            case 2: {
                string = null;
                break;
            }
            case 3: {
                string = GitBundle.message("rebase.log.commit.editing.action.prohibit.state.rebasing", operation);
                break;
            }
            case 4: {
                string = GitBundle.message("rebase.log.commit.editing.action.prohibit.state.merging", operation);
                break;
            }
            case 5: {
                string = GitBundle.message("rebase.log.commit.editing.action.prohibit.state.grafting", operation);
                break;
            }
            case 6: {
                string = GitBundle.message("rebase.log.commit.editing.action.prohibit.state.reverting", operation);
                break;
            }
            default: {
                string = GitBundle.message("rebase.log.commit.editing.action.prohibit.state", operation);
            }
        }
        return string;
    }

    public static final /* synthetic */ CommitId access$getCommitIdByNodeId(GitCommitEditingActionBase $this, VcsLogData data, PermanentGraphImpl permanentGraph, int nodeId) {
        return $this.getCommitIdByNodeId(data, (PermanentGraphImpl<Integer>)permanentGraph, nodeId);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "", "repository", "Lgit4idea/repo/GitRepository;", "log", "Lcom/intellij/vcs/log/VcsLog;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsLog;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/VcsLogUi;)V", "getLog", "()Lcom/intellij/vcs/log/VcsLog;", "getLogData", "()Lcom/intellij/vcs/log/data/VcsLogData;", "getLogUi", "()Lcom/intellij/vcs/log/VcsLogUi;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepository", "()Lgit4idea/repo/GitRepository;", "selectedCommitList", "", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "getSelectedCommitList", "()Ljava/util/List;", "intellij.vcs.git"})
    public static class MultipleCommitEditingData {
        @NotNull
        private final Project project;
        @NotNull
        private final List<VcsShortCommitDetails> selectedCommitList;
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final VcsLog log;
        @NotNull
        private final VcsLogData logData;
        @NotNull
        private final VcsLogUi logUi;

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final List<VcsShortCommitDetails> getSelectedCommitList() {
            return this.selectedCommitList;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final VcsLog getLog() {
            return this.log;
        }

        @NotNull
        public final VcsLogData getLogData() {
            return this.logData;
        }

        @NotNull
        public final VcsLogUi getLogUi() {
            return this.logUi;
        }

        public MultipleCommitEditingData(@NotNull GitRepository repository, @NotNull VcsLog log, @NotNull VcsLogData logData, @NotNull VcsLogUi logUi2) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Intrinsics.checkNotNullParameter((Object)logUi2, (String)"logUi");
            this.repository = repository;
            this.log = log;
            this.logData = logData;
            this.logUi = logUi2;
            Project project = this.repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
            this.project = project;
            List list2 = this.log.getSelectedShortDetails();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"log.selectedShortDetails");
            this.selectedCommitList = list2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "", "()V", "Allow", "Prohibit", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Allow;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "intellij.vcs.git"})
    protected static abstract class ProhibitRebaseDuringRebasePolicy {
        private ProhibitRebaseDuringRebasePolicy() {
        }

        public /* synthetic */ ProhibitRebaseDuringRebasePolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Allow;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "()V", "intellij.vcs.git"})
        public static final class Allow
        extends ProhibitRebaseDuringRebasePolicy {
            @NotNull
            public static final Allow INSTANCE;

            private Allow() {
                super(null);
            }

            static {
                Allow allow;
                INSTANCE = allow = new Allow();
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "operation", "", "(Ljava/lang/String;)V", "getOperation", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Prohibit
        extends ProhibitRebaseDuringRebasePolicy {
            @NotNull
            private final String operation;

            @NotNull
            public final String getOperation() {
                return this.operation;
            }

            public Prohibit(@Nls @NotNull String operation) {
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                super(null);
                this.operation = operation;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "", "()V", "Created", "Prohibited", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Created;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Prohibited;", "intellij.vcs.git"})
    protected static abstract class CommitEditingDataCreationResult<T extends MultipleCommitEditingData> {
        private CommitEditingDataCreationResult() {
        }

        public /* synthetic */ CommitEditingDataCreationResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Created;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "data", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)V", "getData", "()Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "intellij.vcs.git"})
        public static final class Created<T extends MultipleCommitEditingData>
        extends CommitEditingDataCreationResult<T> {
            @NotNull
            private final T data;

            @NotNull
            public final T getData() {
                return this.data;
            }

            public Created(@NotNull T data) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                super(null);
                this.data = data;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0011\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Prohibited;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "description", "", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Prohibited<T extends MultipleCommitEditingData>
        extends CommitEditingDataCreationResult<T> {
            @Nullable
            private final String description;

            @Nullable
            public final String getDescription() {
                return this.description;
            }

            public Prohibited(@Nls @Nullable String description) {
                super(null);
                this.description = description;
            }

            public /* synthetic */ Prohibited(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                this(string);
            }

            public Prohibited() {
                this(null, 1, null);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$Companion;", "", "()V", "findContainingBranches", "", "", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "findContainingBranches$intellij_vcs_git", "intellij.vcs.git"})
    public static final class Companion {
        @NotNull
        public final List<String> findContainingBranches$intellij_vcs_git(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            ContainingBranchesGetter containingBranchesGetter = data.getContainingBranchesGetter();
            Intrinsics.checkNotNullExpressionValue((Object)containingBranchesGetter, (String)"data.containingBranchesGetter");
            ContainingBranchesGetter branchesGetter = containingBranchesGetter;
            List branches2 = branchesGetter.getContainingBranchesQuickly(root, hash);
            if (branches2 == null) {
                Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(branchesGetter, root, hash){
                    final /* synthetic */ ContainingBranchesGetter $branchesGetter;
                    final /* synthetic */ VirtualFile $root;
                    final /* synthetic */ Hash $hash;

                    public final List<String> compute() {
                        return this.$branchesGetter.getContainingBranchesSynchronously(this.$root, this.$hash);
                    }
                    {
                        this.$branchesGetter = containingBranchesGetter;
                        this.$root = virtualFile;
                        this.$hash = hash;
                    }
                }, GitBundle.message("rebase.log.commit.editing.action.progress.containing.branches.title", new Object[0]), true, data.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ProgressManager.getInsta\u2026 data.project\n          )");
                return (List)object;
            }
            return branches2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

