/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.actions.GitSingleCommitActionGroup;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class GitLogBranchOperationsActionGroup
extends GitSingleCommitActionGroup {
    private static final int MAX_BRANCH_GROUPS = 2;
    private static final int MAX_TAG_GROUPS = 1;

    public GitLogBranchOperationsActionGroup() {
        this.setPopup(false);
    }

    @Override
    public AnAction @NotNull [] getChildren(@NotNull AnActionEvent e, @NotNull Project project, @NotNull VcsLog log, @NotNull GitRepository root, @NotNull CommitId commit) {
        if (e == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(1);
        }
        if (log == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(2);
        }
        if (root == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(3);
        }
        if (commit == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(4);
        }
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        List refs = (List)e.getData(VcsLogDataKeys.VCS_LOG_REFS);
        if (logUI == null || refs == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(5);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List branchRefs = ContainerUtil.filter((Collection)refs, ref -> {
            if (ref.getType() == GitRefManager.LOCAL_BRANCH) {
                return !ref.getName().equals(root.getCurrentBranchName());
            }
            return ref.getType() == GitRefManager.REMOTE_BRANCH;
        });
        List tagRefs = ContainerUtil.filter((Collection)refs, ref -> ref.getType() == GitRefManager.TAG);
        VcsLogProvider provider = (VcsLogProvider)logUI.getDataPack().getLogProviders().get(root.getRoot());
        if (provider != null) {
            VcsLogRefManager refManager = provider.getReferenceManager();
            Comparator comparator = refManager.getLabelsOrderComparator();
            ContainerUtil.sort((List)branchRefs, (Comparator)comparator);
            ContainerUtil.sort((List)tagRefs, (Comparator)comparator);
        }
        ArrayList<DefaultActionGroup> groups = new ArrayList<DefaultActionGroup>();
        if (!branchRefs.isEmpty()) {
            GitVcsSettings settings = GitVcsSettings.getInstance(project);
            boolean showBranchesPopup = branchRefs.size() > 2;
            GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
            List<GitRepository> allRepositories = repositoryManager.getRepositories();
            ObjectOpenCustomHashSet commonBranches = new ObjectOpenCustomHashSet(GitReference.BRANCH_NAME_HASHING_STRATEGY);
            for (GitLocalBranch gitLocalBranch : GitBranchUtil.getCommonLocalBranches(allRepositories)) {
                commonBranches.add(gitLocalBranch.getName());
            }
            for (GitRemoteBranch gitRemoteBranch : GitBranchUtil.getCommonRemoteBranches(allRepositories)) {
                commonBranches.add(gitRemoteBranch.getName());
            }
            ArrayList<AnAction> branchActionGroups = new ArrayList<AnAction>();
            for (VcsRef ref2 : branchRefs) {
                branchActionGroups.add(GitLogBranchOperationsActionGroup.createBranchGroup(project, ref2, root, allRepositories, (Set<String>)commonBranches, settings, showBranchesPopup));
            }
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup(GitBundle.message("branches.branches", new Object[0]), branchActionGroups);
            defaultActionGroup.setPopup(showBranchesPopup);
            groups.add(defaultActionGroup);
        }
        if (!tagRefs.isEmpty()) {
            boolean showTagsPopup = tagRefs.size() > 1;
            ArrayList<AnAction> tagActionGroups = new ArrayList<AnAction>();
            for (VcsRef ref3 : tagRefs) {
                tagActionGroups.add(GitLogBranchOperationsActionGroup.createTagGroup(project, ref3, root, showTagsPopup));
            }
            DefaultActionGroup tagsGroup = new DefaultActionGroup(GitBundle.message("branches.tags", new Object[0]), tagActionGroups);
            tagsGroup.setPopup(showTagsPopup);
            groups.add(tagsGroup);
        }
        AnAction[] anActionArray = groups.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(6);
        }
        return anActionArray;
    }

    @NotNull
    private static AnAction createBranchGroup(@NotNull Project project, @NotNull VcsRef ref, @NotNull GitRepository repository, @NotNull List<? extends GitRepository> allRepositories, @NotNull Set<String> commonBranches, @NotNull GitVcsSettings settings, boolean showBranchesPopup) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(7);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(8);
        }
        if (repository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(9);
        }
        if (allRepositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(10);
        }
        if (commonBranches == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(12);
        }
        boolean isSyncBranch = settings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC && allRepositories.size() > 1 && commonBranches.contains(ref.getName());
        boolean isLocal = ref.getType() == GitRefManager.LOCAL_BRANCH;
        ArrayList<Object> actions2 = new ArrayList<Object>(3);
        if (isSyncBranch) {
            ActionGroup allReposActions = GitLogBranchOperationsActionGroup.createBranchActions(project, allRepositories, ref, repository, isLocal);
            allReposActions.getTemplatePresentation().setText(GitBundle.message("in.branches.all.repositories", new Object[0]));
            allReposActions.setPopup(true);
            actions2.add(allReposActions);
            actions2.add(Separator.getInstance());
        }
        ActionGroup singleRepoActions = GitLogBranchOperationsActionGroup.createBranchActions(project, Collections.singletonList(repository), ref, repository, isLocal);
        singleRepoActions.setPopup(false);
        actions2.add(singleRepoActions);
        String text = showBranchesPopup ? ref.getName() : GitBundle.message("branches.branch.0", ref.getName());
        DefaultActionGroup group = new DefaultActionGroup(actions2);
        group.getTemplatePresentation().setText(text, false);
        group.setPopup(true);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(13);
        }
        return defaultActionGroup;
    }

    @NotNull
    private static AnAction createTagGroup(@NotNull Project project, @NotNull VcsRef ref, @NotNull GitRepository repository, boolean showTagsPopup) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(14);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(15);
        }
        if (repository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(16);
        }
        ActionGroup singleRepoActions = GitLogBranchOperationsActionGroup.createTagActions(project, Collections.singletonList(repository), ref);
        singleRepoActions.setPopup(false);
        String text = showTagsPopup ? ref.getName() : GitBundle.message("branches.tag.0", ref.getName());
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{singleRepoActions});
        group.getTemplatePresentation().setText(text, false);
        group.setPopup(true);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(17);
        }
        return defaultActionGroup;
    }

    @NotNull
    private static ActionGroup createBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull VcsRef ref, @NotNull GitRepository selectedRepository, boolean isLocal) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(18);
        }
        if (repositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(19);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(20);
        }
        if (selectedRepository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(21);
        }
        if (isLocal) {
            return new GitBranchPopupActions.LocalBranchActions(project, repositories, ref.getName(), selectedRepository);
        }
        return new GitBranchPopupActions.RemoteBranchActions(project, repositories, ref.getName(), selectedRepository);
    }

    @NotNull
    private static ActionGroup createTagActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull VcsRef ref) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(22);
        }
        if (repositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(23);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(24);
        }
        return new GitBranchPopupActions.TagActions(project, repositories, ref.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 7: 
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitLogBranchOperationsActionGroup";
                break;
            }
            case 8: 
            case 15: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepositories";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonBranches";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitLogBranchOperationsActionGroup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createBranchGroup";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 17: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createBranchGroup";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTagGroup";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createBranchActions";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createTagActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

