/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.util.DocumentUtil;
import com.jetbrains.cidr.lang.formatting.OCPureClangFormat;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/formatting/OCPureClangFormat;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.cidr.clangFormat"})
public final class OCPureClangFormat
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(AnAction.getEventProject((AnActionEvent)e) != null);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void hasSelection;
        void file;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.getDataContext()");
        DataContext dataContext2 = dataContext;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"CommonDataKeys.PROJECT.g\u2026ta(dataContext) ?: return");
        Project project2 = project;
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        PsiDirectory dir = null;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        if (editor != null) {
            Project project3 = project2;
            Intrinsics.checkNotNull((Object)project3);
            file.element = PsiDocumentManager.getInstance((Project)project3).getPsiFile(editor.getDocument());
            if ((PsiFile)file.element == null) {
                return;
            }
            dir = ((PsiFile)file.element).getContainingDirectory();
            hasSelection.element = editor.getSelectionModel().hasSelection();
        }
        if ((PsiFile)file.element == null || editor == null) {
            return;
        }
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable((Ref.ObjectRef)file, (Ref.BooleanRef)hasSelection, editor){
            final /* synthetic */ Ref.ObjectRef $file;
            final /* synthetic */ Ref.BooleanRef $hasSelection;
            final /* synthetic */ Editor $editor;

            public final void run() {
                ExternalFormatProcessor.findExternalFormatter((String)"ClangFormat").ifPresent(new Consumer(this){
                    final /* synthetic */ actionPerformed.1 this$0;

                    public final void accept(@NotNull ExternalFormatProcessor clangFormat) {
                        TextRange textRange;
                        Intrinsics.checkNotNullParameter((Object)clangFormat, (String)"clangFormat");
                        PsiFile psiFile = (PsiFile)this.this$0.$file.element;
                        if (this.this$0.$hasSelection.element) {
                            SelectionModel selectionModel = this.this$0.$editor.getSelectionModel();
                            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.getSelectionModel()");
                            int n = selectionModel.getSelectionStart();
                            SelectionModel selectionModel2 = this.this$0.$editor.getSelectionModel();
                            Intrinsics.checkNotNullExpressionValue((Object)selectionModel2, (String)"editor.getSelectionModel()");
                            textRange = new TextRange(n, selectionModel2.getSelectionEnd());
                        } else {
                            textRange = new TextRange(0, ((PsiFile)this.this$0.$file.element).getTextLength());
                        }
                        clangFormat.format(psiFile, textRange, false, false, false);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$file = objectRef;
                this.$hasSelection = booleanRef;
                this.$editor = editor;
            }
        });
    }
}

