/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.PathsBrowserDialogProvider;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.intellij.remote.ext.VagrantCredentialsHandler;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.CredentialsEditorProvider;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsLanguageContributor;
import com.jetbrains.plugins.remotesdk.VagrantRemoteCredentialsEditor;
import com.jetbrains.plugins.remotesdk.ui.SshBrowseActionListenerUtil;
import java.util.function.Supplier;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0002H\u0016J*\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u0016J=\u0010\u001c\u001a\u00020\u001d2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\u001f2\r\b\u0001\u0010 \u001a\u00070\u0012\u00a2\u0006\u0002\b!2\u0012\u0010\"\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030$0#H\u0016\u00a8\u0006&"}, d2={"Lcom/jetbrains/plugins/remotesdk/VagrantCredentialsType;", "Lcom/intellij/remote/CredentialsType;", "Lcom/intellij/remote/VagrantBasedCredentialsHolder;", "Lcom/intellij/remote/ui/CredentialsEditorProvider;", "Lcom/intellij/remote/ext/PathsBrowserDialogProvider;", "()V", "createCredentials", "createEditor", "Lcom/intellij/remote/ext/CredentialsEditor;", "project", "Lcom/intellij/openapi/project/Project;", "languageContribution", "Lcom/intellij/remote/ext/CredentialsLanguageContribution;", "parentForm", "Lcom/intellij/remote/ui/RemoteSdkEditorForm;", "getCredentialsKey", "Lcom/intellij/openapi/util/Key;", "getDefaultInterpreterPath", "", "bundleAccessor", "Lcom/intellij/remote/ui/BundleAccessor;", "getHandler", "Lcom/intellij/remote/ext/RemoteCredentialsHandler;", "credentials", "getWeight", "", "isAvailable", "", "showPathsBrowserDialog", "", "textField", "Ljavax/swing/JTextField;", "dialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "supplier", "Ljava/util/function/Supplier;", "Lcom/intellij/remote/RemoteSdkAdditionalData;", "Companion", "intellij.remoteRun"})
public final class VagrantCredentialsType
extends CredentialsType<VagrantBasedCredentialsHolder>
implements CredentialsEditorProvider,
PathsBrowserDialogProvider {
    @NlsSafe
    @NotNull
    public static final String VAGRANT_CREDENTIALS_TYPE_NAME = "Vagrant";
    @NonNls
    @NotNull
    public static final String VAGRANT_PREFIX = "vagrant://";
    @NotNull
    private static final Key<VagrantBasedCredentialsHolder> VAGRANT_BASED_CREDENTIALS;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public VagrantBasedCredentialsHolder createCredentials() {
        return new VagrantBasedCredentialsHolder();
    }

    @NotNull
    public Key<VagrantBasedCredentialsHolder> getCredentialsKey() {
        return VAGRANT_BASED_CREDENTIALS;
    }

    @NotNull
    public RemoteCredentialsHandler getHandler(@NotNull VagrantBasedCredentialsHolder credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        return (RemoteCredentialsHandler)new VagrantCredentialsHandler(credentials);
    }

    public boolean isAvailable(@Nullable CredentialsLanguageContribution<?> languageContribution) {
        return VagrantSupport.getInstance() != null && languageContribution instanceof VagrantCredentialsLanguageContributor;
    }

    @NotNull
    public CredentialsEditor<?> createEditor(@Nullable Project project, @NotNull CredentialsLanguageContribution<?> languageContribution, @NotNull RemoteSdkEditorForm parentForm) {
        Intrinsics.checkNotNullParameter(languageContribution, (String)"languageContribution");
        Intrinsics.checkNotNullParameter((Object)parentForm, (String)"parentForm");
        VagrantSupport vagrantSupport = VagrantSupport.getInstance();
        if (vagrantSupport == null) {
            throw (Throwable)new IllegalStateException("Vagrant support is not available");
        }
        Intrinsics.checkNotNullExpressionValue((Object)vagrantSupport, (String)"VagrantSupport.getInstan\u2026upport is not available\")");
        VagrantSupport vagrantSupport2 = vagrantSupport;
        return new VagrantRemoteCredentialsEditor(vagrantSupport2, parentForm, project);
    }

    @NotNull
    public String getDefaultInterpreterPath(@NotNull BundleAccessor bundleAccessor) {
        Intrinsics.checkNotNullParameter((Object)bundleAccessor, (String)"bundleAccessor");
        String string = bundleAccessor.message("remote.interpreter.default.interpreter.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundleAccessor.message(\"\u2026efault.interpreter.path\")");
        return string;
    }

    public void showPathsBrowserDialog(@Nullable Project project, @NotNull JTextField textField, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NotNull Supplier<? extends RemoteSdkAdditionalData<?>> supplier) {
        Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        SshBrowseActionListenerUtil.showBrowseDialog(project, textField, dialogTitle, false, supplier);
    }

    public int getWeight() {
        return 40;
    }

    public VagrantCredentialsType() {
        super(VAGRANT_CREDENTIALS_TYPE_NAME, VAGRANT_PREFIX);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"VAGRANT_BASED_CREDENTIALS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<VagrantBasedC\u2026GRANT_BASED_CREDENTIALS\")");
        VAGRANT_BASED_CREDENTIALS = key;
    }

    @JvmStatic
    @NotNull
    public static final VagrantCredentialsType getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f8\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000b8\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugins/remotesdk/VagrantCredentialsType$Companion;", "", "()V", "VAGRANT_BASED_CREDENTIALS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/remote/VagrantBasedCredentialsHolder;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getVAGRANT_BASED_CREDENTIALS", "()Lcom/intellij/openapi/util/Key;", "VAGRANT_CREDENTIALS_TYPE_NAME", "", "Lcom/intellij/openapi/util/NlsSafe;", "VAGRANT_PREFIX", "getInstance", "Lcom/jetbrains/plugins/remotesdk/VagrantCredentialsType;", "intellij.remoteRun"})
    public static final class Companion {
        @NotNull
        public final Key<VagrantBasedCredentialsHolder> getVAGRANT_BASED_CREDENTIALS() {
            return VAGRANT_BASED_CREDENTIALS;
        }

        @JvmStatic
        @NotNull
        public final VagrantCredentialsType getInstance() {
            Object object = CredentialsType.EP_NAME.findExtensionOrFail(VagrantCredentialsType.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EP_NAME.findExtensionOrF\u2026dentialsType::class.java)");
            return (VagrantCredentialsType)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

