/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.FormWithAlignableLabelsColumn;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.RemoteSdkCredentialsProducerImpl;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkUIUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteSdkByDeploymentForm;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import java.awt.Component;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebDeploymentCredentialsEditor
implements CredentialsEditor<WebDeploymentCredentialsHolder>,
FormWithAlignableLabelsColumn {
    @Nullable
    private final Project myProject;
    @NotNull
    private final RemoteSdkByDeploymentForm myDeploymentForm;

    public WebDeploymentCredentialsEditor(@Nullable Project project, @NotNull RemoteSdkEditorForm parentForm) {
        if (parentForm == null) {
            WebDeploymentCredentialsEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDeploymentForm = new RemoteSdkByDeploymentForm(project, parentForm);
    }

    @NotNull
    public String getName() {
        String string = RemoteSdkBundle.message("remote.interpreter.deployment.configuration.editor.name", new Object[0]);
        if (string == null) {
            WebDeploymentCredentialsEditor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public JPanel getMainPanel() {
        return this.myDeploymentForm.getMainPanel();
    }

    public void onSelected() {
        this.myDeploymentForm.deploymentSelected();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myDeploymentForm.getPreferredFocusedComponent(), true));
    }

    public ValidationInfo validate() {
        Ref configRef = Ref.create();
        ValidationInfo result = this.validate((Ref<FileTransferConfig>)configRef);
        if (configRef.isNull()) {
            return result;
        }
        if (result != null) {
            return result;
        }
        return SshCredentialsVerifier.wrapValidation(() -> ((FileTransferConfig)configRef.get()).validateSlow(500L, false));
    }

    @NlsContexts.DialogMessage
    public String validateFinal(@NotNull Supplier<? extends RemoteSdkAdditionalData<?>> supplier, @NotNull Consumer<String> helpersPathUpdateCallback) {
        if (supplier == null) {
            WebDeploymentCredentialsEditor.$$$reportNull$$$0(2);
        }
        if (helpersPathUpdateCallback == null) {
            WebDeploymentCredentialsEditor.$$$reportNull$$$0(3);
        }
        return CreateRemoteSdkUIUtil.validateUsingRemoteSdkCredentials(this.myProject, supplier, helpersPathUpdateCallback);
    }

    @Nullable
    private ValidationInfo validate(Ref<FileTransferConfig> configRef) {
        ValidationInfo validationInfo = this.myDeploymentForm.validate();
        if (validationInfo != null) {
            return validationInfo;
        }
        String webServerId = this.myDeploymentForm.getDeploymentCredentials().getWebServerConfigId();
        RemoteCredentials sshCredentials = RemoteSdkCredentialsProducerImpl.getCredentialsBySftpServerId(this.myProject, webServerId);
        if (sshCredentials != null) {
            configRef.set((Object)WebDeploymentCredentialsEditor.credentialsAsFileTransferConfig(sshCredentials));
        }
        return null;
    }

    public void saveCredentials(WebDeploymentCredentialsHolder credentials) {
        WebDeploymentCredentialsHolder sourceCredentials = this.myDeploymentForm.getDeploymentCredentials();
        if (sourceCredentials != null && !StringUtil.isEmpty((String)sourceCredentials.getWebServerConfigId())) {
            credentials.copyFrom(sourceCredentials);
        }
    }

    public void init(WebDeploymentCredentialsHolder credentials) {
        this.myDeploymentForm.init(credentials);
    }

    @NotNull
    public List<JBLabel> getLabelsColumn() {
        ImmutableList immutableList = ContainerUtil.immutableList((Object[])new JBLabel[]{this.myDeploymentForm.getNavigatableLabel()});
        if (immutableList == null) {
            WebDeploymentCredentialsEditor.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @NotNull
    public static FileTransferConfig credentialsAsFileTransferConfig(@NotNull RemoteCredentials remoteCredentials) {
        if (remoteCredentials == null) {
            WebDeploymentCredentialsEditor.$$$reportNull$$$0(5);
        }
        RemoteCredentialsVerifiableHolder credentials = new RemoteCredentialsVerifiableHolder();
        RemoteCredentialsHolder.copyRemoteCredentials((RemoteCredentials)remoteCredentials, (MutableRemoteCredentials)credentials);
        FileTransferConfig transferConfig = new FileTransferConfig((MutableRemoteCredentials)credentials);
        transferConfig.setAccessType(AccessType.SFTP);
        FileTransferConfig fileTransferConfig = transferConfig;
        if (fileTransferConfig == null) {
            WebDeploymentCredentialsEditor.$$$reportNull$$$0(6);
        }
        return fileTransferConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentForm";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/WebDeploymentCredentialsEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPathUpdateCallback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/WebDeploymentCredentialsEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsColumn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "credentialsAsFileTransferConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateFinal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "credentialsAsFileTransferConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

