/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.diagnostics;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.diagnostics.CdIndenter;
import com.jetbrains.cidr.cpp.diagnostics.CdWorkspaceEvents;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"collectCidrWorkspaces", "", "project", "Lcom/intellij/openapi/project/Project;", "collectOCWorkspaceEvents", "describeCMakeWorkspace", "", "workspace", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;", "log", "Lcom/jetbrains/cidr/cpp/diagnostics/CdIndenter;", "intellij.clion.diagnostics"})
public final class CdCidrWorkspaceKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String collectCidrWorkspaces(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CdIndenter log = new CdIndenter(0, 1, null);
        List workspaces = CidrWorkspaceManager.Companion.getInstance(project).getInitializedWorkspaces();
        log.put("Workspaces: ", workspaces.size());
        CdIndenter this_$iv = log;
        boolean $i$f$scope = false;
        this_$iv.indent();
        try {
            boolean bl = false;
            for (CidrWorkspace workspace : workspaces) {
                log.put(workspace.getClass());
                CdIndenter this_$iv2 = log;
                boolean $i$f$scope2 = false;
                this_$iv2.indent();
                try {
                    boolean bl2 = false;
                    log.put("Project path: " + workspace.getProjectPath());
                    log.put("Content root: " + workspace.getContentRoot());
                    if (!(workspace instanceof CMakeWorkspace)) continue;
                    CdCidrWorkspaceKt.describeCMakeWorkspace((CMakeWorkspace)workspace, log);
                }
                finally {
                    this_$iv2.unIndent();
                }
            }
        }
        finally {
            this_$iv.unIndent();
        }
        return log.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void describeCMakeWorkspace(@NotNull CMakeWorkspace workspace, @NotNull CdIndenter log) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        log.put("Auto reload enabled: " + workspace.getSettings().isAutoReloadEnabled());
        Collection collection = workspace.getProfileInfos();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"workspace.profileInfos");
        Collection profiles = collection;
        for (CMakeProfileInfo profileInfo : profiles) {
            CMakeSettings.Profile profile = profileInfo.getProfile();
            CdIndenter this_$iv = log;
            boolean $i$f$scope = false;
            this_$iv.indent();
            try {
                boolean bl = false;
                log.put("Profile: " + profile.getName());
                CdIndenter this_$iv2 = log;
                boolean $i$f$scope2 = false;
                this_$iv2.indent();
                try {
                    boolean bl2 = false;
                    log.put("buildType: " + profile.getBuildType());
                    log.put("toolchainName: " + profile.getToolchainName());
                    Object[] objectArray = new Object[1];
                    StringBuilder stringBuilder = new StringBuilder().append("effective toolchain: ");
                    Object object = profileInfo.getEnvironment();
                    if (object == null || (object = object.getToolchain()) == null || (object = object.getName()) == null) {
                        object = "UNKNOWN";
                    }
                    objectArray[0] = stringBuilder.append((String)object).toString();
                    log.put(objectArray);
                    log.put("generationOptions: " + profile.getGenerationOptions());
                    log.put("generationDir: " + profile.getGenerationDir());
                    log.put("effective generation dir: " + profileInfo.getGenerationDir());
                    log.put("buildOptions: " + profile.getBuildOptions());
                }
                finally {
                    this_$iv2.unIndent();
                }
            }
            finally {
                this_$iv.unIndent();
            }
        }
    }

    @NotNull
    public static final String collectOCWorkspaceEvents(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(CdWorkspaceEvents.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return ((CdWorkspaceEvents)object).getResult();
    }
}

