/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.doctest;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.GeneralIdBasedToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.testing.CidrMetaParam;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.doctest.CidrDoctestTestLinker;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CidrDoctestOutputToGeneralTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    @NonNls
    private static final String DOCTEST_TAG = "doctest";
    @NonNls
    private static final String TEST_SUITE_TAG = "TestSuite";
    @NonNls
    private static final String TEST_CASE_TAG = "TestCase";
    @NonNls
    private static final String SUBCASE_TAG = "SubCase";
    @NonNls
    private static final String OVERALL_RESULT_ASSERTS_TAG = "OverallResultsAsserts";
    @NonNls
    private static final String OVERALL_RESULTS_TEST_CASES_TAG = "OverallResultsTestCases";
    @NonNls
    private static final String EXPRESSION_TAG = "Expression";
    @NonNls
    private static final String ORIGINAL_TAG = "Original";
    @NonNls
    private static final String EXPANDED_TAG = "Expanded";
    @NonNls
    private static final String INFO_TAG = "Info";
    @NonNls
    private static final String TEXT_TAG = "Text";
    @NonNls
    private static final String MESSAGE_TAG = "Message";
    @NonNls
    private static final String EXCEPTION_TAG = "Exception";
    @NonNls
    private static final String NAME_ATTR = "name";
    @NonNls
    private static final String TAGS_ATTR = "tags";
    @NonNls
    private static final String DESCRIPTION_ATTR = "description";
    @NonNls
    private static final String TIMEOUT_ATTR = "timeout";
    @NonNls
    private static final String SKIPPED_ATTR = "skipped";
    @NonNls
    private static final String SHOULD_FAIL_ATTR = "should_fail";
    @NonNls
    private static final String MAY_FAIL_ATTR = "may_fail";
    @NonNls
    private static final String FILE_NAME_ATTR = "filename";
    @NonNls
    private static final String LINE_ATTR = "line";
    @NonNls
    private static final String TYPE_ATTR = "type";
    @NonNls
    private static final String SUCCESS_ATTR = "success";
    @NonNls
    private static final String SUCCESSES_ATTR = "successes";
    @NonNls
    private static final String FAILURES_ATTR = "failures";
    @NonNls
    private static final String EXPECTED_FAILURES_ATTR = "expected_failures";
    @NonNls
    private static final String CRASH_ATTR = "crash";
    @NonNls
    private static final String OUT_INDENT = "  ";
    private static final String[] ALL_TAGS = new String[]{"doctest", "TestSuite", "TestCase", "SubCase", "OverallResultsAsserts", "OverallResultsTestCases", "Expression", "Original", "Expanded", "Info", "Text", "Message", "Exception"};
    private static final String[] ALL_ATTRS = new String[]{"name", "description", "timeout", "tags", "success", "successes", "failures", "expected_failures", "crash", "filename", "line", "type", "skipped", "should_fail", "may_fail"};
    private volatile Future<Boolean> myXMLParser;
    private volatile PipedOutputStream myPipedOutStream;
    private volatile ServiceMessageVisitor myVisitor;
    private final CidrTestEventProcessor myEventProcessor;
    private volatile boolean myXMLStarted;
    private volatile boolean myXMLParserInAction;
    private volatile String myProcessFinishedMessage;
    private final ExecutionConsole myConsole;
    private final String myTargetName;
    private static final String TAGS = StringUtil.join((String[])ALL_TAGS, (String)"|");
    private static final Pattern OPEN_TAG = Pattern.compile(String.format("([^\\n]*)(\\s*<(%s)(?: (?:%s)\\=\"[^\"]*\")*\\/?>\\n)", TAGS, StringUtil.join((String[])ALL_ATTRS, (String)"|")));
    private static final Pattern CLOSE_TAG = Pattern.compile(String.format("([^\\n]*)(\\s*</(%s)>\\n)", TAGS));
    private final BooleanStack myPrintfHolderStack;

    public CidrDoctestOutputToGeneralTestEventsConverter(@NotNull @NonNls String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ExecutionConsole console, @Nullable @NonNls String targetName) {
        if (testFrameworkName == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (console == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        super(testFrameworkName, consoleProperties);
        this.myXMLStarted = false;
        this.myXMLParserInAction = true;
        this.myPrintfHolderStack = new BooleanStack();
        this.myConsole = console;
        this.myEventProcessor = new CidrTestEventProcessor(DOCTEST_TAG);
        this.myTargetName = targetName;
    }

    protected void process(@NotNull List<ServiceMessageBuilder> messages) {
        if (messages == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        try {
            for (ServiceMessageBuilder each : messages) {
                super.processServiceMessages(each.toString(), ProcessOutputTypes.STDOUT, this.myVisitor);
            }
        }
        catch (Exception e) {
            CidrTestLog.LOG.error(e.getMessage());
        }
    }

    protected boolean processServiceMessages(@NotNull String text, @NotNull Key outputType, @NotNull ServiceMessageVisitor visitor) {
        if (text == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(4);
        }
        if (outputType == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(5);
        }
        if (visitor == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(6);
        }
        CidrOutputToGeneralTestEventsConverter.logOutput((String)text, (Key)outputType);
        this.myVisitor = visitor;
        if (!this.myXMLStarted && CidrDoctestOutputToGeneralTestEventsConverter.isXMLHeader(text)) {
            this.myXMLStarted = true;
        }
        if (ProcessOutputType.isStdout((Key)outputType) && this.myXMLStarted && this.myXMLParserInAction) {
            try {
                if (this.myXMLParser == null) {
                    this.myPipedOutStream = new PipedOutputStream();
                    PipedInputStream pipedInStream = new PipedInputStream(this.myPipedOutStream);
                    this.myXMLParser = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        boolean success = false;
                        try {
                            SAXParserFactory.newInstance().newSAXParser().parse((InputStream)pipedInStream, this.createHandler());
                            success = true;
                        }
                        catch (SAXParseException sax) {
                            CidrTestLog.LOG.debug((Throwable)sax);
                        }
                        catch (IOException | ParserConfigurationException e) {
                            if ("Pipe broken".equals(e.getMessage())) {
                                CidrTestLog.LOG.debug((Throwable)e);
                            } else {
                                CidrTestLog.LOG.error((Throwable)e);
                            }
                        }
                        finally {
                            try {
                                pipedInStream.close();
                            }
                            catch (IOException e) {
                                CidrTestLog.LOG.debug((Throwable)e);
                            }
                            this.myXMLParserInAction = false;
                        }
                        return success;
                    });
                }
                this.processLine(text);
                return true;
            }
            catch (IOException e) {
                this.myXMLParserInAction = false;
                CidrTestLog.LOG.error((Throwable)e);
            }
        } else if (outputType == ProcessOutputTypes.SYSTEM) {
            if (CidrOutputToGeneralTestEventsConverter.PROCESS_FINISHED_PATTERN.matcher(text).matches()) {
                this.myProcessFinishedMessage = text;
                return true;
            }
            if (text.equals("\n")) {
                return true;
            }
        }
        return false;
    }

    private void processLine(@NonNls @NotNull String text) throws IOException {
        String trimmed;
        if (text == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(7);
        }
        if ((trimmed = text.trim()).startsWith("<TestCase") && trimmed.endsWith(" skipped=\"true\"/>")) {
            this.processLine(trimmed.substring(0, trimmed.length() - "/>".length()) + ">\n");
            this.processLine("</TestCase>\n");
            return;
        }
        if (CidrDoctestOutputToGeneralTestEventsConverter.isXMLHeader(text)) {
            this.passToParser(text);
        } else {
            boolean isInPrintfTag = !this.myPrintfHolderStack.isEmpty() && this.myPrintfHolderStack.peek();
            Matcher m = OPEN_TAG.matcher(text);
            if (m.matches()) {
                this.processTag(isInPrintfTag, true, m);
            } else {
                m = CLOSE_TAG.matcher(text);
                if (m.matches()) {
                    this.processTag(isInPrintfTag, false, m);
                } else {
                    this.processFreeText(isInPrintfTag, text);
                }
            }
        }
        this.myPipedOutStream.flush();
    }

    @Contract(pure=true)
    private static boolean isXMLHeader(@NonNls @Nullable String text) {
        return text != null && text.startsWith("<?xml version=");
    }

    private void processTag(boolean isInPrintfTag, boolean isOpenTag, @NotNull Matcher m) throws IOException {
        if (m == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(8);
        }
        String freeText = m.group(1);
        String tagContext = m.group(2);
        String tagName = m.group(3);
        this.processFreeText(isInPrintfTag, freeText.trim());
        if (isOpenTag) {
            this.myPrintfHolderStack.push(CidrDoctestOutputToGeneralTestEventsConverter.isPrintfHolder(tagName));
        } else {
            this.myPrintfHolderStack.pop();
        }
        this.passToParser(tagContext);
    }

    private void processFreeText(boolean isInPrintfTag, @NotNull String freeText) throws IOException {
        if (freeText == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(9);
        }
        if (freeText.length() == 0) {
            return;
        }
        this.passToParser(isInPrintfTag ? String.format("<%s>%s</%s>", TEXT_TAG, StringUtil.escapeXmlEntities((String)freeText), TEXT_TAG) : freeText);
    }

    private static boolean isPrintfHolder(@NotNull String tag) {
        if (tag == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(10);
        }
        return TEST_CASE_TAG.equals(tag) || SUBCASE_TAG.equals(tag);
    }

    private void passToParser(@NonNls @NotNull String openTagContext) throws IOException {
        if (openTagContext == null) {
            CidrDoctestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(11);
        }
        this.myPipedOutStream.write(openTagContext.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBufferOnProcessTermination(int exitCode) {
        CidrTestLog.LOG.debug("flushBufferOnProcessTermination");
        if (this.myPipedOutStream != null) {
            try {
                this.myPipedOutStream.close();
            }
            catch (IOException e) {
                CidrTestLog.LOG.debug((Throwable)e);
            }
            finally {
                this.myPipedOutStream = null;
            }
        }
        if (this.myXMLParser != null) {
            try {
                GeneralTestEventsProcessor processor;
                Boolean isSuccessXMLParsing = this.myXMLParser.get();
                if (CidrTestLog.LOG.isDebugEnabled()) {
                    CidrTestLog.LOG.debug("parsing finished:" + isSuccessXMLParsing.toString());
                }
                if ((processor = this.getProcessor()) != null && this.myProcessFinishedMessage != null) {
                    processor.onUncapturedOutput(this.myProcessFinishedMessage, ProcessOutputTypes.SYSTEM);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                CidrTestLog.LOG.error((Throwable)e);
            }
            finally {
                this.myXMLParser = null;
                this.myXMLParserInAction = false;
            }
        }
        this.transferTextToConsoleViewInTest();
        super.flushBufferOnProcessTermination(exitCode);
    }

    private void transferTextToConsoleViewInTest() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ((ConsoleViewImpl)((SMTRunnerConsoleView)this.myConsole).getConsole()).waitAllRequests());
        }
    }

    @NotNull
    @Contract(pure=true)
    private DefaultHandler createHandler() {
        return new DefaultHandler(){
            static final String ROOT_NODE_ID = "0";
            final Map<String, String> myRenamedClosedNodeIds = new HashMap<String, String>();
            final Stack<TestState> myTestStatesStack = new Stack();
            final HashMap<String, TestEnd> myTestResults = new HashMap();
            final StringBuilder myInfoMessageWithNewLineAndIndent = new StringBuilder();
            String myExpressionPrefix;
            boolean myInErrorExpression = false;
            String myMessageType = "";
            final StringBuilder myText = new StringBuilder();
            boolean mySuccess = true;
            long myStartTimeInMs;
            TestState myPostponedSuite = null;
            final Stack<String> mySectionsEndIdStack = new Stack();

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                GeneralTestEventsProcessor processor = CidrDoctestOutputToGeneralTestEventsConverter.this.getProcessor();
                if (processor == null) {
                    CidrTestLog.LOG.debug("startElement: processor was disposed");
                    return;
                }
                this.myText.setLength(0);
                if (CidrTestLog.LOG.isDebugEnabled()) {
                    CidrTestLog.LOG.debug("{startElement" + qName);
                }
                if (CidrDoctestOutputToGeneralTestEventsConverter.TEST_SUITE_TAG.equals(qName) || CidrDoctestOutputToGeneralTestEventsConverter.TEST_CASE_TAG.equals(qName) || CidrDoctestOutputToGeneralTestEventsConverter.SUBCASE_TAG.equals(qName)) {
                    this.startTest(processor, attributes, CidrDoctestOutputToGeneralTestEventsConverter.TEST_SUITE_TAG.equals(qName));
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.OVERALL_RESULT_ASSERTS_TAG.equals(qName)) {
                    this.mySuccess &= ROOT_NODE_ID.equals(attributes.getValue(CidrDoctestOutputToGeneralTestEventsConverter.FAILURES_ATTR));
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.OVERALL_RESULTS_TEST_CASES_TAG.equals(qName)) {
                    this.mySuccess &= ROOT_NODE_ID.equals(attributes.getValue(CidrDoctestOutputToGeneralTestEventsConverter.FAILURES_ATTR));
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.EXPRESSION_TAG.equals(qName) && !"true".equals(attributes.getValue(CidrDoctestOutputToGeneralTestEventsConverter.SUCCESS_ATTR))) {
                    this.reportError(processor, attributes, "");
                    this.myExpressionPrefix = attributes.getValue(CidrDoctestOutputToGeneralTestEventsConverter.TYPE_ATTR);
                    this.myInErrorExpression = true;
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.EXCEPTION_TAG.equals(qName) && !this.myInErrorExpression) {
                    this.myMessageType = "true".equals(attributes.getValue(CidrDoctestOutputToGeneralTestEventsConverter.CRASH_ATTR)) ? "test case CRASHED:" : "test case THREW exception:";
                    this.reportError(processor, attributes, "");
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.MESSAGE_TAG.equals(qName)) {
                    this.myMessageType = StringUtil.notNullize((String)attributes.getValue(CidrDoctestOutputToGeneralTestEventsConverter.TYPE_ATTR));
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                this.myText.append(ch, start, length);
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                GeneralTestEventsProcessor processor = CidrDoctestOutputToGeneralTestEventsConverter.this.getProcessor();
                if (processor == null) {
                    CidrTestLog.LOG.debug("endElement: processor was disposed");
                    return;
                }
                if (CidrTestLog.LOG.isDebugEnabled()) {
                    CidrTestLog.LOG.debug("}endElement " + qName);
                }
                if (CidrDoctestOutputToGeneralTestEventsConverter.TEST_SUITE_TAG.equals(qName) || CidrDoctestOutputToGeneralTestEventsConverter.TEST_CASE_TAG.equals(qName) || CidrDoctestOutputToGeneralTestEventsConverter.SUBCASE_TAG.equals(qName)) {
                    this.endTest(processor);
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.TEXT_TAG.equals(qName)) {
                    boolean toStd = !this.myMessageType.contains("ERROR");
                    this.outMessage(processor, (String)(this.myMessageType.isEmpty() ? "" : this.myMessageType + ": ") + this.myText.toString().trim() + "\n", toStd);
                    this.myText.setLength(0);
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.INFO_TAG.equals(qName)) {
                    this.addInfo(this.myText.toString());
                    this.myText.setLength(0);
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.ORIGINAL_TAG.equals(qName)) {
                    this.outMessage(processor, CidrDoctestOutputToGeneralTestEventsConverter.OUT_INDENT + StringUtil.notNullize((String)this.myExpressionPrefix) + "(" + this.myText.toString().trim() + ")", false);
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.EXPRESSION_TAG.equals(qName)) {
                    this.myExpressionPrefix = null;
                    this.myInErrorExpression = false;
                    if (this.myInfoMessageWithNewLineAndIndent.length() != 0) {
                        this.outMessageWithInfoHeader(processor, "with message:", false);
                    }
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.EXCEPTION_TAG.equals(qName)) {
                    this.outMessageWithInfoHeader(processor, this.myMessageType, false);
                    this.myMessageType = "";
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.EXPANDED_TAG.equals(qName)) {
                    @NonNls StringBuilder message = new StringBuilder();
                    @NonNls String expansion = this.myText.toString().trim();
                    this.myText.setLength(0);
                    if (expansion.length() != 0) {
                        message.append("\nwith expansion:\n").append(CidrDoctestOutputToGeneralTestEventsConverter.OUT_INDENT).append(expansion);
                    }
                    if (this.myInfoMessageWithNewLineAndIndent.length() != 0) {
                        message.append("\nwith message:").append((CharSequence)this.myInfoMessageWithNewLineAndIndent);
                        this.myInfoMessageWithNewLineAndIndent.setLength(0);
                    }
                    message.append('\n');
                    this.outMessage(processor, message.toString(), false);
                } else if (CidrDoctestOutputToGeneralTestEventsConverter.MESSAGE_TAG.equals(qName)) {
                    boolean toStd = !this.myMessageType.contains("ERROR");
                    this.mySuccess &= toStd;
                    if (this.myInfoMessageWithNewLineAndIndent.length() != 0) {
                        this.outMessageWithInfoHeader(processor, "with message:", toStd);
                    }
                    this.myMessageType = "";
                }
            }

            private void addInfo(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myInfoMessageWithNewLineAndIndent.append("\n").append(CidrDoctestOutputToGeneralTestEventsConverter.OUT_INDENT).append(text.trim());
            }

            private void outMessageWithInfoHeader(GeneralTestEventsProcessor processor, @NonNls String header, boolean std) {
                this.addInfo(this.myText.toString());
                this.myText.setLength(0);
                String message = header + this.myInfoMessageWithNewLineAndIndent + "\n";
                this.myInfoMessageWithNewLineAndIndent.setLength(0);
                this.outMessage(processor, message, std);
            }

            private void outMessage(GeneralTestEventsProcessor processor, String message, boolean toStd) {
                String testName = this.getCurrentNodePresentableName();
                String nodeId = this.getCurrentNodeId();
                CidrDoctestOutputToGeneralTestEventsConverter.this.process(toStd ? CidrDoctestOutputToGeneralTestEventsConverter.this.myEventProcessor.testStdOut(testName, nodeId, message) : CidrDoctestOutputToGeneralTestEventsConverter.this.myEventProcessor.testErrOut(testName, nodeId, message));
            }

            private void reportError(@NotNull GeneralTestEventsProcessor processor, @NotNull Attributes attributes, @NotNull String message) {
                if (processor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (attributes == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(3);
                }
                assert (processor instanceof GeneralIdBasedToSMTRunnerEventsConvertor);
                this.mySuccess = false;
                @NonNls String file = attributes.getValue(CidrDoctestOutputToGeneralTestEventsConverter.FILE_NAME_ATTR);
                @NonNls String line = attributes.getValue(CidrDoctestOutputToGeneralTestEventsConverter.LINE_ATTR);
                @NonNls String prefix = file == null || line == null ? "Failure:" : String.format("%s:%s: Failure:", file, line);
                ((GeneralIdBasedToSMTRunnerEventsConvertor)processor).onError(this.getCurrentNodeId(), "", prefix + message, false);
            }

            private void startTest(GeneralTestEventsProcessor processor, @NotNull Attributes _attributes, boolean isSuite) {
                if (_attributes == null) {
                    1.$$$reportNull$$$0(4);
                }
                Map<String, String> attributes = this.createMap(_attributes);
                boolean skipped = this.isSkipped(attributes);
                if (isSuite) {
                    this.myPostponedSuite = null;
                } else if (!skipped && this.myPostponedSuite != null) {
                    CidrDoctestOutputToGeneralTestEventsConverter.this.process(CidrDoctestOutputToGeneralTestEventsConverter.this.myEventProcessor.testStarted(this.getPresentableNodeName(this.myPostponedSuite.myAttributes), this.myPostponedSuite.myParentId, this.getCurrentNodeId(), this.getLocationFromId(), this.getMetainfo(this.myPostponedSuite.myAttributes)));
                    this.myPostponedSuite = null;
                }
                String parentId = this.getCurrentNodeId();
                this.myTestStatesStack.push(new TestState(parentId, attributes, this.mySuccess, this.myStartTimeInMs));
                this.mySuccess = true;
                this.myStartTimeInMs = System.currentTimeMillis();
                if (isSuite) {
                    this.myPostponedSuite = this.myTestStatesStack.peek();
                    return;
                }
                if (skipped) {
                    return;
                }
                String nodeId = this.getCurrentNodeId();
                if (this.mySectionsEndIdStack.size() != 0) {
                    if (nodeId.equals(this.mySectionsEndIdStack.peek())) {
                        this.mySectionsEndIdStack.pop();
                        return;
                    }
                    this.closeAllOpenSections(processor);
                }
                String location = this.getLocationFromId();
                CidrDoctestOutputToGeneralTestEventsConverter.this.process(CidrDoctestOutputToGeneralTestEventsConverter.this.myEventProcessor.testStarted(this.getPresentableNodeName(attributes), parentId, nodeId, location, this.getMetainfo(attributes)));
            }

            private Map<String, String> createMap(Attributes attributes) {
                String[] attrs;
                HashMap<String, String> ret = new HashMap<String, String>();
                for (String attr : attrs = new String[]{CidrDoctestOutputToGeneralTestEventsConverter.LINE_ATTR, CidrDoctestOutputToGeneralTestEventsConverter.SKIPPED_ATTR, CidrDoctestOutputToGeneralTestEventsConverter.NAME_ATTR}) {
                    ret.put(attr, attributes.getValue(attr));
                }
                return ret;
            }

            private boolean isSkipped(@NotNull Map<String, String> attributes) {
                if (attributes == null) {
                    1.$$$reportNull$$$0(5);
                }
                return "true".equals(attributes.get(CidrDoctestOutputToGeneralTestEventsConverter.SKIPPED_ATTR));
            }

            @NonNls
            @NotNull
            private String getMetainfo(@NotNull Map<String, String> attributes) {
                if (attributes == null) {
                    1.$$$reportNull$$$0(6);
                }
                String string = CidrMetaParam.serialize((Pair[])new Pair[]{Pair.pair((Object)"target", (Object)CidrDoctestOutputToGeneralTestEventsConverter.this.myTargetName), Pair.pair((Object)CidrDoctestOutputToGeneralTestEventsConverter.LINE_ATTR, (Object)attributes.get(CidrDoctestOutputToGeneralTestEventsConverter.LINE_ATTR))});
                if (string == null) {
                    1.$$$reportNull$$$0(7);
                }
                return string;
            }

            @NotNull
            private String getPresentableNodeName(@NotNull Map<String, String> attributes) {
                if (attributes == null) {
                    1.$$$reportNull$$$0(8);
                }
                String string = StringUtil.notNullize((String)attributes.get(CidrDoctestOutputToGeneralTestEventsConverter.NAME_ATTR), (String)CidrDoctestTestLinker.getNoName());
                if (string == null) {
                    1.$$$reportNull$$$0(9);
                }
                return string;
            }

            @NotNull
            private String getPatternNodeName(@NotNull Map<String, String> attributes) {
                if (attributes == null) {
                    1.$$$reportNull$$$0(10);
                }
                String string = StringUtil.notNullize((String)attributes.get(CidrDoctestOutputToGeneralTestEventsConverter.NAME_ATTR));
                if (string == null) {
                    1.$$$reportNull$$$0(11);
                }
                return string;
            }

            private void endTest(GeneralTestEventsProcessor processor) {
                String nodeId = this.getCurrentNodeId();
                TestState testState = this.myTestStatesStack.pop();
                Runnable resetCurrentState = () -> {
                    this.mySuccess &= testState.mySuccess;
                    this.myStartTimeInMs = testState.myStartTimeInMs;
                };
                if (testState == this.myPostponedSuite || this.isSkipped(testState.myAttributes)) {
                    resetCurrentState.run();
                    return;
                }
                int duration = (int)(System.currentTimeMillis() - this.myStartTimeInMs);
                TestEnd end = this.myTestResults.get(nodeId);
                if (end == null) {
                    this.myTestResults.put(nodeId, new TestEnd(this.getPresentableNodeName(testState.myAttributes), nodeId, duration, this.mySuccess));
                } else {
                    end.update(duration, this.mySuccess);
                }
                resetCurrentState.run();
                this.mySectionsEndIdStack.push(nodeId);
                String parentId = this.getCurrentNodeId();
                if (ROOT_NODE_ID.equals(parentId) && this.mySectionsEndIdStack.size() != 0) {
                    this.closeAllOpenSections(processor);
                }
            }

            private void closeAllOpenSections(GeneralTestEventsProcessor processor) {
                this.mySectionsEndIdStack.forEach(endNodeId -> {
                    TestEnd end = this.myTestResults.get(endNodeId);
                    assert (end != null);
                    end.processEnd(processor);
                    this.myTestResults.remove(endNodeId);
                });
                this.mySectionsEndIdStack.clear();
            }

            @NotNull
            private String getLocationFromId() {
                String nodeId = this.getCurrentNodeId();
                String string = nodeId.equals(ROOT_NODE_ID) ? "" : nodeId.substring(ROOT_NODE_ID.length());
                if (string == null) {
                    1.$$$reportNull$$$0(12);
                }
                return string;
            }

            @NotNull
            private String getCurrentNodePresentableName() {
                return this.getPresentableNodeName(this.myTestStatesStack.peek().myAttributes);
            }

            @NotNull
            private String getCurrentNodeId() {
                StringBuilder path = new StringBuilder();
                path.append(ROOT_NODE_ID);
                this.myTestStatesStack.forEach(testState -> path.append('[').append(CidrDoctestTestLinker.escapeCommandChars(this.getPatternNodeName(testState.myAttributes))).append(']'));
                String id = path.toString();
                while (this.myRenamedClosedNodeIds.containsKey(id)) {
                    id = this.myRenamedClosedNodeIds.get(id);
                }
                String string = id;
                if (string == null) {
                    1.$$$reportNull$$$0(13);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attributes";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "_attributes";
                        break;
                    }
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestOutputToGeneralTestEventsConverter$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestOutputToGeneralTestEventsConverter$1";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMetainfo";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableNodeName";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPatternNodeName";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocationFromId";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCurrentNodeId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "addInfo";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "reportError";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "startTest";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "isSkipped";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getMetainfo";
                        break;
                    }
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableNodeName";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "getPatternNodeName";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }

            class TestEnd {
                final String myNodePresentableName;
                final String myNodeId;
                int myDurationInMs;
                boolean mySuccess;

                @Contract(pure=true)
                TestEnd(@NotNull String nodePresentableName, String nodeId, int durationInMs, boolean success) {
                    if (nodePresentableName == null) {
                        TestEnd.$$$reportNull$$$0(0);
                    }
                    if (nodeId == null) {
                        TestEnd.$$$reportNull$$$0(1);
                    }
                    this.myNodePresentableName = nodePresentableName;
                    this.myNodeId = nodeId;
                    this.myDurationInMs = durationInMs;
                    this.mySuccess = success;
                }

                void update(int durationInMs, boolean success) {
                    this.myDurationInMs += durationInMs;
                    this.mySuccess &= success;
                }

                void processEnd(GeneralTestEventsProcessor processor) {
                    myRenamedClosedNodeIds.put(this.myNodeId, this.myNodeId + "[cidr#reopen]");
                    CidrDoctestOutputToGeneralTestEventsConverter.this.process(CidrDoctestOutputToGeneralTestEventsConverter.this.myEventProcessor.testFinished(this.myNodePresentableName, this.myNodeId, Integer.toString(this.myDurationInMs), this.mySuccess));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "nodePresentableName";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "nodeId";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestOutputToGeneralTestEventsConverter$1$TestEnd";
                    objectArray[2] = "<init>";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }

            class TestState {
                final String myParentId;
                @NotNull
                final Map<String, String> myAttributes;
                final boolean mySuccess;
                final long myStartTimeInMs;

                TestState(@NotNull String parentId, Map<String, String> attributes, boolean success, long startTimeInMs) {
                    if (parentId == null) {
                        TestState.$$$reportNull$$$0(0);
                    }
                    if (attributes == null) {
                        TestState.$$$reportNull$$$0(1);
                    }
                    this.myParentId = parentId;
                    this.myAttributes = attributes;
                    this.mySuccess = success;
                    this.myStartTimeInMs = startTimeInMs;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "parentId";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "attributes";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestOutputToGeneralTestEventsConverter$1$TestState";
                    objectArray[2] = "<init>";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "freeText";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openTagContext";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/doctest/CidrDoctestOutputToGeneralTestEventsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processServiceMessages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processLine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processTag";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processFreeText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrintfHolder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "passToParser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

