/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css;

import com.intellij.FileIntPropertyPusher;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.css.CssFileType;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDialectPusher
implements FileIntPropertyPusher<String> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("css_dialect_persistence", 2, true);
    private static final VfsDependentEnum<String> CSS_DIALECT_ENUMERATOR = new VfsDependentEnum("css_dialects", (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 1);

    @NotNull
    public Key<String> getFileDataKey() {
        Key<String> key = CssDialectMappings.CSS_DIALECT_NAME_KEY;
        if (key == null) {
            CssDialectPusher.$$$reportNull$$$0(0);
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    @NotNull
    public String getDefaultValue() {
        String string = CssDialect.CLASSIC.getName();
        if (string == null) {
            CssDialectPusher.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(2);
        }
        if (file != null && file.isDirectory()) {
            String immediateMapping = (String)CssDialectMappings.getInstance(project).getImmediateMapping(file);
            if (immediateMapping != null) {
                return immediateMapping;
            }
            if (ProjectRootsUtil.isModuleContentRoot((VirtualFile)file, (Project)project)) {
                String projectImmediateMapping = (String)CssDialectMappings.getInstance(project).getImmediateMapping(null);
                if (projectImmediateMapping != null) {
                    return null;
                }
                CssDialect defaultDialect = CssDialect.getDefaultDialect((Module)ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project));
                return defaultDialect != null ? defaultDialect.getName() : null;
            }
        }
        return (String)CssDialectMappings.getInstance(project).getImmediateMapping(file);
    }

    @Nullable
    public String getImmediateValue(@NotNull Module module) {
        if (module == null) {
            CssDialectPusher.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            CssDialectPusher.$$$reportNull$$$0(4);
        }
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(5);
        }
        return CssFileType.INSTANCE.equals(FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()));
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            CssDialectPusher.$$$reportNull$$$0(6);
        }
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(7);
        }
        return true;
    }

    @NotNull
    public FileAttribute getAttribute() {
        FileAttribute fileAttribute = PERSISTENCE;
        if (fileAttribute == null) {
            CssDialectPusher.$$$reportNull$$$0(8);
        }
        return fileAttribute;
    }

    public int toInt(@NotNull String dialectName) throws IOException {
        if (dialectName == null) {
            CssDialectPusher.$$$reportNull$$$0(9);
        }
        return CSS_DIALECT_ENUMERATOR.getId((Object)dialectName);
    }

    @NotNull
    public String fromInt(int val) throws IOException {
        String string = (String)CSS_DIALECT_ENUMERATOR.getById(val);
        if (string == null) {
            CssDialectPusher.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull String actualProperty) {
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(11);
        }
        if (fileOrDir == null) {
            CssDialectPusher.$$$reportNull$$$0(12);
        }
        if (actualProperty == null) {
            CssDialectPusher.$$$reportNull$$$0(13);
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, file -> this.acceptsFile((VirtualFile)file, project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/CssDialectPusher";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/CssDialectPusher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttribute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInt";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toInt";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

